/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.ide.eclipse.as.core.util.RegExUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.FileExistsConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IGitCloningPageModel;

public class GitCloningWizardPage
extends AbstractOpenShiftWizardPage {
    private IGitCloningPageModel model;
    private CloneDestinationPathValidator cloneDestinationPathValidator;

    public GitCloningWizardPage(IWizard wizard, IGitCloningPageModel model) {
        super(GitCloningWizardPage.getTitle(model), "Configure the cloning settings by specifying the clone destination", "Cloning settings", wizard);
        this.model = model;
    }

    private static String getTitle(IGitCloningPageModel model) {
        String name = model == null ? null : model.getApplicationName();
        return name == null ? "Import an existing OpenShift application" : NLS.bind((String)"Import the {0} OpenShift application", (Object)name);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite cloneGroup = this.createCloneGroup(parent, dbc);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)cloneGroup);
    }

    private Composite createCloneGroup(Composite parent, DataBindingContext dbc) {
        Group cloneGroup = new Group(parent, 0);
        cloneGroup.setText("Clone destination");
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)cloneGroup);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)cloneGroup);
        Composite cloneGroupComposite = new Composite((Composite)cloneGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)cloneGroupComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(cloneGroupComposite);
        Button useDefaultCloneDestinationButton = new Button(cloneGroupComposite, 32);
        useDefaultCloneDestinationButton.setText("Use default clone destination");
        useDefaultCloneDestinationButton.setToolTipText("Uncheck if you want to use a custom location to clone to");
        GridDataFactory.fillDefaults().span(3, 1).align(16384, 0x1000000).applyTo((Control)useDefaultCloneDestinationButton);
        IObservableValue useDefaultCloneDestinationObservable = BeanProperties.value((String)"useDefaultCloneDestination").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)useDefaultCloneDestinationButton)).to(useDefaultCloneDestinationObservable).in(dbc);
        Label repoPathLabel = new Label(cloneGroupComposite, 0);
        repoPathLabel.setText("Git Clone Location:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)repoPathLabel);
        Text cloneDestinationText = new Text(cloneGroupComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cloneDestinationText);
        ISWTObservableValue cloneDestinationObservable = WidgetProperties.text((int)24).observe((Widget)cloneDestinationText);
        IObservableValue cloneDestinationModelObservable = BeanProperties.value((String)"cloneDestination").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)cloneDestinationObservable).to(cloneDestinationModelObservable).in(dbc);
        Button browseCloneDestinationButton = new Button(cloneGroupComposite, 8);
        browseCloneDestinationButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)browseCloneDestinationButton);
        browseCloneDestinationButton.addSelectionListener(this.onCloneDestination());
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)cloneDestinationText)).notUpdating(useDefaultCloneDestinationObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)browseCloneDestinationButton)).notUpdating(useDefaultCloneDestinationObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        UIUtils.focusOnSelection((Button)useDefaultCloneDestinationButton, (Text)cloneDestinationText);
        Button reuseRepositoryButton = new Button(cloneGroupComposite, 32);
        reuseRepositoryButton.setSelection(false);
        reuseRepositoryButton.setText("Do not clone - use existing repository");
        GridDataFactory.fillDefaults().span(3, 1).align(16384, 0x1000000).applyTo((Control)reuseRepositoryButton);
        ISWTObservableValue reuseGitReposityObservable = WidgetProperties.selection().observe((Widget)reuseRepositoryButton);
        ValueBindingBuilder.bind((IObservableValue)reuseGitReposityObservable).to(BeanProperties.value((String)"reuseGitRepository").observe((Object)this.model)).in(dbc);
        IObservableValue repoPathObservable = BeanProperties.value((String)"repoPath").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)reuseRepositoryButton)).notUpdating(repoPathObservable).converting((IConverter)new FileExistsConverter())).in(dbc);
        final ISWTObservableValue reuseRepoButtonEnabled = WidgetProperties.enabled().observe((Widget)reuseRepositoryButton);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)reuseRepoButtonEnabled).notUpdating(repoPathObservable).converting((IConverter)new Converter(File.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof File && EGitUtils.isRepository((File)((File)fromObject))) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        this.cloneDestinationPathValidator = new CloneDestinationPathValidator((IObservableValue<Boolean>)useDefaultCloneDestinationObservable, (IObservableValue<String>)cloneDestinationObservable, (IObservableValue<Boolean>)reuseGitReposityObservable, (IObservableValue<File>)repoPathObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.cloneDestinationPathValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)this.cloneDestinationPathValidator, (int)16512);
        Composite checkoutComposite = new Composite(cloneGroupComposite, 0);
        GridDataFactory.fillDefaults().span(3, 1).indent(20, -1).align(4, 4).grab(true, true).applyTo((Control)checkoutComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(checkoutComposite);
        final Button checkoutBranchCheckbox = new Button(checkoutComposite, 32);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)checkoutBranchCheckbox);
        final ISWTObservableValue checkoutBranchCheckboxObservable = WidgetProperties.selection().observe((Widget)checkoutBranchCheckbox);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)checkoutBranchCheckboxObservable).validatingAfterConvert((IValidator)new CheckoutBranchValidator())).to(BeanProperties.value((String)"checkoutBranchReusedRepo").observe((Object)this.model)).validatingAfterConvert((IValidator)new CheckoutBranchValidator())).in(dbc);
        final IObservableValue isRepositoryBranchGitRefObservable = BeanProperties.value((String)"repositoryBranchGitRef").observe((Object)this.model);
        ComputedValue<Boolean> checkoutBranchEnablement = new ComputedValue<Boolean>((IObservableValue)reuseGitReposityObservable){
            private final /* synthetic */ IObservableValue val$reuseGitReposityObservable;
            {
                this.val$reuseGitReposityObservable = iObservableValue2;
            }

            protected Boolean calculate() {
                Boolean isReuseRepoButtonEnabled = (Boolean)reuseRepoButtonEnabled.getValue();
                Boolean isRepositoryBranchGitRef = (Boolean)isRepositoryBranchGitRefObservable.getValue();
                Boolean isReuseGitRepository = (Boolean)this.val$reuseGitReposityObservable.getValue();
                if (isReuseRepoButtonEnabled.booleanValue() && !isRepositoryBranchGitRef.booleanValue() && isReuseGitRepository.booleanValue()) {
                    return true;
                }
                return false;
            }
        };
        final Label checkoutBranchLabel = new Label(checkoutComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)checkoutBranchLabel);
        checkoutBranchLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                checkoutBranchCheckboxObservable.setValue((Object)(!checkoutBranchCheckbox.getSelection() ? 1 : 0));
            }
        });
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text().observe((Widget)checkoutBranchLabel)).notUpdating(BeanProperties.value((String)"gitRef").observe((Object)this.model)).converting((IConverter)new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                return "Check out branch " + fromObject;
            }
        })).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)new WritableValue<Boolean>(){

            public void doSetValue(Boolean value) {
                checkoutBranchCheckbox.setEnabled(value.booleanValue());
                checkoutBranchLabel.setEnabled(value.booleanValue());
            }
        }).notUpdating((IObservableValue)checkoutBranchEnablement).in(dbc);
        return cloneGroup;
    }

    private SelectionListener onCloneDestination() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(GitCloningWizardPage.this.getShell());
                dialog.setText("Git clone location");
                dialog.setMessage("Choose the location for git clone...");
                dialog.setFilterPath(GitCloningWizardPage.this.model.getCloneDestination());
                String repositoryPath = dialog.open();
                if (repositoryPath != null) {
                    GitCloningWizardPage.this.model.setCloneDestination(repositoryPath);
                }
            }
        };
    }

    protected void onPageActivated(DataBindingContext dbc) {
        if (this.cloneDestinationPathValidator != null) {
            this.cloneDestinationPathValidator.forceRevalidate();
        }
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)13, (WizardPage)this, (DataBindingContext)dbc);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setTitle(GitCloningWizardPage.getTitle(this.model));
        }
        super.setVisible(visible);
    }

    private class CheckoutBranchValidator
    implements IValidator {
        private CheckoutBranchValidator() {
        }

        public IStatus validate(Object value) {
            if (!(value instanceof Boolean)) {
                return ValidationStatus.ok();
            }
            boolean checkoutBranch = (Boolean)value;
            Repository repository = GitCloningWizardPage.this.model.getRepository();
            if (checkoutBranch && repository != null && !this.isCurrentBranch(GitCloningWizardPage.this.model.getGitRef(), repository)) {
                return ValidationStatus.warning((String)NLS.bind((String)"Branch {0} will be checked out in the reused git repository.\nPlease make sure it is clean.", (Object)GitCloningWizardPage.this.model.getGitRef()));
            }
            return ValidationStatus.ok();
        }

        private boolean isCurrentBranch(String gitRef, Repository repository) {
            if (StringUtils.isBlank((String)gitRef)) {
                return true;
            }
            try {
                String branch = EGitUtils.getCurrentBranch((Repository)repository);
                return gitRef.equals(branch);
            }
            catch (CoreException e) {
                OpenShiftUIActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"Could not get current branch in repository at {0} .", (Object)repository.getDirectory()), (Throwable)e));
                return false;
            }
        }
    }

    private class CloneDestinationPathValidator
    extends MultiValidator {
        private final IObservableValue<Boolean> useDefaultCloneDestinationObservable;
        private final IObservableValue<String> cloneDestinationObservable;
        private final IObservableValue<Boolean> reuseGitCloneObservable;
        private final IObservableValue<File> repoPathObservable;

        public CloneDestinationPathValidator(IObservableValue<Boolean> useDefaultCloneDestinationObservable, IObservableValue<String> cloneDestinationObservable, IObservableValue<Boolean> skipCloneObservable, IObservableValue<File> repoPathObservable) {
            this.useDefaultCloneDestinationObservable = useDefaultCloneDestinationObservable;
            this.cloneDestinationObservable = cloneDestinationObservable;
            this.reuseGitCloneObservable = skipCloneObservable;
            this.repoPathObservable = repoPathObservable;
        }

        protected IStatus validate() {
            this.useDefaultCloneDestinationObservable.getValue();
            String cloneDestination = (String)this.cloneDestinationObservable.getValue();
            Boolean reuseGitRepository = (Boolean)this.reuseGitCloneObservable.getValue();
            File repoPath = (File)this.repoPathObservable.getValue();
            Path cloneDestinationPath = new Path(cloneDestination);
            if (cloneDestinationPath.isEmpty() || !cloneDestinationPath.isAbsolute()) {
                return ValidationStatus.cancel((String)"You need to provide an absolute path that we'll clone to.");
            }
            if (!FileUtils.canWrite((String)cloneDestinationPath.toOSString())) {
                return ValidationStatus.error((String)NLS.bind((String)"The location {0} is not writeable.", (Object)cloneDestinationPath.toOSString()));
            }
            boolean cloneDestinationExists = FileUtils.exists((File)repoPath);
            if (reuseGitRepository.booleanValue()) {
                return this.validateReuseGitRepo(repoPath, (IPath)cloneDestinationPath, cloneDestinationExists);
            }
            return this.validateClone((IPath)cloneDestinationPath, cloneDestinationExists);
        }

        private IStatus validateClone(IPath cloneDestinationPath, boolean cloneDestinationExists) {
            if (cloneDestinationExists) {
                return ValidationStatus.error((String)NLS.bind((String)"There already is a folder named \"{0}\" in \"{1}\".\nPlease choose a different destination, or select 'Reuse existing repository'.", (Object)GitCloningWizardPage.this.model.getRepoName(), (Object)cloneDestinationPath.toOSString()));
            }
            return ValidationStatus.ok();
        }

        private IStatus validateReuseGitRepo(File repoPath, IPath cloneDestinationPath, boolean cloneDestinationExists) {
            if (!cloneDestinationExists) {
                return ValidationStatus.error((String)NLS.bind((String)"There is no folder named \"{0}\" in \"{1}\"\nPlease clone the repository or browse to a location containing the repository.", (Object)GitCloningWizardPage.this.model.getRepoName(), (Object)cloneDestinationPath.toOSString()));
            }
            if (!EGitUtils.isRepository((File)repoPath)) {
                return ValidationStatus.error((String)NLS.bind((String)"There already is a folder named \"{0}\" in \"{1}\" but it isnt a git repository.\nPlease remove this folder or use a different location.", (Object)GitCloningWizardPage.this.model.getRepoName(), (Object)cloneDestinationPath.toOSString()));
            }
            if (!this.hasRemoteUrl(GitCloningWizardPage.this.model.getGitUrl(), cloneDestinationPath)) {
                return ValidationStatus.warning((String)NLS.bind((String)"The reused git repository has no remote to {2}. It does not seem to match the source that is used in your OpenShift application.", (Object[])new String[]{GitCloningWizardPage.this.model.getRepoName(), cloneDestinationPath.toOSString(), GitCloningWizardPage.this.model.getGitUrl()}));
            }
            return ValidationStatus.ok();
        }

        private boolean hasRemoteUrl(String gitUrl, IPath repoResourcePath) {
            try {
                return EGitUtils.hasRemoteUrl((Pattern)Pattern.compile(RegExUtils.escapeRegex((String)gitUrl)), (Repository)GitCloningWizardPage.this.model.getRepository());
            }
            catch (CoreException e) {
                OpenShiftUIActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"Could not inspect remotes for git repo {0} at {1}.", (Object)GitCloningWizardPage.this.model.getCloneDestination(), (Object)repoResourcePath.toOSString()), (Throwable)e));
                return false;
            }
        }

        public void forceRevalidate() {
            this.revalidate();
        }
    }
}

