/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAwareWizard;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.BuildConfigWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.GitCloningWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportApplicationWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportJob;

public class ImportApplicationWizard
extends Wizard
implements IWorkbenchWizard,
IConnectionAwareWizard<Connection> {
    private ImportApplicationWizardModel model;
    private ImportJob importJob;
    private List<IJobChangeListener> importJobChangeListenersList = new ArrayList<IJobChangeListener>();

    public ImportApplicationWizard() {
        this.setWindowTitle("Import OpenShift Application");
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)OpenShiftCommonUIActivator.getDefault().getDialogSettings(), (String)"ImportApplicationWizard"));
        this.model = new ImportApplicationWizardModel();
        String repoPath = this.loadRepoPath();
        if (StringUtils.isNotBlank((String)repoPath)) {
            this.model.setCloneDestination(repoPath);
            this.model.setUseDefaultCloneDestination(false);
        }
    }

    public ImportApplicationWizard(Map<IProject, Collection<IBuildConfig>> projectsAndBuildConfigs) {
        this();
        if (projectsAndBuildConfigs != null && projectsAndBuildConfigs.size() == 1) {
            Map.Entry<IProject, Collection<IBuildConfig>> entry = projectsAndBuildConfigs.entrySet().iterator().next();
            IProject project = entry.getKey();
            this.setConnection(project);
            this.model.setProject(project);
            this.setSelectedItem(entry, project);
        }
    }

    private String loadRepoPath() {
        String path = this.getDialogSettings().get("repoPath");
        if (path == null) {
            IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)OpenShiftUIActivator.getDefault().getDialogSettings(), (String)"ImportApplicationWizard");
            path = settings.get("repoPath");
        }
        return path;
    }

    private void setConnection(IProject project) {
        Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)project);
        this.setModelConnection(connection);
    }

    private void setSelectedItem(Map.Entry<IProject, Collection<IBuildConfig>> entry, IProject project) {
        Collection<IBuildConfig> buildConfigs = entry.getValue();
        if (buildConfigs != null && buildConfigs.size() == 1) {
            this.model.setSelectedItem(buildConfigs.iterator().next());
        } else {
            this.model.setSelectedItem(project);
        }
    }

    public ImportApplicationWizardModel getModel() {
        return this.model;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.model.getConnection() != null && this.model.getSelectedItem() != null) {
            return;
        }
        Connection connection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        if (connection != null) {
            this.model.setConnection(connection);
        } else {
            IResource resource = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
            if (resource != null) {
                this.setModelConnection(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource));
                this.model.setSelectedItem(resource);
            } else {
                IProject project = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
                if (project != null) {
                    this.setModelConnection(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)project));
                    this.model.setSelectedItem(project);
                }
            }
        }
    }

    public void addPages() {
        if (this.model.getSelectedBuildConfig() == null) {
            this.addPage((IWizardPage)new BuildConfigWizardPage((IWizard)this, this.model));
        }
        this.addPage((IWizardPage)new GitCloningWizardPage((IWizard)this, this.model));
    }

    public boolean performFinish() {
        this.createImportJob(this.model.isReuseGitRepository());
        this.importJob.schedule();
        return true;
    }

    private void createImportJob(boolean reuseGitRepository) {
        this.importJob = reuseGitRepository ? new ImportJob(this.model.getGitUrl(), this.model.getGitRef(), this.model.getRepoPath(), this.model.isCheckoutBranchReusedRepo()) : new ImportJob(this.model.getGitUrl(), this.model.getGitRef(), this.model.getRepoPath());
        String gitContextDir = this.model.getGitContextDir();
        if (StringUtils.isNotEmpty((String)gitContextDir)) {
            this.importJob.setFilters(Collections.singleton(gitContextDir));
        }
        this.importJob.setUser(true);
        this.importJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                boolean success = JobUtils.isOk((IStatus)ImportApplicationWizard.this.importJob.getResult());
                if (success) {
                    ImportApplicationWizard.this.saveRepoPath();
                }
                UsageStats.getInstance().importV3Application(ImportApplicationWizard.this.model.getConnection().getHost(), success);
            }
        });
        for (IJobChangeListener importJobChangeListener : this.importJobChangeListenersList) {
            this.importJob.addJobChangeListener(importJobChangeListener);
        }
    }

    private void saveRepoPath() {
        if (!this.model.isUseDefaultCloneDestination()) {
            this.getDialogSettings().put("repoPath", this.model.getCloneDestination());
        } else {
            this.getDialogSettings().put("repoPath", "");
        }
    }

    public void addImportJobChangeListener(IJobChangeListener importJobChangeListener) {
        this.importJobChangeListenersList.add(importJobChangeListener);
    }

    public Connection getConnection() {
        return this.model.getConnection();
    }

    public boolean hasConnection() {
        return this.model.hasConnection();
    }

    public void setConnection(Connection connection) {
        this.model.setConnection(connection);
    }

    public Object getContext() {
        return null;
    }

    private void setModelConnection(Connection connection) {
        if (connection != null) {
            this.model.setConnection(connection);
        }
    }

    public ImportJob getImportJob() {
        return this.importJob;
    }

    public void dispose() {
        this.importJobChangeListenersList.clear();
        super.dispose();
    }
}

