/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.build.IGitBuildSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Repository;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.BuildConfigTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IBuildConfigPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IGitCloningPageModel;

public class ImportApplicationWizardModel
extends ObservableUIPojo
implements IBuildConfigPageModel,
IGitCloningPageModel {
    private Connection connection;
    private BuildConfigTreeItems.ConnectionTreeItem connectionItem;
    private Object selectedItem;
    private String cloneDestination;
    private boolean useDefaultCloneDestination = true;
    private String repoName;
    private IProject project;
    private boolean reuseGitRepo = false;
    private boolean checkoutBranchReusedRepo;
    private String repoPath;
    private Repository repository;
    private String gitContextDir;
    private List<ObservableTreeItem> buildConfigs = new ArrayList<ObservableTreeItem>();
    private boolean isRepositoryBranchGitRef;

    public ImportApplicationWizardModel() {
        this.cloneDestination = this.getDefaultCloneDestination();
    }

    private void update(Connection connection, Object selectedItem, String cloneDestination, boolean useDefaultCloneDestination, IProject project, boolean reuseGitRepo, boolean checkoutBranchReusedRepo, String gitContextDir) {
        this.connectionItem = this.updateConnection(connection);
        this.project = project;
        Object oldSelectedItem = this.selectedItem;
        this.updateSelectedItem(selectedItem);
        this.updateUseDefaultCloneDestination(useDefaultCloneDestination);
        this.updateCloneDestination(cloneDestination);
        IBuildConfig buildConfig = this.getBuildConfig(selectedItem);
        String repoName = this.updateRepoName(buildConfig);
        String oldRepoPath = this.repoPath;
        String newRepoPath = this.updateRepoPath(cloneDestination, repoName);
        reuseGitRepo = this.updateReuseGitRepo(reuseGitRepo, newRepoPath, oldRepoPath);
        String gitRef = this.updateGitRef(this.getGitRef(buildConfig));
        Repository repository = this.updateRepository(newRepoPath, oldRepoPath);
        boolean isRepositoryAtGitRef = this.updateIsRepositoryAtGitRef(gitRef, repository);
        this.updateCheckoutBranchReusedRepo(checkoutBranchReusedRepo, isRepositoryAtGitRef);
        this.updateGitContextDir(gitContextDir, buildConfig, this.getBuildConfig(oldSelectedItem));
    }

    private BuildConfigTreeItems.ConnectionTreeItem updateConnection(Connection connection) {
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
        return new BuildConfigTreeItems.ConnectionTreeItem(connection);
    }

    protected void updateSelectedItem(Object selectedItem) {
        this.selectedItem = selectedItem;
        this.firePropertyChange("selectedItem", this.selectedItem, this.selectedItem);
    }

    private String updateRepoName(IBuildConfig config) {
        String name = ImportApplicationWizardModel.getRepoName(config);
        if (name == null && this.getProject() != null) {
            name = this.getProject().getName();
        }
        this.repoName = name;
        this.firePropertyChange("repoName", this.repoName, this.repoName);
        return name;
    }

    private static String getRepoName(IBuildConfig config) {
        String repoName = null;
        if (config != null) {
            repoName = ResourceUtils.getProjectNameForURI((String)config.getSourceURI());
        }
        return repoName;
    }

    private void updateCloneDestination(String cloneDestination) {
        this.cloneDestination = cloneDestination;
        this.firePropertyChange("cloneDestination", this.cloneDestination, this.cloneDestination);
    }

    private String updateRepoPath(String repositoryPath, String repoName) {
        String repoPath = this.repoPath;
        if (StringUtils.isNotBlank((String)repositoryPath)) {
            Path cloneDestinationPath = new Path(repositoryPath);
            if (StringUtils.isNotBlank((String)repoName)) {
                cloneDestinationPath = cloneDestinationPath.append((IPath)new Path(repoName));
            }
            repoPath = cloneDestinationPath.toOSString();
        }
        this.repoPath = repoPath;
        this.firePropertyChange("repoPath", this.repoPath, this.repoPath);
        return repoPath;
    }

    private Repository updateRepository(String newRepoPath, String oldRepoPath) {
        Repository repository = this.repository;
        if (!StringUtils.equals((String)newRepoPath, (String)oldRepoPath)) {
            if (repository != null) {
                repository.close();
            }
            repository = EGitUtils.getRepository((File)this.getCloneDestination(newRepoPath));
        }
        this.repository = repository;
        return this.repository;
    }

    private boolean updateIsRepositoryAtGitRef(String gitRef, Repository cloneDestination) {
        boolean isCloneDestinationAtGitRef = this.isRepositoryBranchGitRef;
        String cloneDestinationBranch = null;
        if (cloneDestination == null) {
            return false;
        }
        try {
            cloneDestinationBranch = EGitUtils.getCurrentBranch((Repository)cloneDestination);
        }
        catch (CoreException coreException) {}
        this.isRepositoryBranchGitRef = isCloneDestinationAtGitRef = StringUtils.equals((String)gitRef, (String)cloneDestinationBranch);
        this.firePropertyChange("repositoryBranchGitRef", this.isRepositoryBranchGitRef, this.isRepositoryBranchGitRef);
        return isCloneDestinationAtGitRef;
    }

    private boolean updateReuseGitRepo(boolean reuseGitRepo, String newCloneDestination, String oldCloneloneDestination) {
        if (!Objects.equals(newCloneDestination, oldCloneloneDestination) && !FileUtils.exists((File)new File(newCloneDestination)) && reuseGitRepo) {
            reuseGitRepo = false;
        }
        this.reuseGitRepo = reuseGitRepo;
        this.firePropertyChange("reuseGitRepository", this.reuseGitRepo, this.reuseGitRepo);
        return reuseGitRepo;
    }

    private void updateCheckoutBranchReusedRepo(boolean checkoutBranchReusedRepo, boolean isCloneDestinationAtGitRef) {
        if (isCloneDestinationAtGitRef) {
            checkoutBranchReusedRepo = false;
        }
        this.checkoutBranchReusedRepo = checkoutBranchReusedRepo;
        this.firePropertyChange("checkoutBranchReusedRepo", this.checkoutBranchReusedRepo, this.checkoutBranchReusedRepo);
    }

    private void updateGitContextDir(String newGitContextDir, IBuildConfig newBuildConfig, IBuildConfig oldBuildConfig) {
        if (Objects.equals(newBuildConfig, oldBuildConfig)) {
            if (Objects.equals(newGitContextDir, this.gitContextDir)) {
                return;
            }
        } else {
            newGitContextDir = this.getGitContextDir(newBuildConfig);
        }
        this.gitContextDir = newGitContextDir;
        this.firePropertyChange("gitContextDir", this.gitContextDir, this.gitContextDir);
    }

    private String updateGitRef(String gitRef) {
        this.firePropertyChange("gitRef", null, gitRef);
        return gitRef;
    }

    @Override
    public IBuildConfig getSelectedBuildConfig() {
        return this.getBuildConfig(this.selectedItem);
    }

    private IBuildConfig getBuildConfig(Object item) {
        if (!(item instanceof IBuildConfig)) {
            return null;
        }
        return (IBuildConfig)item;
    }

    @Override
    public String getGitUrl() {
        IBuildConfig config = this.getSelectedBuildConfig();
        if (config == null) {
            return null;
        }
        return config.getSourceURI();
    }

    @Override
    public String getGitRef() {
        return this.getGitRef(this.getSelectedBuildConfig());
    }

    protected String getGitRef(IBuildConfig config) {
        String gitRef = null;
        if (config != null && config.getBuildSource() instanceof IGitBuildSource) {
            gitRef = ((IGitBuildSource)config.getBuildSource()).getRef();
        }
        return gitRef;
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        this.update(this.connection, selectedItem, this.cloneDestination, this.useDefaultCloneDestination, this.project, this.reuseGitRepo, this.checkoutBranchReusedRepo, this.gitContextDir);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setCloneDestination(String cloneDestination) {
        this.update(this.connection, this.selectedItem, cloneDestination, false, this.project, this.reuseGitRepo, this.checkoutBranchReusedRepo, this.gitContextDir);
    }

    @Override
    public String getCloneDestination() {
        return this.cloneDestination;
    }

    @Override
    public String getRepoName() {
        return this.repoName;
    }

    @Override
    public File getRepoPath() {
        return this.getCloneDestination(this.repoPath);
    }

    private File getCloneDestination(String cloneDestination) {
        return new Path(cloneDestination).toFile();
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isRepositoryBranchGitRef() {
        return this.isRepositoryBranchGitRef;
    }

    @Override
    public void setUseDefaultCloneDestination(boolean useDefaultCloneDestination) {
        this.update(this.connection, this.selectedItem, useDefaultCloneDestination ? this.getDefaultCloneDestination() : this.cloneDestination, useDefaultCloneDestination, this.project, this.reuseGitRepo, this.checkoutBranchReusedRepo, this.gitContextDir);
    }

    private String getDefaultCloneDestination() {
        return EGitUIUtils.getEGitDefaultRepositoryPath();
    }

    private void updateUseDefaultCloneDestination(boolean useDefault) {
        this.useDefaultCloneDestination = useDefault;
        this.firePropertyChange("useDefaultCloneDestination", this.useDefaultCloneDestination, this.useDefaultCloneDestination);
    }

    @Override
    public boolean isUseDefaultCloneDestination() {
        return this.useDefaultCloneDestination;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public void setConnection(Connection connection) {
        this.update(connection, this.selectedItem, this.cloneDestination, this.useDefaultCloneDestination, this.project, this.reuseGitRepo, this.checkoutBranchReusedRepo, this.gitContextDir);
    }

    @Override
    public List<ObservableTreeItem> getBuildConfigs() {
        return this.buildConfigs;
    }

    @Override
    public void loadBuildConfigs() {
        this.loadBuildConfigs(this.connectionItem);
    }

    public void loadBuildConfigs(BuildConfigTreeItems.ConnectionTreeItem connectionItem) {
        if (connectionItem == null) {
            return;
        }
        connectionItem.load();
        this.updateBuildConfigs(this.filterBuildConfigs(this.project, connectionItem.getChildren()));
    }

    private void updateBuildConfigs(List<ObservableTreeItem> newBuildConfigs) {
        if (newBuildConfigs == null || ListUtils.isEqualList(newBuildConfigs, this.buildConfigs)) {
            return;
        }
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.buildConfigs);
        ArrayList<ObservableTreeItem> newItems = new ArrayList<ObservableTreeItem>(newBuildConfigs);
        this.buildConfigs.clear();
        this.buildConfigs.addAll(newItems);
        this.firePropertyChange("buildConfigs", oldItems, newItems);
    }

    private List<ObservableTreeItem> filterBuildConfigs(IProject project, List<ObservableTreeItem> children) {
        List<ObservableTreeItem> result = children;
        if (project != null) {
            result = children.stream().filter(c -> project.equals(c.getModel())).map(p -> p.getChildren()).flatMap(l -> l.stream()).collect(Collectors.toList());
        }
        return result;
    }

    public Object getContext() {
        return null;
    }

    @Override
    public String getGitContextDir() {
        return this.gitContextDir;
    }

    protected String getGitContextDir(IBuildConfig bc) {
        String gitContextDir = null;
        if (bc != null && bc.getBuildSource() instanceof IGitBuildSource) {
            gitContextDir = ((IGitBuildSource)bc.getBuildSource()).getContextDir();
        }
        return gitContextDir;
    }

    @Override
    public void setGitContextDir(String gitContextDir) {
        this.update(this.connection, this.selectedItem, this.cloneDestination, this.useDefaultCloneDestination, this.project, this.reuseGitRepo, this.checkoutBranchReusedRepo, gitContextDir);
    }

    @Override
    public String getApplicationName() {
        String appName = null;
        IBuildConfig buildConfig = this.getSelectedBuildConfig();
        if (buildConfig != null) {
            appName = buildConfig.getName();
        }
        return appName;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.update(this.connection, this.selectedItem, this.cloneDestination, this.useDefaultCloneDestination, project, this.reuseGitRepo, this.checkoutBranchReusedRepo, this.gitContextDir);
    }

    @Override
    public boolean isReuseGitRepository() {
        return this.reuseGitRepo;
    }

    @Override
    public void setReuseGitRepository(boolean reuseGitRepo) {
        this.update(this.connection, this.selectedItem, this.cloneDestination, this.useDefaultCloneDestination, this.project, reuseGitRepo, reuseGitRepo, this.gitContextDir);
    }

    @Override
    public boolean isCheckoutBranchReusedRepo() {
        return this.checkoutBranchReusedRepo;
    }

    @Override
    public void setCheckoutBranchReusedRepo(boolean checkout) {
        this.update(this.connection, this.selectedItem, this.cloneDestination, this.useDefaultCloneDestination, this.project, this.reuseGitRepo, checkout, this.gitContextDir);
    }
}

