/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.ImportFailedException;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.WontOverwriteException;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportProjectOperation;

public class ImportJob
extends WorkspaceJob {
    private String gitUrl;
    private File cloneDestination;
    private String gitRef;
    private Collection<String> filters;
    private boolean checkoutBranch;
    private boolean reuseGitRepository;
    private List<IProject> importedProjects = Collections.emptyList();

    public ImportJob(String gitUrl, String gitRef, File repoLocation, boolean checkoutBranch) {
        this(gitUrl, gitRef, repoLocation, checkoutBranch, true);
    }

    protected ImportJob(String gitUrl, String gitRef, File cloneDestination) {
        this(gitUrl, gitRef, cloneDestination, false, false);
    }

    protected ImportJob(String gitUrl, String gitRef, File cloneDestination, boolean checkoutBranch, boolean reuseGitRepository) {
        super("Importing project to workspace...");
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.gitUrl = gitUrl;
        this.gitRef = gitRef;
        this.cloneDestination = cloneDestination;
        this.checkoutBranch = checkoutBranch;
        this.reuseGitRepository = reuseGitRepository;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            this.importedProjects = this.reuseGitRepository ? new ImportProjectOperation(this.gitUrl, this.gitRef, this.cloneDestination, this.filters, this.checkoutBranch).execute(monitor) : new ImportProjectOperation(this.gitUrl, this.gitRef, this.cloneDestination, this.filters).execute(monitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (WontOverwriteException e) {
            this.openError("Project already present", e.getMessage());
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (ImportFailedException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not import project from {0}.", (Object)((Object)e), (Object)this.gitUrl));
            return iStatus;
        }
        catch (IOException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not import project from {0}.", (Object)e, (Object)this.gitUrl));
            return iStatus;
        }
        catch (OpenShiftException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not import project to the workspace.", (Throwable)e);
            return iStatus;
        }
        catch (URISyntaxException e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("The url of the remote git repository is not valid", (Throwable)e);
            return iStatus;
        }
        catch (InvocationTargetException e) {
            TransportException te = this.getTransportException(e);
            if (te != null) {
                IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not clone the repository. Authentication failed.\n Please make sure that you added your private key to the ssh preferences.", (Throwable)te);
                return iStatus;
            }
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("An exception occurred while creating local git repository.", (Throwable)e);
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = StatusFactory.getMultiStatusInstance((int)0, (String)"org.jboss.tools.openshift.ui", (String)"Could not import project to the workspace.", null, (IStatus[])new IStatus[]{e.getStatus()});
            return iStatus;
        }
        catch (InterruptedException e) {
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not import project to the workspace.", (Throwable)e);
            return iStatus;
        }
        catch (Exception e) {
            IStatus iStatus = OpenShiftUIActivator.statusFactory().errorStatus("Could not import project to the workspace.", (Throwable)e);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected TransportException getTransportException(Throwable t) {
        if (t instanceof TransportException) {
            return (TransportException)t;
        }
        if (t instanceof InvocationTargetException) {
            return this.getTransportException(((InvocationTargetException)t).getTargetException());
        }
        if (t instanceof Exception) {
            return this.getTransportException(((Exception)t).getCause());
        }
        return null;
    }

    protected void openError(final String title, final String message) {
        final Shell shell = UIUtils.getShell();
        if (shell == null || shell.isDisposed()) {
            OpenShiftUIActivator.getDefault().getLogger().logError(message);
        } else {
            UIUtils.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                }
            });
        }
    }

    public ImportJob setFilters(Collection<String> filters) {
        this.filters = filters;
        return this;
    }

    public List<IProject> getImportedProjects() {
        return this.importedProjects;
    }
}

