/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.model.template.ITemplate;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.server.adapter.ProjectBuilderTypeDetector;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.SelectExistingProjectDialog;
import org.jboss.tools.openshift.internal.common.ui.SelectProjectComponentBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.TabFolderSelectionProperty;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenshiftUIConstants;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemStyledCellLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.common.AbstractProjectPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ApplicationSourceDetailViews;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ApplicationSourceTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSourceListPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.NotATemplateException;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsContentProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TabFolderTraverseListener;

public class ApplicationSourceListPage
extends AbstractProjectPage<IApplicationSourceListPageModel> {
    private static final int LOCAL_TEMPLATE_TAB_INDEX = 1;
    public static final String PAGE_NAME = "appSourceList";
    private TreeViewer templatesViewer;

    public ApplicationSourceListPage(IWizard wizard, IApplicationSourceListPageModel model) {
        super(wizard, model, "Select template", "Server template choices may be filtered by typing the name of a tag in the text field.", "templateList");
    }

    @Override
    protected void doCreateControls(final Composite parent, DataBindingContext dbc) {
        super.doCreateControls(parent, dbc);
        IObservableValue selectedEclipseProject = this.createEclipseProjectControls(parent, dbc);
        SashForm listAndDetailsContainer = new SashForm(parent, 512);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, true).applyTo((Control)listAndDetailsContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)listAndDetailsContainer);
        TabFolder tabContainer = new TabFolder((Composite)listAndDetailsContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)tabContainer);
        tabContainer.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                parent.layout(true, true);
            }
        });
        IObservableValue useLocalTemplateObservable = BeanProperties.value((String)"useLocalAppSource").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)new TabFolderSelectionProperty().observe((Widget)tabContainer)).converting((IConverter)new Converter(Integer.class, Boolean.class){

            public Object convert(Object fromObject) {
                return Integer.valueOf(1).equals(fromObject);
            }
        })).to(useLocalTemplateObservable).converting((IConverter)new Converter(Boolean.class, Integer.class){

            public Object convert(Object fromObject) {
                return fromObject != null && (Boolean)fromObject != false ? 1 : 0;
            }
        })).in(dbc);
        ((IApplicationSourceListPageModel)this.model).setUseLocalAppSource(false);
        TabFolderTraverseListener tabFolderTraverseListener = new TabFolderTraverseListener(tabContainer);
        IObservableValue serverTemplate = this.createServerTemplateControls(tabContainer, tabFolderTraverseListener, useLocalTemplateObservable, dbc);
        IObservableValue localTemplateFilename = this.createLocalTemplateControls(tabContainer, tabFolderTraverseListener, useLocalTemplateObservable, dbc);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)BeanProperties.value((String)"appSourceStatus", IStatus.class).observe((Object)ApplicationSourceListPage.this.model).getValue();
            }
        });
        this.createDetailsGroup((Composite)listAndDetailsContainer, dbc);
        listAndDetailsContainer.setWeights(new int[]{2, 1});
        IObservableValue selectedTemplate = BeanProperties.value((String)"selectedAppSource").observe((Object)this.model);
        TemplateListPageValidator pageValidator = new TemplateListPageValidator(useLocalTemplateObservable, localTemplateFilename, serverTemplate, selectedTemplate, selectedEclipseProject, parent);
        dbc.addValidationStatusProvider((ValidationStatusProvider)pageValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)pageValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        ProjectNameValidator projectNameValidator = new ProjectNameValidator(selectedEclipseProject, parent);
        dbc.addValidationStatusProvider((ValidationStatusProvider)projectNameValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)projectNameValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private IObservableValue createEclipseProjectControls(Composite parent, DataBindingContext dbc) {
        IObservableValue eclipseProjectObservable = BeanProperties.value((String)"eclipseProject").observe((Object)this.model);
        SelectProjectComponentBuilder builder = new SelectProjectComponentBuilder();
        builder.setTextLabel("Use existing workspace project:").setHorisontalSpan(1).setRequired(false).setEclipseProjectObservable(eclipseProjectObservable).setSelectionListener(this.onBrowseProjects()).build(parent, dbc);
        final Link gitLabel = new Link(parent, 0);
        gitLabel.setText("The project needs to be <a>shared with Git</a> and have a remote repository accessible by OpenShift");
        gitLabel.addSelectionListener((SelectionListener)this.onClickEGitLink());
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)gitLabel);
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IProject p = (IProject)event.getObservableValue().getValue();
                ApplicationSourceListPage.this.toggleEgitLink(gitLabel, p);
            }
        }, (IObservableValue)eclipseProjectObservable, (Control)gitLabel);
        this.toggleEgitLink(gitLabel, ((IApplicationSourceListPageModel)this.model).getEclipseProject());
        return builder.getProjectNameTextObservable();
    }

    private SelectionAdapter onClickEGitLink() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IProject p = ((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getEclipseProject();
                        ((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).setEclipseProject(null);
                        EGitUIUtils.openGitSharingWizard((Shell)Display.getCurrent().getActiveShell(), (IProject)p);
                        ((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).setEclipseProject(p);
                    }
                });
            }
        };
    }

    private SelectionListener onBrowseProjects() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectExistingProjectDialog dialog = new SelectExistingProjectDialog(((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getEclipseProject() == null ? "Select an existing workspace project from the list below." : NLS.bind((String)"Currently project {0} is selected, you may pick a different one from the list below.", (Object)((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getEclipseProject().getName()), ApplicationSourceListPage.this.getShell());
                if (((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getEclipseProject() != null) {
                    dialog.setInitialSelections(new Object[]{((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getEclipseProject()});
                }
                if (dialog.open() == 0) {
                    Object selectedProject = dialog.getFirstResult();
                    ((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).setEclipseProject((IProject)selectedProject);
                }
            }
        };
    }

    private IObservableValue createLocalTemplateControls(TabFolder tabContainer, TabFolderTraverseListener tabFolderTraverseListener, IObservableValue useLocalTemplate, DataBindingContext dbc) {
        TabItem localTemplatesTab = new TabItem(tabContainer, 0);
        localTemplatesTab.setText("Custom template");
        Composite parent = new Composite((Composite)tabContainer, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).spacing(6, 2).applyTo(parent);
        Label lbl = new Label(parent, 0);
        lbl.setText("Select a local template file or a full URL:");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)lbl);
        Text txtLocalTemplateFileName = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)txtLocalTemplateFileName);
        ISWTObservableValue localTemplateFilename = WidgetProperties.text((int)24).observe((Widget)txtLocalTemplateFileName);
        IValidator validator = o -> {
            IStatus status = ValidationStatus.ok();
            if (!OpenshiftUIConstants.URL_VALIDATOR.isValid(o.toString()) && StringUtils.isNotBlank((String)o.toString()) && !ApplicationSourceListPage.isFile(o.toString())) {
                status = ValidationStatus.error((String)(o + " is not a file"));
            }
            this.asyncRedraw(parent);
            return status;
        };
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)localTemplateFilename).validatingBeforeSet(validator)).to(BeanProperties.value((String)"localAppSourceFileName").observe((Object)this.model)).in(dbc);
        Button btnBrowseFiles = new Button(parent, 0);
        btnBrowseFiles.setText("Browse File System...");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)btnBrowseFiles);
        btnBrowseFiles.addSelectionListener((SelectionListener)this.onFileSystemBrowseClicked());
        Button btnBrowseWorkspaceFiles = new Button(parent, 0);
        btnBrowseWorkspaceFiles.setText("Browse Workspace...");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)btnBrowseWorkspaceFiles);
        btnBrowseWorkspaceFiles.addSelectionListener(this.onBrowseWorkspaceClicked());
        UIUtils.setEqualButtonWidth((Button[])new Button[]{btnBrowseFiles, btnBrowseWorkspaceFiles});
        localTemplatesTab.setControl((Control)parent);
        tabFolderTraverseListener.bindTabControls(tabContainer.getItemCount() - 1, new Control[]{txtLocalTemplateFileName, btnBrowseFiles, btnBrowseWorkspaceFiles});
        return localTemplateFilename;
    }

    private void asyncRedraw(final Composite c) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                c.redraw();
                c.update();
            }
        });
    }

    private SelectionListener onBrowseWorkspaceClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = UIUtils.createFileDialog((String)((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getLocalAppSourceFileName(), (String)"Select an OpenShift template", (String)"Select an OpenShift template (*.json)", (String)"json", (IResource)((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getEclipseProject());
                if (dialog.open() == 0 && dialog.getFirstResult() instanceof IFile) {
                    String path = ((IFile)dialog.getFirstResult()).getFullPath().toString();
                    String file = VariablesHelper.addWorkspacePrefix((String)path);
                    ApplicationSourceListPage.this.setLocalTemplate(file);
                }
            }
        };
    }

    private void setLocalTemplate(String file) {
        if (file == null || !ApplicationSourceListPage.isFile(file)) {
            return;
        }
        try {
            ((IApplicationSourceListPageModel)this.model).setLocalAppSourceFileName(file);
            return;
        }
        catch (NotATemplateException ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is not an OpenShift template. It contains a resource of type {1} instead.", (Object)file, (Object)ex.getResourceKind()));
        }
        catch (ClassCastException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is not an OpenShift template.", (Object)file), (IStatus)status);
        }
        catch (UnsupportedVersionException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is a template in a version that we do not support.", (Object)file), (IStatus)status);
        }
        catch (OpenShiftException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"Unable to read and/or parse the file \"{0}\" as a template.", (Object)file), (IStatus)status);
        }
    }

    private IObservableValue createServerTemplateControls(TabFolder tabFolder, TabFolderTraverseListener tabFolderTraverseListener, IObservableValue uploadTemplate, DataBindingContext dbc) {
        TabItem serverTemplatesTab = new TabItem(tabFolder, 0);
        serverTemplatesTab.setText("Server application source");
        Composite parent = new Composite((Composite)tabFolder, 0);
        GridLayoutFactory.fillDefaults().margins(10, 6).spacing(2, 2).applyTo(parent);
        serverTemplatesTab.setControl((Control)parent);
        final Text txtTemplateFilter = UIUtils.createSearchText((Composite)parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)txtTemplateFilter);
        IObservableValue eclipseProjectObservable = BeanProperties.value((String)"eclipseProject").observe((Object)this.model);
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ApplicationSourceListPage.this.filterTemplates(txtTemplateFilter, (IProject)event.getObservableValue().getValue());
            }
        }, (IObservableValue)eclipseProjectObservable, (Control)txtTemplateFilter);
        this.filterTemplates(txtTemplateFilter, ((IApplicationSourceListPageModel)this.model).getEclipseProject());
        this.templatesViewer = this.createServerTemplatesViewer(parent, txtTemplateFilter);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 180).applyTo(this.templatesViewer.getControl());
        IViewerObservableValue selectedViewerServerTemplate = ViewerProperties.singleSelection().observe((Viewer)this.templatesViewer);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedViewerServerTemplate).converting((IConverter)new ObservableTreeItem2ModelConverter(IApplicationSource.class))).to(BeanProperties.value((String)"serverAppSource").observe((Object)this.model)).converting((IConverter)new Model2ObservableTreeItemConverter(ApplicationSourceTreeItems.INSTANCE))).in(dbc);
        this.templatesViewer.addDoubleClickListener(this.onServerTemplateDoubleClicked());
        txtTemplateFilter.addModifyListener(this.onFilterTextTyped(this.templatesViewer));
        tabFolderTraverseListener.bindTabControls(tabFolder.getItemCount() - 1, new Control[]{txtTemplateFilter, this.templatesViewer.getTree()});
        return selectedViewerServerTemplate;
    }

    protected String findMatchingTags(IProject project) {
        return new ProjectBuilderTypeDetector().findTemplateFilter(project);
    }

    private void createDetailsGroup(Composite parent, DataBindingContext dbc) {
        Group detailsGroup = new Group(parent, 0);
        detailsGroup.setText("Details");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)detailsGroup);
        GridLayoutFactory.fillDefaults().margins(10, 6).spacing(2, 2).applyTo((Composite)detailsGroup);
        Composite detailsContainer = new Composite((Composite)detailsGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)detailsContainer);
        new ApplicationSourceDetailViews(BeanProperties.value((String)"selectedAppSource").observe((Object)this.model), null, detailsContainer, dbc).createControls();
        Button btnDetails = new Button((Composite)detailsGroup, 0);
        btnDetails.setText("Defined Resources...");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)btnDetails);
        IObservableValue selectedTemplate = BeanProperties.value((String)"selectedAppSource").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.visible().observe((Widget)btnDetails)).notUpdatingParticipant()).to(selectedTemplate).converting((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && "Template".equals(((IApplicationSource)fromObject).getSource().getKind())) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        btnDetails.addSelectionListener((SelectionListener)this.onDefinedResourcesClicked());
    }

    private IDoubleClickListener onServerTemplateDoubleClicked() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (ApplicationSourceListPage.hasApplicationSource(selection.getFirstElement()) && ApplicationSourceListPage.this.canFlipToNextPage()) {
                    ApplicationSourceListPage.this.getContainer().showPage(ApplicationSourceListPage.this.getNextPage());
                }
            }
        };
    }

    private TreeViewer createServerTemplatesViewer(Composite parent, Text templateFilterText) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"appSources"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemStyledCellLabelProvider());
        viewer.setAutoExpandLevel(-1);
        viewer.setComparator((ViewerComparator)new ApplicationSourceComparator());
        viewer.addFilter((ViewerFilter)new AppSourceViewerFilter(templateFilterText));
        templateFilterText.addKeyListener(this.onFilterKeyPressed(viewer));
        viewer.setInput((Object)this.model);
        return viewer;
    }

    private SelectionAdapter onFileSystemBrowseClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = this.createFileDialog(((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getLocalAppSourceFileName());
                String file = dialog.open();
                ApplicationSourceListPage.this.setLocalTemplate(file);
            }

            private FileDialog createFileDialog(String selectedFile) {
                FileDialog dialog = new FileDialog(ApplicationSourceListPage.this.getShell(), 4096);
                dialog.setText("Select an OpenShift template");
                if (ApplicationSourceListPage.isFile(selectedFile)) {
                    File file = new File(selectedFile);
                    dialog.setFilterPath(file.getParentFile().getAbsolutePath());
                }
                return dialog;
            }
        };
    }

    private SelectionAdapter onDefinedResourcesClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITemplate template = (ITemplate)((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).getSelectedAppSource().getSource();
                new ResourceSummaryDialog(ApplicationSourceListPage.this.getShell(), template.getObjects(), "Template Details", NLS.bind((String)"The following resources will be created by using template\n\"{0}\":", (Object)template.getName()), new ResourceDetailsLabelProvider(template.getParameters()), new ResourceDetailsContentProvider()).open();
            }
        };
    }

    private ModifyListener onFilterTextTyped(final TreeViewer viewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                viewer.refresh();
                viewer.expandAll();
            }
        };
    }

    private KeyListener onFilterKeyPressed(final TreeViewer viewer) {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    TreeItem[] items = viewer.getTree().getItems();
                    if (items == null || items.length == 0) {
                        return;
                    }
                    TreeItem[] s = viewer.getTree().getSelection();
                    TreeItem next = null;
                    if (s == null || s.length == 0) {
                        next = e.keyCode == 0x1000002 ? items[0] : items[items.length - 1];
                    } else {
                        int i = 0;
                        while (i < items.length && next == null) {
                            if (items[i] == s[0]) {
                                if (e.keyCode == 0x1000002) {
                                    if (i + 1 < items.length) {
                                        next = items[i + 1];
                                    }
                                } else if (i > 0) {
                                    next = items[i - 1];
                                }
                            }
                            ++i;
                        }
                    }
                    if (next != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(next.getData()), true);
                    }
                    e.doit = false;
                }
            }
        };
    }

    @Override
    protected JobChainBuilder getLoadResourcesJobBuilder(boolean[] closeAfter, boolean closeOnCancel) {
        JobChainBuilder builder = super.getLoadResourcesJobBuilder(closeAfter, closeOnCancel);
        builder.runWhenSuccessfullyDone((Job)new UIJob("Expanding resource tree..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ApplicationSourceListPage.this.templatesViewer.expandAll();
                return Status.OK_STATUS;
            }
        });
        return builder;
    }

    private static boolean hasApplicationSource(Object item) {
        return item instanceof IApplicationSource || item instanceof ObservableTreeItem && ((ObservableTreeItem)((Object)item)).getModel() instanceof IApplicationSource;
    }

    private void filterTemplates(Text text, IProject project) {
        String tags = this.findMatchingTags(project);
        if (tags != null && !text.isDisposed()) {
            text.setText(tags);
        }
    }

    private void toggleEgitLink(Link gitLabel, IProject p) {
        if (gitLabel.isDisposed()) {
            return;
        }
        boolean showLink = p != null && !EGitUtils.isSharedWithGit((IProject)p);
        UIUtils.setVisibleAndExclude((boolean)showLink, (Control)gitLabel);
    }

    protected void onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction progress, PageChangingEvent event, DataBindingContext dbc) {
        if (((IApplicationSourceListPageModel)this.model).isUseLocalAppSource()) {
            String filename = ((IApplicationSourceListPageModel)this.model).getLocalAppSourceFileName();
            if (StringUtils.isNotBlank((String)filename)) {
                Job job = new Job(NLS.bind((String)"Loading application source", (Object)filename)){

                    protected IStatus run(IProgressMonitor monitor) {
                        ((IApplicationSourceListPageModel)ApplicationSourceListPage.this.model).loadAppSource(monitor);
                        return Status.OK_STATUS;
                    }
                };
                try {
                    WizardUtils.runInWizard((Job)job, (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDatabindingContext());
                    event.doit = ((IApplicationSourceListPageModel)this.model).getAppSourceStatus().isOK();
                }
                catch (InterruptedException | InvocationTargetException e) {
                    OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
                    event.doit = false;
                }
            } else {
                ((IApplicationSourceListPageModel)this.model).resetLocalAppSource();
                event.doit = false;
            }
        }
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)13, (WizardPage)this, (DataBindingContext)dbc);
    }

    private static class AppSourceViewerFilter
    extends ViewerFilter {
        private Text filterText;

        public AppSourceViewerFilter(Text filterText) {
            this.filterText = filterText;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof ObservableTreeItem) || !(((ObservableTreeItem)((Object)element)).getModel() instanceof IApplicationSource)) {
                return true;
            }
            IApplicationSource appSource = (IApplicationSource)((ObservableTreeItem)((Object)element)).getModel();
            return ResourceUtils.isMatchingNameOrTag((String)this.filterText.getText(), (String)appSource.getName(), appSource.getTags());
        }
    }

    public static class ApplicationSourceComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (ApplicationSourceListPage.hasApplicationSource(e1) && ApplicationSourceListPage.hasApplicationSource(e2)) {
                String t1 = ((IApplicationSource)((ObservableTreeItem)((Object)e1)).getModel()).getName();
                String t2 = ((IApplicationSource)((ObservableTreeItem)((Object)e2)).getModel()).getName();
                return t1.compareTo(t2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class ProjectNameValidator
    extends MultiValidator {
        private IObservableValue projectNameObservable;
        private IObservableList mutableTargets = new WritableList();
        private Composite composite;

        public ProjectNameValidator(IObservableValue projectNameObservable, Composite composite) {
            this.projectNameObservable = projectNameObservable;
            this.composite = composite;
        }

        protected IStatus validate() {
            IStatus status = ValidationStatus.ok();
            String projectName = (String)this.projectNameObservable.getValue();
            if (!StringUtils.isEmpty((String)projectName)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!ProjectUtils.exists((IProject)project)) {
                    status = ValidationStatus.error((String)NLS.bind((String)"The project {0} does not exist in your workspace.", (Object)projectName));
                } else if (!ProjectUtils.isAccessible((IProject)project)) {
                    status = ValidationStatus.error((String)NLS.bind((String)"The project {0} is not open.", (Object)projectName));
                } else if (EGitUtils.isSharedWithGit((IProject)project)) {
                    try {
                        List repos = EGitUtils.getRemoteGitRepos((IProject)project);
                        if (repos == null || repos.isEmpty()) {
                            status = ValidationStatus.warning((String)NLS.bind((String)"A remote Git repository using the HTTP(S) protocol must be defined on project {0}", (Object)projectName));
                        }
                    }
                    catch (CoreException e) {
                        status = ValidationStatus.error((String)NLS.bind((String)"Can not read Git config on project {0} : {1}", (Object)projectName, (Object)e.getMessage()));
                    }
                } else {
                    status = ValidationStatus.error((String)NLS.bind((String)"The project {0} is not shared with Git.", (Object)projectName));
                }
            }
            if (!status.isOK()) {
                this.mutableTargets.add((Object)this.projectNameObservable);
            }
            this.composite.redraw();
            return status;
        }
    }

    private class TemplateListPageValidator
    extends MultiValidator {
        private IObservableValue useLocalTemplateObservable;
        private IObservableValue localTemplateFilenameObservable;
        private IObservableValue serverTemplateObservable;
        private IObservableValue selectedTemplateObservable;
        private IObservableValue projectNameObservable;
        private IObservableList mutableTargets = new WritableList();
        private Composite composite;

        public TemplateListPageValidator(IObservableValue useLocalTemplate, IObservableValue localTemplateFilename, IObservableValue serverTemplate, IObservableValue selectedTemplate, IObservableValue projectNameObservable, Composite composite) {
            this.useLocalTemplateObservable = useLocalTemplate;
            useLocalTemplate.getValue();
            this.localTemplateFilenameObservable = localTemplateFilename;
            this.serverTemplateObservable = serverTemplate;
            this.selectedTemplateObservable = selectedTemplate;
            this.projectNameObservable = projectNameObservable;
            this.composite = composite;
        }

        protected IStatus validate() {
            IStatus status = ValidationStatus.ok();
            this.mutableTargets.clear();
            this.projectNameObservable.getValue();
            Object useLocalTemplate = this.useLocalTemplateObservable.getValue();
            Object localTemplateFilename = this.localTemplateFilenameObservable.getValue();
            this.serverTemplateObservable.getValue();
            Object selectedTemplate = this.selectedTemplateObservable.getValue();
            if (status.getSeverity() < 4) {
                if (Boolean.TRUE.equals(useLocalTemplate)) {
                    String localTemplate = (String)localTemplateFilename;
                    if (StringUtils.isNotBlank((String)localTemplate)) {
                        if (!OpenshiftUIConstants.URL_VALIDATOR.isValid(localTemplate) && !ApplicationSourceListPage.isFile(localTemplate)) {
                            status = ValidationStatus.error((String)NLS.bind((String)"{0} is not a valid file.", (Object)localTemplate));
                            this.mutableTargets.add((Object)this.localTemplateFilenameObservable);
                        }
                    } else {
                        status = ValidationStatus.cancel((String)"Please select a local template file or URL.");
                        this.mutableTargets.add((Object)this.localTemplateFilenameObservable);
                    }
                } else if (selectedTemplate == null) {
                    status = ValidationStatus.cancel((String)"Please select an image or template.");
                    this.mutableTargets.add((Object)this.serverTemplateObservable);
                }
            }
            ApplicationSourceListPage.this.asyncRedraw(this.composite);
            return status;
        }

        public IObservableList getTargets() {
            return this.mutableTargets;
        }
    }
}

