/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IProjectTemplateList;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.image.ITagReference;
import com.openshift.restclient.model.template.ITemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.tools.openshift.core.ICommonAttributes;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.ImageStreamApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateApplicationSource;

public class ApplicationSourceTreeItems
implements IModelFactory,
ICommonAttributes {
    private static final String BUILDER_TAG = "builder";
    public static final ApplicationSourceTreeItems INSTANCE = new ApplicationSourceTreeItems();

    @Override
    public <T> List<T> createChildren(Object parent) {
        if (parent instanceof Connection) {
            return ((Connection)parent).getResources("Project");
        }
        if (parent instanceof IProject) {
            IProject project = (IProject)parent;
            Connection conn = ConnectionsRegistryUtil.getConnectionFor((IResource)project);
            Collection<IApplicationSource> appSources = this.loadTemplates(project, conn);
            appSources.addAll(this.loadImageStreams(project, conn));
            return new ArrayList<IApplicationSource>(appSources);
        }
        return Collections.emptyList();
    }

    private Collection<IApplicationSource> loadImageStreams(IProject project, Connection conn) {
        List streams = conn.getResources("ImageStream", project.getNamespace());
        try {
            if (StringUtils.isNotBlank((String)conn.getClusterNamespace())) {
                List commonStreams = conn.getResources("ImageStream", conn.getClusterNamespace());
                commonStreams.stream().filter(s -> !streams.contains(s)).forEach(s -> {
                    boolean bl = streams.add(s);
                });
            }
        }
        catch (OpenShiftException e) {
            OpenShiftUIActivator.log(4, e.getLocalizedMessage(), e);
        }
        ArrayList<IApplicationSource> sources = new ArrayList<IApplicationSource>();
        for (IImageStream is : streams) {
            List<ITagReference> tags = is.getTags().stream().filter(t -> t.isAnnotatedWith("tags") && ArrayUtils.contains((Object[])t.getAnnotation("tags").split(","), (Object)BUILDER_TAG)).collect(Collectors.toList());
            if (tags.isEmpty()) continue;
            tags.forEach(t -> {
                boolean bl = sources.add(new ImageStreamApplicationSource(is, (ITagReference)t));
            });
        }
        return sources;
    }

    public List<ObservableTreeItem> create(Collection<?> openShiftObjects) {
        if (openShiftObjects == null) {
            return Collections.emptyList();
        }
        ArrayList<ObservableTreeItem> items = new ArrayList<ObservableTreeItem>();
        for (Object openShiftObject : openShiftObjects) {
            ObservableTreeItem item = this.create(openShiftObject);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public ObservableTreeItem create(Object object) {
        return new ObservableTreeItem(object, this);
    }

    private Collection<IApplicationSource> loadTemplates(IProject project, final Connection conn) {
        return (Collection)project.accept((CapabilityVisitor)new CapabilityVisitor<IProjectTemplateList, Collection<IApplicationSource>>(){

            public Collection<IApplicationSource> visit(IProjectTemplateList capability) {
                Collection templates = capability.getTemplates();
                if (StringUtils.isNotBlank((String)conn.getClusterNamespace())) {
                    try {
                        Collection commonTemplates = capability.getCommonTemplates(conn.getClusterNamespace());
                        commonTemplates.stream().filter(t -> !templates.contains(t)).forEach(t -> {
                            boolean bl = templates.add(t);
                        });
                    }
                    catch (OpenShiftException e) {
                        OpenShiftUIActivator.log(4, e.getLocalizedMessage(), e);
                    }
                }
                return templates.stream().map(t -> new TemplateApplicationSource((ITemplate)t)).collect(Collectors.toList());
            }
        }, Collections.emptyList());
    }
}

