/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.ITemplate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.OpenshiftUIConstants;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ApplicationSourceTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSourceListPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.NotATemplateException;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateApplicationSource;

public class NewApplicationWizardModel
extends ResourceLabelsPageModel
implements IApplicationSourceListPageModel {
    private Connection connection;
    private com.openshift.restclient.model.IProject project;
    private List<ObservableTreeItem> projectItems = new ArrayList<ObservableTreeItem>();
    private List<ObservableTreeItem> projectTemplates = new ArrayList<ObservableTreeItem>();
    private IApplicationSource selectedAppSource;
    private IApplicationSource localAppSource;
    private IApplicationSource serverAppSource;
    private IStatus appSourceStatus = Status.OK_STATUS;
    private boolean useLocalAppSource = true;
    private String localAppSourceFilename;
    private IResourceFactory resourceFactory;
    private IProject eclipseProject;
    private Comparator<ObservableTreeItem> comparator;

    private void update(boolean useLocalAppSource, com.openshift.restclient.model.IProject selectedProject, List<ObservableTreeItem> projectItems, IApplicationSource appSource, String localAppSourceFilename, IStatus appSourceStatus) {
        this.updateProjectItems(projectItems);
        this.project = selectedProject = this.getProjectOrDefault(selectedProject, projectItems);
        this.firePropertyChange("project", this.project, selectedProject);
        this.projectTemplates = this.getProjectTemplates(selectedProject, projectItems);
        this.firePropertyChange("appSources", this.projectTemplates, this.projectTemplates);
        this.updateAppSourceStatus(appSourceStatus);
        this.useLocalAppSource = useLocalAppSource;
        this.firePropertyChange("useLocalAppSource", this.useLocalAppSource, this.useLocalAppSource);
        this.updateSelectedAppSource(useLocalAppSource, appSource, this.localAppSource, localAppSourceFilename);
    }

    private void updateSelectedAppSource(boolean useLocalAppSource, IApplicationSource serverAppSource, IApplicationSource localAppSource, String localAppSourceFilename) {
        IApplicationSource source = useLocalAppSource ? (this.localAppSource = localAppSource) : (this.serverAppSource = serverAppSource);
        this.updateLabels(source);
        String oldLocalAppSourceFileName = this.localAppSourceFilename;
        IApplicationSource oldSelectedAppSource = this.selectedAppSource;
        this.localAppSourceFilename = localAppSourceFilename;
        this.selectedAppSource = source;
        this.firePropertyChange("localAppSourceFileName", oldLocalAppSourceFileName, this.localAppSourceFilename);
        this.firePropertyChange("selectedAppSource", oldSelectedAppSource, this.selectedAppSource);
    }

    private void updateLabels(IApplicationSource source) {
        if (source != null && "Template".equals(source.getKind())) {
            ITemplate template = (ITemplate)source.getSource();
            this.setLabels(template.getObjectLabels());
            return;
        }
        this.setLabels(Collections.emptyMap());
    }

    private void updateAppSourceStatus(IStatus appSourceStatus) {
        this.appSourceStatus = appSourceStatus;
        this.firePropertyChange("appSourceStatus", this.appSourceStatus, this.appSourceStatus);
    }

    private void setLabels(Map<String, String> labelMap) {
        if (labelMap == null) {
            return;
        }
        ArrayList<IResourceLabelsPageModel.Label> labels = new ArrayList<IResourceLabelsPageModel.Label>(labelMap.size());
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            labels.add(new IResourceLabelsPageModel.Label(entry.getKey(), entry.getValue()));
        }
        this.setLabels(labels);
    }

    private IApplicationSource getLocalAppSource(IProgressMonitor monitor, String filename) {
        IResource resource;
        block23: {
            if (StringUtils.isBlank((String)filename)) {
                return null;
            }
            resource = null;
            filename = VariablesHelper.replaceVariables((String)filename);
            if (OpenshiftUIConstants.URL_VALIDATOR.isValid(filename) || Files.isRegularFile(Paths.get(filename, new String[0]), new LinkOption[0])) break block23;
            return null;
        }
        try {
            Object object = null;
            Object var5_9 = null;
            try (InputStream input = this.createInputStream(filename, monitor);){
                resource = this.resourceFactory.create(input);
                if (resource != null && !(resource instanceof ITemplate)) {
                    throw new NotATemplateException(resource.getKind());
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (FileNotFoundException e) {
            throw new OpenShiftException((Throwable)e, NLS.bind((String)"Could not find the file \"{0}\" to upload", (Object)filename), new Object[0]);
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, NLS.bind((String)"Error reading the file or URL \"{0}\" to upload", (Object)filename), new Object[0]);
        }
        catch (ResourceFactoryException | ClassCastException e) {
            throw e;
        }
        switch (resource.getKind()) {
            case "Template": {
                return new TemplateApplicationSource((ITemplate)resource);
            }
        }
        throw new OpenShiftException("Creating applications from local files is only allowed using a template", new Object[0]);
    }

    private List<ObservableTreeItem> getProjectTemplates(com.openshift.restclient.model.IProject selectedProject, List<ObservableTreeItem> allProjects) {
        if (allProjects == null) {
            return null;
        }
        for (ObservableTreeItem item : allProjects) {
            if (!item.getModel().equals(selectedProject)) continue;
            return item.getChildren();
        }
        return allProjects;
    }

    private void updateProjectItems(List<ObservableTreeItem> projectItems) {
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.projectItems);
        ArrayList<ObservableTreeItem> newItems = new ArrayList<ObservableTreeItem>();
        if (projectItems != null) {
            newItems.addAll(projectItems);
        }
        this.projectItems.clear();
        this.projectItems.addAll(newItems);
        this.firePropertyChange("projectItems", oldItems, this.projectItems);
    }

    @Override
    public void setServerAppSource(IApplicationSource appSource) {
        this.update(false, this.project, this.projectItems, appSource, this.localAppSourceFilename, Status.OK_STATUS);
    }

    @Override
    public IApplicationSource getServerAppSource() {
        return this.serverAppSource;
    }

    @Override
    public void resetLocalAppSource() {
        this.localAppSource = null;
        this.selectedAppSource = null;
        this.firePropertyChange("selectedAppSource", this.selectedAppSource, null);
        this.appSourceStatus = Status.OK_STATUS;
        this.firePropertyChange("appSourceStatus", this.appSourceStatus, this.appSourceStatus);
    }

    @Override
    public IApplicationSource getSelectedAppSource() {
        return this.selectedAppSource;
    }

    private com.openshift.restclient.model.IProject getProjectOrDefault(com.openshift.restclient.model.IProject project, List<ObservableTreeItem> projects) {
        if (project == null) {
            project = this.getDefaultProject(projects);
        }
        return project;
    }

    private com.openshift.restclient.model.IProject getDefaultProject(List<ObservableTreeItem> projects) {
        if (projects == null || projects.size() == 0) {
            return null;
        }
        if (projects.size() == 1) {
            return (com.openshift.restclient.model.IProject)projects.get(0).getModel();
        }
        ObservableTreeItem[] items = projects.toArray(new ObservableTreeItem[projects.size()]);
        if (this.comparator != null) {
            Arrays.sort(items, this.comparator);
        }
        return (com.openshift.restclient.model.IProject)items[0].getModel();
    }

    @Override
    public void setProject(com.openshift.restclient.model.IProject project) {
        this.update(this.useLocalAppSource, project, this.projectItems, this.serverAppSource, this.localAppSourceFilename, this.appSourceStatus);
    }

    @Override
    public com.openshift.restclient.model.IProject getProject() {
        return this.project;
    }

    @Override
    public void loadResources() {
        if (this.connection == null) {
            return;
        }
        ObservableTreeItem connectionItem = ApplicationSourceTreeItems.INSTANCE.create(this.connection);
        connectionItem.load();
        List<ObservableTreeItem> projects = connectionItem.getChildren();
        this.setProjectItems(projects);
    }

    @Override
    public void setUseLocalAppSource(boolean useLocalTemplate) {
        this.update(useLocalTemplate, this.project, this.projectItems, this.serverAppSource, this.localAppSourceFilename, this.appSourceStatus);
    }

    @Override
    public boolean isUseLocalAppSource() {
        return this.useLocalAppSource;
    }

    public InputStream createInputStream(String filename, IProgressMonitor monitor) throws IOException {
        if (OpenshiftUIConstants.URL_VALIDATOR.isValid(filename)) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                IStatus status = OpenshiftUIConstants.TRANSPORT_UTILITY.download(filename, filename, (OutputStream)out, monitor);
                if (!status.isOK()) {
                    throw new IOException(status.getMessage());
                }
                return new ByteArrayInputStream(out.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new FileInputStream(filename);
    }

    @Override
    public void setLocalAppSourceFileName(String filename) {
        this.update(true, this.project, this.projectItems, this.serverAppSource, filename, Status.OK_STATUS);
    }

    @Override
    public String getLocalAppSourceFileName() {
        return this.localAppSourceFilename;
    }

    @Override
    public IStatus getAppSourceStatus() {
        return this.appSourceStatus;
    }

    @Override
    public void loadAppSource(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            if (this.useLocalAppSource) {
                IApplicationSource source = this.getLocalAppSource(monitor, this.localAppSourceFilename);
                this.updateSelectedAppSource(this.useLocalAppSource, this.serverAppSource, source, this.localAppSourceFilename);
            }
        }
        catch (OpenShiftException e) {
            status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"Could not load template from {0}: {1}", (Object)this.localAppSourceFilename, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
        catch (NotATemplateException e) {
            status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"{0} is not a template: {1}", (Object)this.localAppSourceFilename, (Object)e.getLocalizedMessage()));
        }
        this.updateAppSourceStatus(status);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public void setConnection(Connection connection) {
        if (ObjectUtils.equals((Object)connection, (Object)this.connection)) {
            return;
        }
        this.setResourceFactory(connection);
        this.reset();
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
    }

    private void reset() {
        this.update(this.useLocalAppSource, null, null, null, null, Status.OK_STATUS);
    }

    @Override
    public void setProjectsComparator(Comparator<ObservableTreeItem> comparator) {
        this.comparator = comparator;
    }

    private void setResourceFactory(Connection connection) {
        if (connection != null) {
            this.resourceFactory = connection.getResourceFactory();
        }
    }

    public void setResourceFactory(IResourceFactory factory) {
        this.resourceFactory = factory;
    }

    protected void setProjectItems(List<ObservableTreeItem> projects) {
        this.update(this.useLocalAppSource, this.findProject(this.project, projects), projects, this.serverAppSource, this.localAppSourceFilename, this.appSourceStatus);
    }

    private com.openshift.restclient.model.IProject findProject(com.openshift.restclient.model.IProject project, List<ObservableTreeItem> projects) {
        if (project == null || CollectionUtils.isEmpty(projects)) {
            return null;
        }
        return projects.stream().filter(item -> {
            com.openshift.restclient.model.IProject p;
            if (item.getModel() instanceof com.openshift.restclient.model.IProject && (p = (com.openshift.restclient.model.IProject)item.getModel()) != null) {
                boolean equals = ObjectUtils.equals((Object)project, (Object)p);
                return equals;
            }
            return false;
        }).findFirst().map(item -> item.getModel()).orElse(null);
    }

    @Override
    public List<ObservableTreeItem> getProjectItems() {
        return this.projectItems;
    }

    @Override
    public List<ObservableTreeItem> getAppSources() {
        return this.projectTemplates;
    }

    @Override
    public boolean hasProjects() {
        return this.projectItems != null && !this.projectItems.isEmpty();
    }

    public Object getContext() {
        return null;
    }

    @Override
    public void setEclipseProject(IProject eclipseProject) {
        this.eclipseProject = eclipseProject;
        this.firePropertyChange("eclipseProject", this.eclipseProject, this.eclipseProject);
    }

    @Override
    public IProject getEclipseProject() {
        return this.eclipseProject;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.connection = null;
        this.project = null;
        this.projectItems.clear();
        this.projectTemplates.clear();
        this.selectedAppSource = null;
        this.localAppSource = null;
        this.serverAppSource = null;
        this.resourceFactory = null;
        this.eclipseProject = null;
    }
}

