/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.build.IBuildStrategy;
import com.openshift.restclient.model.build.ICustomBuildStrategy;
import com.openshift.restclient.model.build.IDockerBuildStrategy;
import com.openshift.restclient.model.build.IJenkinsPipelineStrategy;
import com.openshift.restclient.model.build.ISourceBuildStrategy;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceKindAndNameComparator;

public class ResourceDetailsContentProvider
implements ITreeContentProvider {
    public static final String LABEL_STRATEGY = "strategy";

    public Object[] getChildren(Object node) {
        block19: {
            if (!(node instanceof IResource)) break block19;
            IResource resource = (IResource)node;
            ArrayList<ResourceProperty> properties = new ArrayList<ResourceProperty>();
            properties.add(new ResourceProperty("labels", resource.getLabels()));
            switch (resource.getKind()) {
                case "BuildConfig": {
                    this.addBuildConfigProperties(properties, (IBuildConfig)resource);
                    break;
                }
                case "DeploymentConfig": {
                    this.addDeploymentConfigProperties(properties, (IDeploymentConfig)resource);
                    break;
                }
                case "Service": {
                    this.addServiceProperties(properties, (IService)resource);
                    break;
                }
                case "Route": {
                    this.addRouteProperties(properties, (IRoute)resource);
                    break;
                }
                case "ImageStream": {
                    this.addImageStreamProperties(properties, (IImageStream)resource);
                }
            }
            return properties.toArray();
        }
        return new Object[0];
    }

    private void addRouteProperties(Collection<ResourceProperty> properties, IRoute resource) {
        properties.add(new ResourceProperty("host", resource.getHost()));
        properties.add(new ResourceProperty("path", resource.getPath()));
        properties.add(new ResourceProperty("service", resource.getServiceName()));
    }

    private void addImageStreamProperties(Collection<ResourceProperty> properties, IImageStream resource) {
        properties.add(new ResourceProperty("registry", resource.getDockerImageRepository()));
    }

    private void addServiceProperties(Collection<ResourceProperty> properties, IService resource) {
        properties.add(new ResourceProperty("selector", resource.getSelector()));
        properties.add(new ResourceProperty("port", resource.getPort()));
    }

    private void addDeploymentConfigProperties(Collection<ResourceProperty> properties, IDeploymentConfig resource) {
        properties.add(new ResourceProperty("triggers", resource.getTriggerTypes()));
        properties.add(new ResourceProperty(LABEL_STRATEGY, resource.getDeploymentStrategyType()));
        properties.add(new ResourceProperty("template selector", resource.getReplicaSelector()));
    }

    private void addBuildConfigProperties(Collection<ResourceProperty> properties, IBuildConfig config) {
        IBuildStrategy buildStrategy = config.getBuildStrategy();
        this.addStrategyTypeProperties(properties, buildStrategy);
        properties.add(new ResourceProperty("source URL", config.getSourceURI()));
        properties.add(new ResourceProperty("output to", config.getOutputRepositoryName()));
        List triggers = config.getBuildTriggers().stream().map(trigger -> trigger.getType().toString()).collect(Collectors.toList());
        properties.add(new ResourceProperty("build triggers", triggers));
    }

    private void addStrategyTypeProperties(Collection<ResourceProperty> properties, IBuildStrategy buildStrategy) {
        if (buildStrategy == null || buildStrategy.getType() == null) {
            properties.add(new UnknownResourceProperty(LABEL_STRATEGY));
            return;
        }
        properties.add(new ResourceProperty(LABEL_STRATEGY, buildStrategy.getType().toString()));
        switch (buildStrategy.getType()) {
            case "Source": {
                ISourceBuildStrategy sti = (ISourceBuildStrategy)buildStrategy;
                properties.add(new ResourceProperty("builder image", StringUtils.toStringOrNull((Object)sti.getImage())));
                break;
            }
            case "Docker": {
                IDockerBuildStrategy docker = (IDockerBuildStrategy)buildStrategy;
                properties.add(new ResourceProperty("base image", StringUtils.toStringOrNull((Object)docker.getBaseImage())));
                break;
            }
            case "Custom": {
                ICustomBuildStrategy custom = (ICustomBuildStrategy)buildStrategy;
                properties.add(new ResourceProperty("builder image", StringUtils.toStringOrNull((Object)custom.getImage())));
                break;
            }
            case "JenkinsPipeline": {
                IJenkinsPipelineStrategy jenkins = (IJenkinsPipelineStrategy)buildStrategy;
                properties.add(new ResourceProperty("jenkins file", StringUtils.removeAll((String)StringUtils.getLineSeparator(), (String)jenkins.getJenkinsfile())));
                properties.add(new ResourceProperty("jenkins file path", StringUtils.toStringOrNull((Object)jenkins.getJenkinsfilePath())));
            }
        }
    }

    public Object[] getElements(Object rootElements) {
        if (!(rootElements instanceof Collection)) {
            return new Object[0];
        }
        ArrayList resources = new ArrayList((Collection)rootElements);
        Collections.sort(resources, new ResourceKindAndNameComparator());
        return resources.toArray();
    }

    public boolean hasChildren(Object node) {
        return node instanceof IResource;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldValue, Object newValue) {
    }

    public Object getParent(Object paramObject) {
        return null;
    }

    public static class ResourceProperty {
        private Object value;
        private String property;

        ResourceProperty(String property, Object value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isUnknownValue() {
            return false;
        }
    }

    public static class UnknownResourceProperty
    extends ResourceProperty {
        UnknownResourceProperty(String property) {
            super(property, null);
        }

        @Override
        public boolean isUnknownValue() {
            return true;
        }
    }
}

