/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsContentProvider;

public class ResourceDetailsLabelProvider
extends StyledCellLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String LABEL_NOT_PROVIDED = "(Not Provided)";
    private static final String LABEL_UNKNOWN = "(Unknown)";
    private static final String LABEL_UNKNOWN_PARAMETER = "(Unknown parameter {0})";
    private Map<String, IParameter> templateParameters;

    public ResourceDetailsLabelProvider(Map<String, IParameter> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = this.getStyledText(element);
        if (text != null) {
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
        }
        super.update(cell);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            StyledString text = new StyledString(StringUtils.capitalize((String)resource.getKind()));
            text.append(" ").append(this.replaceParameters(resource.getName()), StyledString.QUALIFIER_STYLER);
            return text;
        }
        if (element instanceof ResourceDetailsContentProvider.ResourceProperty) {
            ResourceDetailsContentProvider.ResourceProperty property = (ResourceDetailsContentProvider.ResourceProperty)element;
            StyledString text = new StyledString(StringUtils.capitalize((String)property.getProperty()));
            text.append(": ");
            String value = null;
            if (property.getValue() instanceof Map) {
                value = org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)((Map)property.getValue()));
            } else if (property.getValue() instanceof Collection) {
                value = StringUtils.join((Collection)((Collection)property.getValue()), (String)", ");
            } else {
                String string = value = property.getValue() != null ? property.getValue().toString() : "";
            }
            if (StringUtils.isBlank((String)value)) {
                value = property.isUnknownValue() ? LABEL_UNKNOWN : LABEL_NOT_PROVIDED;
            }
            text.append(this.replaceParameters(value), StyledString.QUALIFIER_STYLER);
            return text;
        }
        return null;
    }

    private String replaceParameters(String str) {
        StringBuffer result = new StringBuffer();
        Pattern p = Pattern.compile("\\$\\{[^}]+\\}");
        Matcher m = p.matcher(str);
        while (m.find()) {
            String parameterVariable = m.group();
            String parameterName = parameterVariable.substring(2, parameterVariable.length() - 1);
            if (this.templateParameters.containsKey(parameterName)) {
                m.appendReplacement(result, this.templateParameters.get(parameterName).getValue());
                continue;
            }
            m.appendReplacement(result, NLS.bind((String)LABEL_UNKNOWN_PARAMETER, (Object)parameterName));
        }
        m.appendTail(result);
        return result.toString();
    }

    public Image getImage(Object paramObject) {
        return null;
    }
}

