/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.validator.GitReferenceValidator;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariablePage;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceNameControl;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.IBuildConfigPageModel;

public class BuildConfigPage
extends EnvironmentVariablePage {
    public static final String PAGE_NAME = "Build Config Settings Page";
    private static final String PAGE_TITLE = "Build Configuration";
    private static final String PAGE_DESCRIPTION = "";
    private IBuildConfigPageModel model;

    public BuildConfigPage(IWizard wizard, IBuildConfigPageModel model) {
        super(PAGE_TITLE, PAGE_DESCRIPTION, PAGE_NAME, wizard, model.getEnvVariablesModel());
        this.model = model;
    }

    protected void onPageWillGetActivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event, DataBindingContext dbc) {
        this.model.init();
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 2).applyTo(parent);
        Composite nameParent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(nameParent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameParent);
        new ResourceNameControl("Name: "){

            @Override
            protected void layoutLabel(Label resourceNameLabel) {
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)resourceNameLabel);
            }

            @Override
            protected void layoutText(Text resourceNameText) {
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)resourceNameText);
            }
        }.doCreateControl(nameParent, dbc, this.model);
        this.createSeparator(parent);
        this.createSourceControls(parent, dbc);
        this.createSeparator(parent);
        this.createTriggers(parent, dbc);
        this.createSeparator(parent);
        this.createEnvVariableControl(parent, dbc, "Build environment variables (Build and Runtime):", "Environment variables are used to configure and pass information to running containers.  These environment variables will be available during your build and at runtime.");
    }

    private void createTriggers(Composite parent, DataBindingContext dbc) {
        Label triggerLabel = new Label(parent, 0);
        triggerLabel.setText("Build Triggers:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)triggerLabel);
        Button webHookBtn = new Button(parent, 32);
        webHookBtn.setText("Configure a webhook build trigger");
        webHookBtn.setToolTipText("The source repository must be configured to use the webhook to trigger a build when source is committed.");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)webHookBtn);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)webHookBtn)).to(BeanProperties.value((String)"configWebHook").observe((Object)this.model)).in(dbc);
        Button imageChangeBtn = new Button(parent, 32);
        imageChangeBtn.setText("Automatically build a new image when the builder image changes");
        imageChangeBtn.setToolTipText("Automatically building a new image when the builder image changes allows your code to always run on the latest updates.");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)imageChangeBtn);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)imageChangeBtn)).to(BeanProperties.value((String)"imageChangeTrigger").observe((Object)this.model)).in(dbc);
        Button configChangeBtn = new Button(parent, 32);
        configChangeBtn.setText("Automatically build a new image when the build configuration changes");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)configChangeBtn);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)configChangeBtn)).to(BeanProperties.value((String)"configChangeTrigger").observe((Object)this.model)).in(dbc);
    }

    private void createSeparator(Composite parent) {
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)new Label(parent, 258));
    }

    private void createSourceControls(Composite root, DataBindingContext dbc) {
        Composite parent = new Composite(root, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(parent);
        Label gitUrlLabel = new Label(parent, 0);
        gitUrlLabel.setText("Git Repository URL:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)gitUrlLabel);
        Text gitUrlText = new Text(parent, 2048);
        gitUrlText.setToolTipText("The URL to the Git repository.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)gitUrlText);
        Binding gitUrlBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observeDelayed(500, (Widget)gitUrlText)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (UrlUtils.isValid((String)((String)value))) {
                    return Status.OK_STATUS;
                }
                return ValidationStatus.error((String)"A valid URL to a Git repository is required");
            }
        })).to(BeanProperties.value((String)"gitRepositoryUrl").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)gitUrlBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Label gitReferenceLabel = new Label(parent, 0);
        gitReferenceLabel.setText("Git Reference:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)gitReferenceLabel);
        gitReferenceLabel.setToolTipText("Optional branch, tag, or commit.");
        Text gitReferenceText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)gitReferenceText);
        ISWTObservableValue gitReferenceTextObservable = WidgetProperties.text((int)24).observe((Widget)gitReferenceText);
        GitReferenceValidator validator = new GitReferenceValidator((IObservableValue<String>)gitReferenceTextObservable);
        Binding gitReferenceBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)gitReferenceTextObservable).validatingAfterConvert((IValidator)validator)).to(BeanProperties.value((String)"gitReference").observe((Object)this.model)).in(dbc);
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        ControlDecorationSupport.create((ValidationStatusProvider)gitReferenceBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Label contextDirLabel = new Label(parent, 0);
        contextDirLabel.setText("Context Directory:");
        contextDirLabel.setToolTipText("Optional subdirectory for the application source code, used as the context directory for the build.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)contextDirLabel);
        Text contextDirText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)contextDirText);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)contextDirText)).to(BeanProperties.value((String)"contextDir").observe((Object)this.model)).in(dbc);
    }
}

