/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage;

import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.image.ITagReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;

public class ImageStreamApplicationSource
implements IApplicationSource {
    private final IImageStream is;
    private final ITagReference tag;

    public ImageStreamApplicationSource(IImageStream is, ITagReference tag) {
        this.is = is;
        this.tag = tag;
    }

    @Override
    public String getName() {
        return NLS.bind((String)"{0}:{1}", (Object)this.is.getName(), (Object)this.tag.getName());
    }

    @Override
    public String getNamespace() {
        return this.is.getNamespace();
    }

    public IImageStream getSource() {
        return this.is;
    }

    @Override
    public String getKind() {
        return this.is.getKind();
    }

    public ITagReference getSourceTag() {
        return this.tag;
    }

    @Override
    public Collection<String> getTags() {
        if (this.tag.isAnnotatedWith("tags")) {
            return Arrays.asList(this.tag.getAnnotation("tags").split(","));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isAnnotatedWith(String key) {
        return this.tag.isAnnotatedWith(key);
    }

    @Override
    public String getAnnotation(String key) {
        return this.tag.getAnnotation(key);
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.tag.getAnnotations();
    }
}

