/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate;

import com.openshift.restclient.model.template.IParameter;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class TemplateParameterViewerUtils {
    private TemplateParameterViewerUtils() {
    }

    public static String getValueLabel(IParameter parameter) {
        if (parameter == null) {
            return null;
        }
        boolean hasGenerator = StringUtils.isNotBlank((String)parameter.getGeneratorName());
        boolean hasValue = StringUtils.isNotBlank((String)parameter.getValue());
        if (hasGenerator) {
            return hasValue ? parameter.getValue() : "(generated)";
        }
        return StringUtils.defaultIfBlank((String)parameter.getValue(), (String)"");
    }

    public static class ParameterNameComparator
    implements Comparator<IParameter> {
        @Override
        public int compare(IParameter parameter1, IParameter parameter2) {
            return parameter1.getName().compareTo(parameter2.getName());
        }
    }

    public static class ParameterNameViewerComparator
    extends ViewerComparator {
        Comparator<IParameter> comparator = new ParameterNameComparator();

        public int compare(Viewer viewer, Object e1, Object e2) {
            IParameter first = (IParameter)e1;
            IParameter second = (IParameter)e2;
            return this.comparator.compare(first, second);
        }
    }
}

