/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.resource;

import com.openshift.restclient.model.IProject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.utils.ObservableTreeItemUtils;
import org.jboss.tools.openshift.internal.ui.wizard.resource.IResourcePayloadPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.resource.ProjectTreeItems;

public class NewResourceWizardModel
extends ObservablePojo
implements IResourcePayloadPageModel {
    private Connection connection;
    private IProject project;
    private List<ObservableTreeItem> projectItems = new ArrayList<ObservableTreeItem>();
    private String source;
    private Comparator<ObservableTreeItem> comparator;

    @Override
    public void loadResources() {
        if (this.connection == null) {
            return;
        }
        ObservableTreeItem connectionItem = ProjectTreeItems.INSTANCE.create(this.connection);
        connectionItem.load();
        List<ObservableTreeItem> projects = connectionItem.getChildren();
        this.setProjectItems(projects);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public void setConnection(Connection connection) {
        if (ObjectUtils.equals((Object)connection, (Object)this.connection)) {
            return;
        }
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
    }

    public Object getContext() {
        return null;
    }

    private void update(IProject project, List<ObservableTreeItem> projectItems, String source) {
        this.updateProjectItems(projectItems);
        this.project = this.getDefaultProject(project, projectItems);
        this.firePropertyChange("project", this.project, this.project);
        this.source = source;
        this.firePropertyChange("source", this.source, this.source);
    }

    private IProject getDefaultProject(IProject project, List<ObservableTreeItem> projectItems) {
        if (CollectionUtils.isEmpty(projectItems)) {
            return null;
        }
        if (project == null || !ObservableTreeItemUtils.contains(project, projectItems)) {
            if (this.comparator != null) {
                Collections.sort(projectItems, this.comparator);
            }
            project = ObservableTreeItemUtils.getFirstModel(IProject.class, projectItems);
        }
        return project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.update(project, this.projectItems, this.source);
    }

    @Override
    public List<ObservableTreeItem> getProjectItems() {
        return this.projectItems;
    }

    private void updateProjectItems(List<ObservableTreeItem> projectItems) {
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.projectItems);
        ArrayList<ObservableTreeItem> newItems = new ArrayList<ObservableTreeItem>();
        if (projectItems != null) {
            newItems.addAll(projectItems);
        }
        this.projectItems.clear();
        this.projectItems.addAll(newItems);
        this.firePropertyChange("projectItems", oldItems, this.projectItems);
    }

    private IProject checkProject(IProject project, List<ObservableTreeItem> projects) {
        if (projects != null) {
            return projects.stream().map(o -> o.getModel()).filter(model -> ObjectUtils.equals((Object)project, (Object)model)).findFirst().orElse(null);
        }
        return null;
    }

    public void setProjectItems(List<ObservableTreeItem> projectItems) {
        this.update(this.checkProject(this.project, projectItems), projectItems, this.source);
    }

    @Override
    public boolean hasProjects() {
        return this.projectItems != null && !this.projectItems.isEmpty();
    }

    @Override
    public void setSource(String source) {
        this.update(this.project, this.projectItems, source);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setProjectsComparator(Comparator<ObservableTreeItem> comparator) {
        this.comparator = comparator;
    }
}

