/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.project.examples.fixes.IProjectExamplesFix;
import org.jboss.tools.project.examples.internal.TokenizerUtil;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;

public abstract class AbstractProjectFix
implements IProjectExamplesFix {
    protected ProjectExample project;
    protected RequirementModel requirement;

    public AbstractProjectFix(ProjectExample project, RequirementModel requirement) {
        Assert.isNotNull((Object)requirement);
        this.project = project;
        this.requirement = requirement;
    }

    @Override
    public String getDescription() {
        return this.requirement.getProperties().get("description");
    }

    @Override
    public String getLabel() {
        return this.requirement.getType();
    }

    @Override
    public String getType() {
        return this.requirement.getType();
    }

    @Override
    public boolean isRequired() {
        return this.requirement.isRequired();
    }

    protected Collection<String> splitProperty(String propertyName) {
        String valueString = this.requirement.getProperties().get(propertyName);
        if (valueString == null) {
            return Collections.emptySet();
        }
        return TokenizerUtil.splitToSet(valueString);
    }

    public Collection<String> getConnectorIDs() {
        return this.splitProperty("connectorIds");
    }
}

