/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMonitorFocusJobDialog;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;

public class FastProgressMonitorFocusJobDialog
extends ProgressMonitorFocusJobDialog {
    public FastProgressMonitorFocusJobDialog(Shell parentShell) {
        super(parentShell);
    }

    public void run(boolean fork, boolean cancelable, Job j) throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = this.runnableWithProgress(j);
        Exception ex = null;
        try {
            Field jeorb = ProgressMonitorFocusJobDialog.class.getDeclaredField("job");
            jeorb.setAccessible(true);
            jeorb.set((Object)this, j);
            super.run(fork, cancelable, runnable);
            return;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        if (ex != null) {
            RuntimeUIActivator.pluginLog().logWarning("Unable to create FastProgressMonitorFocusJobDialog", (Throwable)ex);
        }
        new ProgressMonitorFocusJobDialog(this.getParentShell()).run(fork, cancelable, runnable);
    }

    private IRunnableWithProgress runnableWithProgress(final Job longJob) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                FastProgressMonitorFocusJobDialog.this.addRunableMonitorAsListener(longJob, FastProgressMonitorFocusJobDialog.this.getBlockingProgressMonitor(monitor));
                longJob.join();
            }
        };
        return runnable;
    }

    private IProgressMonitorWithBlocking getBlockingProgressMonitor(final IProgressMonitor monitor) {
        IProgressMonitorWithBlocking listener = new IProgressMonitorWithBlocking(){

            public void beginTask(String name, int totalWork) {
                monitor.beginTask(name, totalWork);
            }

            public void done() {
                monitor.done();
            }

            public void internalWorked(double work) {
                monitor.internalWorked(work);
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }

            public void setCanceled(boolean value) {
                monitor.setCanceled(value);
            }

            public void setTaskName(String name) {
                monitor.setTaskName(name);
            }

            public void subTask(String name) {
                monitor.subTask(name);
            }

            public void worked(int work) {
                monitor.worked(work);
            }

            public void setBlocked(IStatus reason) {
                if (monitor instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)monitor).setBlocked(reason);
                }
            }

            public void clearBlocked() {
                if (monitor instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)monitor).clearBlocked();
                }
            }
        };
        return listener;
    }

    private void addRunableMonitorAsListener(Job longJob, IProgressMonitorWithBlocking listener) {
        ProgressManager.JobMonitor jobMonitor = ProgressManager.getInstance().progressFor(longJob);
        try {
            Class<?> jMon = Class.forName("org.eclipse.ui.internal.progress.ProgressManager$JobMonitor");
            Class[] cArg = new Class[]{IProgressMonitorWithBlocking.class};
            Method m = jMon.getDeclaredMethod("addProgressListener", cArg);
            m.setAccessible(true);
            m.invoke((Object)jobMonitor, listener);
            System.out.println(jMon);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

