/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard.workflow;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.DownloadRuntimeMessages;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.wizard.workflow.DownloadManagerWorkflowUtility;

public class DownloadManagerTermsAndConditionsFragment
extends WizardFragment {
    public static final String WORKFLOW_NEXT_STEP_KEY = "WORKFLOW_NEXT_STEP_KEY_TC";
    private static final String DOWNLOAD_RUNTIME_SECTION = "downloadRuntimeSection";
    private IDialogSettings downloadRuntimeSection;
    private IWizardHandle handle;
    private WizardFragment nextWorkflowFragment = null;
    private String tocText;
    private String tcUrl;
    private HashMap<String, String> countryMap = null;
    private ArrayList<String> countryList = null;
    private boolean initialized = false;
    private Browser browser;
    private Button retry;

    public DownloadManagerTermsAndConditionsFragment() {
        IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
        this.downloadRuntimeSection = dialogSettings.getSection(DOWNLOAD_RUNTIME_SECTION);
        if (this.downloadRuntimeSection == null) {
            this.downloadRuntimeSection = dialogSettings.addNewSection(DOWNLOAD_RUNTIME_SECTION);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.nextWorkflowFragment != null) {
            list.add(this.nextWorkflowFragment);
        }
    }

    public void enter() {
        this.setComplete(false);
        if (!this.initialized) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerTermsAndConditionsFragment.this.deferredEntry();
                }
            });
        }
    }

    private void deferredEntry() {
        try {
            this.handle.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DownloadManagerTermsAndConditionsFragment.this.initializeModel(monitor);
                }
            });
            this.fillWidgets();
            this.initialized = true;
            this.handle.update();
        }
        catch (Exception e) {
            RuntimeUIActivator.pluginLog().logError((Throwable)e);
        }
    }

    protected void initializeModel(IProgressMonitor monitor) {
        String plaintext;
        monitor.beginTask("Loading Terms and Conditions", 1000);
        String workflowResponse = (String)this.getTaskModel().getObject("WORKFLOW_NEXT_STEP_KEY");
        if (workflowResponse == null || workflowResponse.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Exception e = new Exception("Unable to locate url for downloading runtime: Rest API response is empty.");
                    RuntimeCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
                    DownloadManagerTermsAndConditionsFragment.this.handle.setMessage(e.getMessage(), 3);
                }
            });
            return;
        }
        XMLMemento m = XMLMemento.createReadRoot((InputStream)new ByteArrayInputStream(workflowResponse.getBytes()));
        IMemento workflow = m.getChild("workflow");
        IMemento tc = workflow.getChild("tc");
        IMemento tcAccept = workflow.getChild("tc-accept");
        this.tcUrl = ((XMLMemento)tc).getTextData();
        monitor.worked(100);
        String tcResponseString = null;
        try {
            tcResponseString = this.getTCResponseString((IProgressMonitor)new SubProgressMonitor(monitor, 800));
        }
        catch (Exception e) {
            final String msg = "An error occurred while loading the terms and conditions: " + e.getClass().getName() + " - " + e.getMessage();
            RuntimeCoreActivator.pluginLog().logError(msg, (Throwable)e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerTermsAndConditionsFragment.this.handle.setMessage(msg, 3);
                }
            });
            return;
        }
        XMLMemento tocResponseMemento = XMLMemento.createReadRoot((InputStream)new ByteArrayInputStream(tcResponseString.getBytes()));
        IMemento customParamsMemento = tocResponseMemento.getChild("customParams");
        IMemento[] params = customParamsMemento.getChildren("param");
        IMemento countryParam = null;
        IMemento downloadURLParam = null;
        int i = 0;
        while (i < params.length) {
            String name = params[i].getString("name");
            if (name.equals("country")) {
                countryParam = params[i];
            }
            if (name.equals("downloadURL")) {
                downloadURLParam = params[i];
            }
            ++i;
        }
        IMemento countryOptions = countryParam.getChild("options");
        IMemento[] countries = countryOptions.getChildren("option");
        this.countryMap = new HashMap();
        this.countryList = new ArrayList();
        int i2 = 0;
        while (i2 < countries.length) {
            this.countryList.add(countries[i2].getString("key"));
            this.countryMap.put(countries[i2].getString("key"), countries[i2].getString("value"));
            ++i2;
        }
        IMemento downloadURLOptions = downloadURLParam.getChild("options");
        IMemento downloadURLOption = downloadURLOptions.getChild("option");
        IMemento tcPlainTextMemento = tocResponseMemento.getChild("htmlText");
        this.tocText = plaintext = ((XMLMemento)tcPlainTextMemento).getTextData();
        monitor.worked(100);
        monitor.done();
    }

    private void fillWidgets() {
        if (this.browser != null && !this.browser.isDisposed() && this.tocText != null) {
            this.browser.setText(this.tocText);
        }
    }

    private String getTCResponseString(IProgressMonitor monitor) throws Exception {
        String line;
        String result = "";
        HttpURLConnection con = (HttpURLConnection)new URL(this.tcUrl).openConnection();
        con.setRequestMethod("GET");
        InputStream stream = con.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        while ((line = br.readLine()) != null) {
            result = String.valueOf(result) + line;
        }
        con.disconnect();
        br.close();
        return result;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle("JBoss.org Terms and Conditions");
        this.getPage().setDescription("Please use the link below to sign the terms and conditions. Once complete, please press 'Retry' to continue.");
        Composite contents = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new FormLayout());
        try {
            this.browser = new Browser(contents, 2048);
        }
        catch (Exception e1) {
            this.browser = new Browser(contents, 67584);
        }
        this.retry = new Button(contents, 8);
        this.retry.setText("Retry");
        this.retry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadManagerTermsAndConditionsFragment.this.retryPressed();
            }
        });
        FormData fd = new FormData();
        fd.bottom = new FormAttachment(0, 400);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.top = new FormAttachment(0, 5);
        this.browser.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.browser, 10);
        fd.left = new FormAttachment(0, 5);
        this.retry.setLayoutData((Object)fd);
        this.setComplete(false);
        this.fillWidgets();
        return contents;
    }

    private DownloadRuntime getDownloadRuntimeFromTaskModel() {
        return (DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop");
    }

    protected void retryPressed() {
        String userS = (String)this.getTaskModel().getObject("dl.runtime.username");
        String passS = (String)this.getTaskModel().getObject("dl.runtime.password");
        String errString = null;
        try {
            int response = DownloadManagerWorkflowUtility.getWorkflowStatus(this.getDownloadRuntimeFromTaskModel(), userS, passS);
            if (response == 2) {
                errString = DownloadRuntimeMessages.CredentialsIncorrect;
            } else if (response == 3) {
                errString = "Your authorization process is still incomplete. Please press 'back' and try again.";
            } else if (response == 1) {
                this.setComplete(true);
                this.handle.update();
            }
        }
        catch (IOException e) {
            RuntimeUIActivator.pluginLog().logError((Throwable)e);
            errString = NLS.bind((String)DownloadRuntimeMessages.CredentialError, (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        catch (CoreException ce) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ce);
            errString = NLS.bind((String)DownloadRuntimeMessages.CredentialError, (Object)((Object)((Object)ce)).getClass().getName(), (Object)ce.getMessage());
        }
        if (errString != null) {
            this.setComplete(false);
            this.handle.setMessage(errString, 3);
            this.handle.update();
        }
    }

    public void finishPage() {
    }
}

