/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.vpe.resref.core.Messages;
import org.jboss.tools.vpe.resref.core.ResourceReferenceValidator;

public class TaglibResourceReferenceValidator
extends ResourceReferenceValidator {
    public static final String TAGLIB_URI = "taglibUri";
    public static final String TAGLIB_PREFIX = "taglibPrefix";
    public static final String PREFIX_STR_PATTERN = "[A-Za-z_]|[^\\x00-\\x7F]";
    public static final String PREFIX_CHAR_PATTERN = "[A-Za-z0-9_.-]|[^\\x00-\\x7F]";
    public static final String PREFIX_PATTERN = "([A-Za-z_]|[^\\x00-\\x7F])([A-Za-z0-9_.-]|[^\\x00-\\x7F])*";

    public TaglibResourceReferenceValidator() {
    }

    public TaglibResourceReferenceValidator(Map<String, String> fields) {
        super(fields);
    }

    @Override
    protected boolean validate() {
        this.pageComplete = false;
        if (this.fields != null) {
            String taglibUri = (String)this.fields.get(TAGLIB_URI);
            String taglibPrefix = (String)this.fields.get(TAGLIB_PREFIX);
            if (taglibUri != null && taglibUri.length() > 0) {
                if (taglibPrefix != null && taglibPrefix.length() > 0) {
                    try {
                        new URI(taglibUri);
                        this.pageComplete = true;
                        this.errorMessage = null;
                    }
                    catch (URISyntaxException ex) {
                        this.errorMessage = NLS.bind((String)Messages.INCORRECT_URI, (Object)taglibUri);
                    }
                    if (taglibPrefix.matches(PREFIX_PATTERN)) {
                        this.pageComplete = true;
                        this.errorMessage = null;
                    } else {
                        this.errorMessage = NLS.bind((String)Messages.INCORRECT_PREFIX, (Object)taglibPrefix);
                    }
                } else {
                    this.errorMessage = Messages.PREFIX_SHOULD_BE_SET;
                }
            } else {
                this.errorMessage = Messages.URI_SHOULD_BE_SET;
            }
        }
        return this.pageComplete;
    }
}

