/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.browser;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.vpe.xulrunner.BrowserPlugin;
import org.mozilla.xpcom.IAppFileLocProvider;

public class AppFileLocProvider
implements IAppFileLocProvider {
    private File xulRunnerPath;
    private File userDataPath;
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String HISTORY_FILE = "history.dat";
    private static final String COMPREG_FILE = "compreg.dat";
    private static final String XPTI_FILE = "xpti.dat";
    private static final String COMPONENTS_DIRECTORY = "components";

    public AppFileLocProvider(File xulRunnerPath) {
        this.xulRunnerPath = xulRunnerPath;
        this.userDataPath = Platform.getLocation().append(".metadata/.plugins").append("org.jboss.tools.vpe.xulrunner").append("xulrunner").toFile();
    }

    public File getFile(String prop, boolean[] persistent) {
        persistent[0] = false;
        File resultFile = null;
        if ("ProfD".equals(prop)) {
            resultFile = this.userDataPath;
        } else if ("UHist".equals(prop)) {
            resultFile = new File(this.userDataPath, HISTORY_FILE);
        } else if ("ComRegF".equals(prop)) {
            resultFile = new File(this.userDataPath, COMPREG_FILE);
        } else if ("XptiRegF".equals(prop)) {
            resultFile = new File(this.userDataPath, XPTI_FILE);
        } else if ("GreD".equals(prop)) {
            resultFile = this.xulRunnerPath;
        } else if ("GreComsD".equals(prop) || "ComsD".equals(prop)) {
            resultFile = new File(this.xulRunnerPath, COMPONENTS_DIRECTORY);
        }
        if (BrowserPlugin.DEBUG_BROWSERSTART) {
            System.out.println("AppFileLocProvider.getFile(" + prop + ")=\"" + (resultFile == null ? "null" : resultFile.toString()) + "\"");
        }
        return resultFile;
    }

    public File[] getFiles(String prop) {
        File[] resultFiles = null;
        if ("APluginsDL".equals(prop)) {
            resultFiles = new File[]{new File(this.xulRunnerPath, PLUGINS_DIRECTORY)};
        }
        if (BrowserPlugin.DEBUG_BROWSERSTART && resultFiles != null) {
            int size = resultFiles.length;
            System.out.print("AppFileLocProvider.getFiles(" + prop + ")={\"");
            int i = 0;
            while (i < size) {
                System.out.print(String.valueOf(i > 0 ? ", " : "") + resultFiles[i].toString());
                ++i;
            }
            System.out.println("\"}");
        }
        return resultFiles;
    }
}

