/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.vpe.Messages;
import org.jboss.tools.vpe.VpeDebug;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class VpePlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.vpe";
    public static final String EXTESION_POINT_VPE_TEMPLATES = "org.jboss.tools.vpe.templates";
    private static final String EDITOR_EVENT_ACTION = "editor";
    private static final String SOURCE_EVENT_LABEL = "source";
    private static final String VPE_EVENT_LABEL = "visual-vpe";
    private static final String VPV_EVENT_LABEL = "visual-vpv";
    private static VpePlugin plugin;
    private UsageEventType editorEventType;

    public VpePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.editorEventType = new UsageEventType((Plugin)this, EDITOR_EVENT_ACTION, Messages.UsageEventTypeEditorLabelDescription, UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);
        UsageReporter.getInstance().registerEvent(this.editorEventType);
    }

    public void countSourceTabEvent() {
        UsageReporter.getInstance().countEvent(this.editorEventType.event(SOURCE_EVENT_LABEL));
    }

    public void countVpeTabEvent() {
        UsageReporter.getInstance().countEvent(this.editorEventType.event(VPE_EVENT_LABEL));
    }

    public void countVpvTabEvent() {
        UsageReporter.getInstance().countEvent(this.editorEventType.event(VPV_EVENT_LABEL));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static VpePlugin getDefault() {
        return plugin;
    }

    public static void reportProblem(Exception throwable) {
        if (VpeDebug.USE_PRINT_STACK_TRACE) {
            throwable.printStackTrace();
        }
    }

    public String getResourcePath(String resourceName) {
        URL url;
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        if (bundle != null && (url = bundle.getEntry(resourceName)) != null) {
            try {
                return FileLocator.resolve((URL)url).getPath();
            }
            catch (IOException ioe) {
                this.logError(ioe);
            }
        }
        return null;
    }

    public static IPluginLog getPluginLog() {
        return VpePlugin.getDefault();
    }

    public static String getPluginResourcePath() {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = null;
        try {
            url = bundle == null ? null : FileLocator.resolve((URL)bundle.getEntry("/ve"));
        }
        catch (IOException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        return url == null ? null : url.getPath();
    }
}

