/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import org.eclipse.swt.graphics.Point;
import org.jboss.tools.vpe.dnd.DndUtil;
import org.jboss.tools.vpe.dnd.IDraggableFragment;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;

public class DraggablePattern {
    private static final int ICON_HEIGHT = 20;
    private static final String DRAG_ICON_ID = "dragIcon";
    private static final String DRAG_ICON_FILE = "dragIcon.gif";
    private static final String TRANSPARENT_DIV_ID = "transparentDragDiv";
    private static final int TRANSPARENT_DIV_SIZE = 360;
    private static final String TRANSPARENT_DIV_STYLE = "background-color: rgba(255, 0, 0, 0.0);height:360px;width:360px;position:absolute;";
    private static final String DRAG_ICON_STYLE = "display:none;position: absolute;cursor: move;";
    private int offsetX;
    private int offsetY;
    private boolean sessionStarted = false;
    private nsIDOMElement draggableFragmentRepresentation;
    private IDraggableFragment draggableFragment;
    private final MozillaEditor mozillaEditor;

    public DraggablePattern(MozillaEditor mozillaEditor) {
        this.mozillaEditor = mozillaEditor;
    }

    public void showDragIcon(IDraggableFragment draggableFragment) {
        this.draggableFragment = draggableFragment;
        Point position = draggableFragment.getPosition();
        nsIDOMElement dragIcon = this.getDragIcon();
        VpeStyleUtil.setElementVisible(dragIcon, true);
        VpeStyleUtil.moveElementTo(dragIcon, position.x, position.y - 20);
    }

    public void hideDragIcon() {
        this.draggableFragment = null;
        VpeStyleUtil.setElementVisible(this.getDragIcon(), false);
    }

    private nsIDOMElement getDragIcon() {
        nsIDOMElement dragIconElement = this.mozillaEditor.getDomDocument().getElementById(DRAG_ICON_ID);
        if (dragIconElement == null) {
            dragIconElement = this.mozillaEditor.getDomDocument().createElement("img");
            DndUtil.setTemporaryDndElement(dragIconElement, true);
            nsIDOMNode bodyNode = this.mozillaEditor.getDomDocument().getElementsByTagName("body").item(0L);
            if (bodyNode != null) {
                bodyNode.appendChild((nsIDOMNode)dragIconElement);
            }
            dragIconElement.setAttribute("id", DRAG_ICON_ID);
            dragIconElement.setAttribute("src", VpeStyleUtil.getAbsoluteResourcePathUrl(DRAG_ICON_FILE));
            dragIconElement.setAttribute("style", DRAG_ICON_STYLE);
        }
        return dragIconElement;
    }

    private nsIDOMElement getTransparentDiv() {
        nsIDOMElement transparentDiv = this.mozillaEditor.getDomDocument().getElementById(TRANSPARENT_DIV_ID);
        if (transparentDiv == null) {
            transparentDiv = this.mozillaEditor.getDomDocument().createElement("div");
            DndUtil.setTemporaryDndElement(transparentDiv, true);
            this.mozillaEditor.getDomDocument().getElementsByTagName("body").item(0L).appendChild((nsIDOMNode)transparentDiv);
            transparentDiv.setAttribute("id", TRANSPARENT_DIV_ID);
            transparentDiv.setAttribute("style", TRANSPARENT_DIV_STYLE);
        }
        return transparentDiv;
    }

    public boolean isDragIconClicked(nsIDOMMouseEvent mouseEvent) {
        nsIDOMElement targetElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)mouseEvent.getTarget(), nsIDOMElement.class);
        if (targetElement != null) {
            return DRAG_ICON_ID.equals(targetElement.getAttribute("id"));
        }
        return false;
    }

    public void startSession(int mouseStartX, int mouseStartY) {
        if (this.sessionStarted) {
            new IllegalStateException("Session is already started.");
        }
        if (this.draggableFragment == null) {
            new IllegalStateException("No node to drag.");
        }
        Point fragmentPosition = this.draggableFragment.getPosition();
        this.offsetX = fragmentPosition.x - mouseStartX;
        this.offsetY = fragmentPosition.y - mouseStartY;
        this.draggableFragmentRepresentation = this.draggableFragment.createRepresentation();
        this.moveTo(mouseStartX, mouseStartY);
        this.setVisible(true);
        this.sessionStarted = true;
    }

    public void closeSession() {
        if (this.sessionStarted) {
            this.setVisible(false);
            nsIDOMNode parent = this.draggableFragmentRepresentation.getParentNode();
            if (parent != null) {
                parent.removeChild((nsIDOMNode)this.draggableFragmentRepresentation);
            }
            this.hideDragIcon();
            this.draggableFragmentRepresentation = null;
            this.sessionStarted = false;
        }
    }

    public void setVisible(boolean visible) {
        VpeStyleUtil.setElementVisible(this.draggableFragmentRepresentation, visible);
        VpeStyleUtil.setElementVisible(this.getTransparentDiv(), visible);
        VpeStyleUtil.setElementVisible(this.getDragIcon(), visible);
    }

    public void moveTo(int mouseX, int mouseY) {
        VpeStyleUtil.moveElementTo(this.draggableFragmentRepresentation, this.offsetX + mouseX, this.offsetY + mouseY);
        VpeStyleUtil.moveElementTo(this.getTransparentDiv(), this.offsetX + mouseX - 180, this.offsetY + mouseY - 180);
        VpeStyleUtil.moveElementTo(this.getDragIcon(), this.offsetX + mouseX, this.offsetY + mouseY - 20);
    }
}

