/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeDomMapping {
    private Map<Node, VpeNodeMapping> sourceMap = new HashMap<Node, VpeNodeMapping>();
    private Map<nsIDOMNode, VpeNodeMapping> visualMap = new HashMap<nsIDOMNode, VpeNodeMapping>();
    private VpePageContext pageContext;

    public VpeDomMapping(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    public void mapNodes(VpeNodeMapping nodeMapping) {
        this.sourceMap.put(nodeMapping.getSourceNode(), nodeMapping);
        if (nodeMapping.getVisualNode() != null) {
            this.visualMap.put(nodeMapping.getVisualNode(), nodeMapping);
        }
    }

    public void remapVisualNode(nsIDOMNode visualNode, nsIDOMNode registeredVisualNewNode) {
        VpeNodeMapping nodeMapping;
        if (visualNode != null && registeredVisualNewNode != null && (nodeMapping = this.visualMap.get(visualNode)) != null) {
            nodeMapping.setVisualNode(registeredVisualNewNode);
            this.visualMap.remove(visualNode);
            this.visualMap.put(registeredVisualNewNode, nodeMapping);
        }
    }

    public void clear(nsIDOMNode except) {
        this.sourceMap.clear();
        VpeNodeMapping exceptMapping = this.visualMap.get(except);
        this.visualMap.clear();
        if (exceptMapping != null) {
            this.visualMap.put(except, exceptMapping);
        }
    }

    public VpeNodeMapping getNodeMapping(Node node) {
        return this.getNodeMappingAtSourceNode(node);
    }

    public VpeNodeMapping getNodeMapping(nsIDOMNode node) {
        return this.getNodeMappingAtVisualNode(node);
    }

    public VpeNodeMapping getNodeMappingAtSourceNode(Node sourceNode) {
        VpeNodeMapping nodeMapping = null;
        if (sourceNode != null) {
            nodeMapping = this.sourceMap.get(sourceNode);
        }
        return nodeMapping;
    }

    public VpeNodeMapping getNodeMappingAtVisualNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = null;
        if (visualNode != null) {
            try {
                nodeMapping = this.visualMap.get(XPCOM.queryInterface((nsISupports)visualNode, nsIDOMNode.class));
            }
            catch (XPCOMException e) {
                VpePlugin.getDefault().logError("Cannot cast visualNode to nsIDOMNode type", e);
            }
        }
        return nodeMapping;
    }

    public nsIDOMNode getVisualNode(Node sourceNode) {
        VpeNodeMapping nodeMapping = this.getNodeMapping(sourceNode);
        if (nodeMapping != null) {
            return nodeMapping.getVisualNode();
        }
        return null;
    }

    public Node getSourceNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNodeMapping(visualNode);
        if (nodeMapping != null) {
            return nodeMapping.getSourceNode();
        }
        return null;
    }

    public VpeNodeMapping getNearNodeMapping(Node node) {
        return this.getNearNodeMappingAtSourceNode(node);
    }

    public VpeNodeMapping getNearNodeMapping(nsIDOMNode node) {
        return this.getNearNodeMappingAtVisualNode(node);
    }

    public VpeNodeMapping getNearNodeMappingAtSourceNode(Node sourceNode) {
        nsIDOMElement visualElement;
        nsIDOMNode nearVisualNode;
        VpeNodeMapping nodeMapping = this.getNodeMappingAtSourceNode(sourceNode);
        while (sourceNode != null && nodeMapping == null) {
            sourceNode = sourceNode instanceof Attr ? ((Attr)sourceNode).getOwnerElement() : sourceNode.getParentNode();
            nodeMapping = this.getNodeMappingAtSourceNode(sourceNode);
            if (sourceNode == null || nodeMapping == null || !((nearVisualNode = nodeMapping.getVisualNode()) instanceof nsIDOMElement)) continue;
            visualElement = (nsIDOMElement)nearVisualNode;
            visualElement.setAttribute(XulRunnerEditor.VPE_INVISIBLE_ELEMENT, Boolean.TRUE.toString());
        }
        if (sourceNode != null && nodeMapping != null && (nearVisualNode = nodeMapping.getVisualNode()) instanceof nsIDOMElement) {
            visualElement = (nsIDOMElement)nearVisualNode;
            visualElement.removeAttribute(XulRunnerEditor.VPE_INVISIBLE_ELEMENT);
        }
        return nodeMapping;
    }

    public VpeNodeMapping getNearNodeMappingAtVisualNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNodeMappingAtVisualNode(visualNode);
        while (visualNode != null && nodeMapping == null) {
            visualNode = visualNode.getParentNode();
            nodeMapping = this.getNodeMappingAtVisualNode(visualNode);
        }
        return nodeMapping;
    }

    public VpeNodeMapping getNearParentMapping(Node sourceNode) {
        VpeNodeMapping nodeMapping = null;
        if (sourceNode.getNodeType() == 1) {
            nodeMapping = this.getNearNodeMapping(sourceNode);
        } else if (sourceNode.getNodeType() == 3) {
            sourceNode = sourceNode.getParentNode();
            nodeMapping = this.getNodeMapping(sourceNode);
            while (sourceNode != null && sourceNode.getNodeType() != 9 && nodeMapping == null) {
                sourceNode = sourceNode.getParentNode();
                nodeMapping = this.getNodeMapping(sourceNode);
            }
        }
        return nodeMapping;
    }

    public VpeNodeMapping getParentMapping(Node sourceNode) {
        VpeNodeMapping nodeMapping = null;
        sourceNode = sourceNode.getParentNode();
        nodeMapping = this.getNodeMapping(sourceNode);
        while (sourceNode != null && sourceNode.getNodeType() != 9 && nodeMapping == null) {
            sourceNode = sourceNode.getParentNode();
            nodeMapping = this.getNodeMapping(sourceNode);
        }
        return nodeMapping;
    }

    public VpeElementMapping getNearElementMapping(Node node) {
        return this.getNearElementMappingAtSourceNode(node);
    }

    public VpeElementMapping getNearElementMapping(nsIDOMNode node) {
        return this.getNearElementMappingAtVisualNode(node);
    }

    public VpeElementMapping getNearElementMappingAtSourceNode(Node sourceNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtSourceNode(sourceNode);
        if (nodeMapping != null) {
            if (nodeMapping instanceof VpeElementMapping) {
                return (VpeElementMapping)nodeMapping;
            }
            return this.getNearElementMappingAtSourceNode(nodeMapping.getSourceNode().getParentNode());
        }
        return null;
    }

    public VpeElementMapping getNearElementMappingAtVisualNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtVisualNode(visualNode);
        if (nodeMapping != null) {
            if (nodeMapping instanceof VpeElementMapping) {
                return (VpeElementMapping)nodeMapping;
            }
            return this.getNearElementMappingAtSourceNode(nodeMapping.getSourceNode().getParentNode());
        }
        return null;
    }

    public nsIDOMNode getNearVisualNode_(Node sourceNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMapping(sourceNode);
        if (nodeMapping != null) {
            return nodeMapping.getVisualNode();
        }
        return null;
    }

    public nsIDOMElement getNearVisualElement(Node sourceNode) {
        nsIDOMElement element;
        block7: {
            element = null;
            VpeNodeMapping nodeMapping = this.getNearNodeMappingAtSourceNode(sourceNode);
            if (sourceNode != null) {
                if (nodeMapping != null) {
                    nsIDOMNode visualNode = nodeMapping.getVisualNode();
                    if (visualNode != null) {
                        try {
                            element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
                        }
                        catch (XPCOMException xpcomException) {
                            if (sourceNode.getPreviousSibling() != null) {
                                element = this.getNearVisualElement(sourceNode.getPreviousSibling());
                                break block7;
                            }
                            element = this.getNearVisualElement(sourceNode.getParentNode());
                        }
                    }
                } else {
                    element = sourceNode.getPreviousSibling() != null ? this.getNearVisualElement(sourceNode.getPreviousSibling()) : this.getNearVisualElement(sourceNode.getParentNode());
                }
            }
        }
        return element;
    }

    public nsIDOMNode getNearVisualNode(Node sourceNode) {
        if (sourceNode == null) {
            return null;
        }
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtSourceNode(sourceNode);
        if (nodeMapping != null) {
            if (nodeMapping.getVisualNode() == null) {
                return this.getNearVisualNode(sourceNode.getParentNode());
            }
            return nodeMapping.getVisualNode();
        }
        return null;
    }

    public ElementImpl getNearSourceElementImpl(nsIDOMNode visualNode) {
        ElementImpl element = null;
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtVisualNode(visualNode);
        if (visualNode != null) {
            element = nodeMapping != null && nodeMapping.getSourceNode() != null && nodeMapping.getSourceNode() instanceof ElementImpl ? (ElementImpl)nodeMapping.getSourceNode() : (visualNode.getNextSibling() != null ? this.getNearSourceElementImpl(visualNode.getNextSibling()) : this.getNearSourceElementImpl(visualNode.getParentNode()));
        }
        return element;
    }

    public Node getNearSourceNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMapping(visualNode);
        if (nodeMapping != null) {
            return nodeMapping.getSourceNode();
        }
        return null;
    }

    public nsIDOMNode remove(Node sourceNode) {
        nsIDOMNode visualNode = this.getVisualNode(sourceNode);
        this.removeImpl(sourceNode);
        return visualNode;
    }

    public void removeChildren(Node sourceNode) {
        NodeList sourceChildren = sourceNode.getChildNodes();
        if (sourceChildren != null) {
            int len = sourceChildren.getLength();
            int i = 0;
            while (i < len) {
                this.removeImpl(sourceChildren.item(i));
                ++i;
            }
        }
    }

    private VpeNodeMapping removeImpl(Node sourceNode) {
        nsIDOMNode visualNode = null;
        VpeNodeMapping nodeMapping = this.sourceMap.remove(sourceNode);
        if (nodeMapping != null) {
            visualNode = nodeMapping.getVisualNode();
            if (visualNode != null) {
                this.visualMap.remove(visualNode);
            }
            if (nodeMapping instanceof VpeElementMapping) {
                VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
                elementMapping.getTemplate().beforeRemove(this.pageContext, elementMapping.getSourceNode(), elementMapping.getVisualNode(), elementMapping.getData());
            }
        }
        this.removeChildren(sourceNode);
        return nodeMapping;
    }

    public void printMapping() {
        nsIDOMNode visualNode;
        Node sourceNode;
        VpeNodeMapping nodeMapping;
        System.out.println("Source DOM Mapping ------------------------------------");
        Set<Map.Entry<Node, VpeNodeMapping>> entrySet = this.sourceMap.entrySet();
        for (Map.Entry<Node, VpeNodeMapping> entry : entrySet) {
            nodeMapping = entry.getValue();
            sourceNode = nodeMapping.getSourceNode();
            visualNode = nodeMapping.getVisualNode();
            System.out.println("sourceNode: " + sourceNode.getNodeName() + " (" + sourceNode.hashCode() + ")    visualNode: " + (visualNode != null ? String.valueOf(visualNode.getNodeName()) + " (" + visualNode.hashCode() + ")" : null));
        }
        System.out.println("Visual DOM Mapping ------------------------------------");
        entrySet = this.visualMap.entrySet();
        for (Map.Entry<Node, VpeNodeMapping> entry : entrySet) {
            nodeMapping = entry.getValue();
            sourceNode = nodeMapping.getSourceNode();
            visualNode = nodeMapping.getVisualNode();
            System.out.println("sourceNode: " + (sourceNode != null ? String.valueOf(sourceNode.getNodeName()) + " (" + sourceNode.hashCode() + ")" : null) + "    visualNode: " + visualNode.getNodeName() + " (" + visualNode.hashCode() + ")");
        }
    }

    public Map<nsIDOMNode, VpeNodeMapping> getVisualMap() {
        return this.visualMap;
    }

    public Map<Node, VpeNodeMapping> getSourceMap() {
        return this.sourceMap;
    }
}

