/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ModelQueryActionHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ModelQueryImpl;
import org.eclipse.wst.xml.ui.internal.actions.MenuBuilder;
import org.eclipse.wst.xml.ui.internal.util.XMLCommonResources;
import org.jboss.tools.vpe.editor.menu.ITextNodeSplitter;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public abstract class BaseActionManager {
    protected ModelQuery modelQuery;
    protected MenuBuilder menuBuilder = new MenuBuilder();
    protected IStructuredModel model;
    protected static ITextNodeSplitter textNodeSplitter;
    public static final String INSERT_AROUND_MENU;
    public static final String INSERT_BEFORE_MENU;
    public static final String INSERT_AFTER_MENU;
    public static final String REPLACE_TAG_MENU;
    public static final String INSERT_TAG_MENU;
    static HashSet noContainerTags;

    static {
        INSERT_AROUND_MENU = VpeUIMessages.BaseActionManager_InsertAround;
        INSERT_BEFORE_MENU = VpeUIMessages.BaseActionManager_InsertBefore;
        INSERT_AFTER_MENU = VpeUIMessages.BaseActionManager_InsertAfter;
        REPLACE_TAG_MENU = VpeUIMessages.BaseActionManager_ReplaceWith;
        INSERT_TAG_MENU = VpeUIMessages.BaseActionManager_InsertTag;
        noContainerTags = new HashSet();
        noContainerTags.add("basefont");
        noContainerTags.add("bgsound");
        noContainerTags.add("br");
        noContainerTags.add("img");
        noContainerTags.add("input");
        noContainerTags.add("isindex");
        noContainerTags.add("script");
        noContainerTags.add("wbr");
    }

    public static void setTextNodeSplitter(ITextNodeSplitter splitter) {
        textNodeSplitter = splitter;
    }

    protected BaseActionManager(IStructuredModel model, ModelQuery modelQuery) {
        this.model = model;
        this.modelQuery = modelQuery;
    }

    protected abstract Action createAddAttributeAction(Element var1, CMAttributeDeclaration var2);

    protected abstract Action createAddCDataSectionAction(Node var1, int var2);

    protected abstract Action createAddPCDataAction(Node var1, CMDataType var2, int var3);

    protected abstract Action createAddCommentAction(Node var1, int var2);

    protected abstract Action createAddDoctypeAction(Document var1, int var2);

    protected abstract Action createAddElementAction(Node var1, CMElementDeclaration var2, int var3, int var4);

    protected abstract Action createAddProcessingInstructionAction(Node var1, int var2);

    protected abstract Action createAddSchemaInfoAction(Element var1);

    protected abstract Action createEditAttributeAction(Attr var1, CMAttributeDeclaration var2);

    protected abstract Action createEditDoctypeAction(DocumentType var1);

    protected abstract Action createEditProcessingInstructionAction(ProcessingInstruction var1);

    protected abstract Action createEditSchemaInfoAction(Element var1);

    protected abstract Action createRenameAction(Node var1);

    protected abstract Action createReplaceAction(Node var1, CMNode var2, int var3, int var4);

    protected abstract Action createDeleteAction(List var1);

    public void contributeActionsForVpe(IMenuManager menu, List selection) {
        int editMode = this.modelQuery.getEditMode();
        int includeOptions = editMode == 2 ? 6 : 2;
        int validityChecking = editMode == 2 ? 2 : 0;
        List implicitlySelectedNodeList = null;
        if (selection.size() > 0) {
            implicitlySelectedNodeList = this.getSelectedNodes(selection, true);
            if (selection.size() == 1) {
                Node node = (Node)selection.get(0);
                this.contributeAddSiblingActions(menu, node, true);
            }
            this.contributeReplaceActions(menu, implicitlySelectedNodeList, includeOptions, validityChecking);
        } else {
            MyMenuManager addTagMenu = new MyMenuManager(INSERT_TAG_MENU, true);
            menu.add((IContributionItem)addTagMenu);
        }
    }

    public void contributeDeleteActionForVpe(IMenuManager menu, List selection) {
        int editMode = this.modelQuery.getEditMode();
        int includeOptions = editMode == 2 ? 6 : 2;
        int validityChecking = editMode == 2 ? 2 : 0;
        List implicitlySelectedNodeList = null;
        if (selection.size() > 0) {
            implicitlySelectedNodeList = this.getSelectedNodes(selection, true);
            menu.add((IContributionItem)new Separator());
            this.contributeDeleteActions(menu, implicitlySelectedNodeList, includeOptions, validityChecking);
        }
    }

    protected void contributeAction(IMenuManager menu, Action action) {
        if (action != null) {
            menu.add((IAction)action);
        }
    }

    protected void contributeEditActions(IMenuManager menu, Node node) {
        this.contributeEditGrammarInformationActions(menu, node);
        if (node.getNodeType() == 7) {
            this.contributeAction(menu, this.createEditProcessingInstructionAction((ProcessingInstruction)node));
        } else if (node.getNodeType() == 2) {
            this.contributeAction(menu, this.createEditAttributeAction((Attr)node, null));
        }
    }

    protected void contributeEditGrammarInformationActions(IMenuManager menu, Node node) {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        DocumentType doctype = BaseActionManager.getDoctype(node);
        if (doctype == null) {
            this.contributeAction(menu, this.createAddDoctypeAction(document, -1));
        }
        if (node.getNodeType() == 10) {
            this.contributeAction(menu, this.createEditDoctypeAction((DocumentType)node));
        }
        if (doctype == null && this.getRootElement(document) != null) {
            this.contributeAction(menu, this.createEditSchemaInfoAction(this.getRootElement(document)));
        }
    }

    protected void contributeAddChildActions(IMenuManager menu, Node node, int includeOptions, int validityChecking) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            Element element = (Element)node;
            MyMenuManager addAttributeMenu = new MyMenuManager(XMLCommonResources.getInstance().getString("_UI_MENU_ADD_ATTRIBUTE"));
            MyMenuManager addChildMenu = new MyMenuManager(XMLCommonResources.getInstance().getString("_UI_MENU_ADD_CHILD"));
            menu.add((IContributionItem)addAttributeMenu);
            menu.add((IContributionItem)addChildMenu);
            CMElementDeclaration ed = this.modelQuery.getCMElementDeclaration(element);
            if (ed != null) {
                ArrayList modelQueryActionList = new ArrayList();
                this.modelQuery.getInsertActions(element, ed, -1, 1, validityChecking, modelQueryActionList);
                this.addActionHelper((IMenuManager)addAttributeMenu, modelQueryActionList, 2);
                modelQueryActionList = new ArrayList();
                this.modelQuery.getInsertActions(element, ed, -1, includeOptions, validityChecking, modelQueryActionList);
                this.addActionHelper((IMenuManager)addChildMenu, modelQueryActionList, 2);
            }
            this.contributePIAndCommentActions((IMenuManager)addChildMenu, element, ed, -1);
            this.contributeTextNodeActions((IMenuManager)addChildMenu, element, ed, -1);
            this.contributeUnconstrainedAddElementAction((IMenuManager)addChildMenu, element, ed, -1);
            this.contributeUnconstrainedAttributeActions((IMenuManager)addAttributeMenu, element, ed);
        }
    }

    protected void contributeAddSiblingActions(IMenuManager menu, Node node, boolean visible) {
        MyMenuManager addAroundMenu = new MyMenuManager(INSERT_AROUND_MENU, visible);
        MyMenuManager addBeforeMenu = new MyMenuManager(INSERT_BEFORE_MENU, visible);
        MyMenuManager addAfterMenu = new MyMenuManager(INSERT_AFTER_MENU, visible);
        menu.add((IContributionItem)addAroundMenu);
        menu.add((IContributionItem)addBeforeMenu);
        menu.add((IContributionItem)addAfterMenu);
    }

    protected void contributeAddDocumentChildActions(IMenuManager menu, Document document) {
        MyMenuManager addChildMenu = new MyMenuManager(XMLCommonResources.getInstance().getString("_UI_MENU_ADD_CHILD"));
        menu.add((IContributionItem)addChildMenu);
        this.contributePIAndCommentActions((IMenuManager)addChildMenu, document, -1);
        this.contributeUnconstrainedAddElementAction((IMenuManager)addChildMenu, document, -1);
    }

    protected void contributeReplaceActions(IMenuManager menu, List selectedNodeList, int includeOptions, int validityChecking) {
        Element parentElement;
        CMElementDeclaration parentED;
        Node node;
        Node parentNode;
        MyMenuManager replaceWithMenu = new MyMenuManager(REPLACE_TAG_MENU);
        menu.add((IContributionItem)replaceWithMenu);
        if (this.modelQuery.getEditMode() == 2 && selectedNodeList.size() > 0 && (parentNode = (node = (Node)selectedNodeList.get(0)).getParentNode()) != null && parentNode.getNodeType() == 1 && (parentED = this.modelQuery.getCMElementDeclaration(parentElement = (Element)parentNode)) != null) {
            Vector replaceActionList = new Vector();
            this.modelQuery.getReplaceActions(parentElement, parentED, selectedNodeList, includeOptions, validityChecking, replaceActionList);
            this.addActionHelper((IMenuManager)replaceWithMenu, replaceActionList, 2);
        }
    }

    public static DocumentType getDoctype(Node node) {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        return document.getDoctype();
    }

    protected void contributeDeleteActions(IMenuManager menu, List list, int includeOptions, int validityChecking) {
        boolean canRemove = this.modelQuery.canRemove(list, validityChecking);
        List resultList = canRemove ? list : Collections.EMPTY_LIST;
        this.contributeAction(menu, this.createDeleteAction(resultList));
    }

    protected void contributePIAndCommentActions(IMenuManager menu, Element parentElement, CMElementDeclaration parentEd, int index) {
        if (parentEd == null || this.isCommentAllowed(parentEd)) {
            this.contributeAction(menu, this.createAddCommentAction(parentElement, index));
            this.contributeAction(menu, this.createAddProcessingInstructionAction(parentElement, index));
        }
    }

    protected void contributeTextNodeActions(IMenuManager menu, Element parentElement, CMElementDeclaration parentEd, int index) {
        if (parentEd == null || this.isTextAllowed(parentEd)) {
            CMDataType dataType = parentEd != null ? parentEd.getDataType() : null;
            this.contributeAction(menu, this.createAddPCDataAction(parentElement, dataType, index));
            this.contributeAction(menu, this.createAddCDataSectionAction(parentElement, index));
        }
    }

    protected void contributePIAndCommentActions(IMenuManager menu, Document document, int index) {
        this.contributeAction(menu, this.createAddCommentAction(document, index));
        this.contributeAction(menu, this.createAddProcessingInstructionAction(document, index));
    }

    protected void contributeUnconstrainedAddElementAction(IMenuManager menu, Element parentElement, CMElementDeclaration parentEd, int index) {
        if (this.isUnconstrainedActionAllowed() && (parentEd == null || parentEd.getProperty("isInferred") == Boolean.TRUE || this.modelQuery.getEditMode() != 2 && this.isElementAllowed(parentEd))) {
            this.contributeAction(menu, this.createAddElementAction(parentElement, null, index, 2));
        }
    }

    protected void contributeUnconstrainedAddElementAction(IMenuManager menu, Document document, int index) {
        if (this.isUnconstrainedActionAllowed() && this.getRootElement(document) == null) {
            int xmlDeclarationIndex = -1;
            int doctypeIndex = -1;
            NodeList nodeList = document.getChildNodes();
            int nodeListLength = nodeList.getLength();
            int i = 0;
            while (i < nodeListLength) {
                ProcessingInstruction pi;
                Node node = nodeList.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 10) {
                    doctypeIndex = i;
                    break;
                }
                if (nodeType == 7 && (pi = (ProcessingInstruction)node).getTarget().equalsIgnoreCase("xml") && xmlDeclarationIndex == -1) {
                    xmlDeclarationIndex = i;
                }
                ++i;
            }
            if (!(xmlDeclarationIndex != -1 && index <= xmlDeclarationIndex || doctypeIndex != -1 && index <= doctypeIndex)) {
                this.contributeAction(menu, this.createAddElementAction(document, null, index, 2));
            }
        }
    }

    protected void contributeUnconstrainedAttributeActions(IMenuManager menu, Element parentElement, CMElementDeclaration parentEd) {
        if (this.isUnconstrainedActionAllowed() && (parentEd == null || parentEd.getProperty("isInferred") == Boolean.TRUE || this.modelQuery.getEditMode() != 2)) {
            this.contributeAction(menu, this.createAddAttributeAction(parentElement, null));
        }
    }

    protected void addActionHelper(IMenuManager menu, List modelQueryActionList, int type) {
        Vector<Action> actionList = new Vector<Action>();
        for (ModelQueryAction action : modelQueryActionList) {
            if (action.getCMNode() == null) continue;
            int cmNodeType = action.getCMNode().getNodeType();
            if (action.getKind() == 1) {
                switch (cmNodeType) {
                    case 2: {
                        actionList.add(this.createAddAttributeAction((Element)action.getParent(), (CMAttributeDeclaration)action.getCMNode()));
                        break;
                    }
                    case 5: {
                        actionList.add(this.createAddElementAction(action.getParent(), (CMElementDeclaration)action.getCMNode(), action.getStartIndex(), type));
                    }
                }
                continue;
            }
            if (action.getKind() != 4 || action.getParent() == null || action.getCMNode() == null) continue;
            actionList.add(this.createReplaceAction(action.getParent(), action.getCMNode(), action.getStartIndex(), action.getEndIndex()));
        }
        this.menuBuilder.populateMenu(menu, actionList, false);
    }

    protected boolean isCommentAllowed(CMElementDeclaration parentEd) {
        int contentType = parentEd.getContentType();
        return contentType == 2 || contentType == 3 || contentType == 4 || contentType == 0;
    }

    protected boolean isElementAllowed(CMElementDeclaration parentEd) {
        int contentType = parentEd.getContentType();
        return contentType == 2 || contentType == 3 || contentType == 0;
    }

    protected boolean isTextAllowed(CMElementDeclaration parentEd) {
        int contentType = parentEd.getContentType();
        return contentType == 3 || contentType == 4 || contentType == 0;
    }

    protected boolean isUnconstrainedActionAllowed() {
        return true;
    }

    public int getIndex(Node parentNode, Node child) {
        NodeList nodeList = parentNode.getChildNodes();
        int index = -1;
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            if (nodeList.item(i) == child) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public Node getRefChildNodeAtIndex(Node parent, int index) {
        NodeList nodeList = parent.getChildNodes();
        Node refChild = index >= 0 && index < nodeList.getLength() ? nodeList.item(index) : null;
        return refChild;
    }

    protected boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    protected Element getRootElement(Document document) {
        Element result = null;
        NodeList nodeList = document.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                result = (Element)node;
                break;
            }
            ++i;
        }
        return result;
    }

    protected List getSelectedNodes(List list, boolean includeTextNodes) {
        ArrayList result = new ArrayList(0);
        for (Object object : list) {
            if (!(object instanceof Node)) continue;
            Node node = (Node)object;
            if (node.getNodeType() == 3) {
                if (!includeTextNodes) continue;
                result.add(object);
                continue;
            }
            result.add(node);
        }
        return result;
    }

    public static class ActionHelper
    extends ModelQueryActionHelper {
        public ActionHelper(ModelQueryImpl query) {
            super(query);
        }

        public List modifyActionList(List actionList) {
            int i = actionList.size() - 1;
            while (i >= 0) {
                CMNode nImpl = ((ModelQueryActionHelper.Action)actionList.get(i)).getCMNode();
                if (noContainerTags.contains(nImpl.getNodeName().toLowerCase())) {
                    actionList.remove(i);
                }
                --i;
            }
            return actionList;
        }
    }

    public static class MyMenuManager
    extends MenuManager {
        protected String title;
        private boolean visualForever = false;

        public MyMenuManager(String s, boolean visualForever) {
            this(s);
            this.visualForever = visualForever;
        }

        public MyMenuManager(String s) {
            super(s);
            this.title = s;
        }

        public boolean isVisible() {
            if (this.visualForever) {
                return true;
            }
            return super.isVisible();
        }

        public boolean isEnabled() {
            return !this.isEmpty();
        }

        public String toString() {
            return this.title;
        }
    }
}

