/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.SourceEditorPageContext;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.menu.InsertType;
import org.jboss.tools.vpe.editor.menu.action.ComplexAction;
import org.jboss.tools.vpe.editor.menu.action.InsertAction2;
import org.jboss.tools.vpe.editor.menu.action.SelectThisTagAction;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.w3c.dom.Node;

public class InsertContributionItem
extends ContributionItem {
    private static final String NAME_PROPERTY = "name";
    private static final String HIDDEN_PROPERTY = "hidden";
    private static final String ELEMENT_TYPE_PROPERTY = "element type";
    private static final String END_TEXT_PROPERTY = "end text";
    private static final String TAG_ELEMENT_TYPE = "macro";
    private static final String TAGLIB_ELEMENT_TYPE = "sub-group";
    private static final String LEFT_ANGLE_BRACKET = "<";
    private static final String RIGHT_ANGLE_BRACKET = ">";
    private final Node node;
    private final StructuredTextEditor sourceEditor;
    private final JSPMultiPageEditor editor;

    public InsertContributionItem() {
        this(null);
    }

    public InsertContributionItem(Node node) {
        this.node = node;
        this.editor = (JSPMultiPageEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.sourceEditor = this.editor.getSourceEditor();
    }

    public void fill(Menu menu, int index) {
        InsertType[] insertTypeArray = InsertType.values();
        int n = insertTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InsertType insertItem = insertTypeArray[n2];
            MenuManager paletteManuManager = new MenuManager(insertItem.getMessage());
            XModelObject model = ModelUtilities.getPreferenceModel().getByPath("%Palette%");
            paletteManuManager.addMenuListener((IMenuListener)new InsertMenuListener(model, insertItem));
            paletteManuManager.setRemoveAllWhenShown(true);
            paletteManuManager.fill(menu, index);
            ++index;
            ++n2;
        }
    }

    public class InsertMenuListener
    implements IMenuListener {
        private final XModelObject modelObject;
        private final InsertType insertionType;

        public InsertMenuListener(XModelObject modelObject, InsertType insertionType) {
            this.modelObject = modelObject;
            this.insertionType = insertionType;
        }

        public void menuAboutToShow(IMenuManager manager) {
            XModelObject[] modelObjectChildren = this.modelObject.getChildren();
            String prefix = null;
            if (InsertContributionItem.TAGLIB_ELEMENT_TYPE.equals(this.modelObject.getAttributeValue(InsertContributionItem.ELEMENT_TYPE_PROPERTY))) {
                prefix = this.getPrefix(this.modelObject);
            }
            SelectThisTagAction selectNodeAction = InsertContributionItem.this.node == null ? null : new SelectThisTagAction(InsertContributionItem.this.node);
            XModelObject[] xModelObjectArray = modelObjectChildren;
            int n = modelObjectChildren.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject modelObjectChild = xModelObjectArray[n2];
                if (!"yes".equals(modelObjectChild.getAttributeValue(InsertContributionItem.HIDDEN_PROPERTY))) {
                    if (InsertContributionItem.TAG_ELEMENT_TYPE.equals(modelObjectChild.getAttributeValue(InsertContributionItem.ELEMENT_TYPE_PROPERTY))) {
                        String endText = modelObjectChild.getAttributeValue(InsertContributionItem.END_TEXT_PROPERTY);
                        if (this.insertionType != InsertType.INSERT_AROUND || endText != null && endText.length() > 0) {
                            String name = InsertContributionItem.LEFT_ANGLE_BRACKET + (prefix == null || prefix.length() == 0 ? "" : String.valueOf(prefix) + ":") + modelObjectChild.getAttributeValue(InsertContributionItem.NAME_PROPERTY) + InsertContributionItem.RIGHT_ANGLE_BRACKET;
                            InsertAction2 insertAction = new InsertAction2(name, modelObjectChild, InsertContributionItem.this.sourceEditor, this.insertionType);
                            Action action = selectNodeAction == null ? insertAction : new ComplexAction(insertAction.getText(), new IAction[]{selectNodeAction, insertAction});
                            manager.add((IAction)action);
                        }
                    } else {
                        InsertSubMenuManager subMenu = new InsertSubMenuManager(modelObjectChild.getAttributeValue(InsertContributionItem.NAME_PROPERTY));
                        subMenu.setRemoveAllWhenShown(true);
                        subMenu.addMenuListener(new InsertMenuListener(modelObjectChild, this.insertionType));
                        manager.add((IContributionItem)subMenu);
                        subMenu.fill(((MenuManager)manager).getMenu(), -1);
                    }
                }
                ++n2;
            }
        }

        private String getPrefix(XModelObject modelObject) {
            IVisualContext context;
            String prefix = "";
            List taglibs = null;
            if (InsertContributionItem.this.sourceEditor instanceof JSPTextEditor && (context = ((JSPTextEditor)InsertContributionItem.this.sourceEditor).getPageContext()) instanceof SourceEditorPageContext) {
                SourceEditorPageContext sourcePageContext = (SourceEditorPageContext)context;
                taglibs = sourcePageContext.getTagLibs();
            }
            if (taglibs == null) {
                VpePlugin.getDefault().logError(VpeUIMessages.CANNOT_LOAD_TAGLIBS_FROM_PAGE_CONTEXT);
            } else {
                String uri = modelObject.getAttributeValue("library uri");
                TaglibData sourceNodeTaglib = XmlUtil.getTaglibForURI(uri, taglibs);
                prefix = sourceNodeTaglib == null ? modelObject.getAttributeValue("default prefix") : sourceNodeTaglib.getPrefix();
            }
            return prefix;
        }
    }

    public static class InsertSubMenuManager
    extends MenuManager {
        public InsertSubMenuManager(String text) {
            super(text);
        }

        public boolean isVisible() {
            return true;
        }
    }
}

