/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsContributionItem;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsUtils;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.menu.InsertContributionItem;
import org.jboss.tools.vpe.editor.menu.SetupTemplateContributionItem;
import org.jboss.tools.vpe.editor.menu.VpeMenuUtil;
import org.jboss.tools.vpe.editor.menu.ZoomActionMenuManager;
import org.jboss.tools.vpe.editor.menu.action.ComplexAction;
import org.jboss.tools.vpe.editor.menu.action.EditAttributesAction;
import org.jboss.tools.vpe.editor.menu.action.SelectThisTagAction;
import org.jboss.tools.vpe.editor.menu.action.StripTagAction;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.preferences.VpeEditorPreferencesPage;
import org.jboss.tools.vpe.editor.template.IZoomEventManager;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.xulrunner.util.DOMTreeDumper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeMenuCreator {
    private static final String VPE_PREFERENCES_MENU_URI = "popup:org.eclipse.ui.popup.any?after=additions";
    private final MenuManager menuManager;
    private final VpeMenuUtil vpeMenuUtil;
    private final Node node;

    public VpeMenuCreator(MenuManager menuManager, Node node) {
        this.node = node;
        this.menuManager = menuManager;
        this.vpeMenuUtil = new VpeMenuUtil();
    }

    public void createMenu() {
        this.createMenu(true);
    }

    private void createMenu(boolean topLevelMenu) {
        Node parent;
        this.addCutCopyPasteActions(topLevelMenu);
        this.addSeparator();
        this.addIfEnabled((IAction)new EditAttributesAction(this.node));
        this.menuManager.add((IContributionItem)new SetupTemplateContributionItem());
        if (!topLevelMenu) {
            this.menuManager.add((IAction)new SelectThisTagAction(this.node));
        }
        Node node = parent = this.node == null ? null : this.node.getParentNode();
        if (parent != null && parent.getNodeType() == 1) {
            this.addParentTagMenuItem((Element)parent);
        }
        this.addSeparator();
        this.menuManager.add((IContributionItem)new InsertContributionItem(this.node));
        this.addIfEnabled((IAction)new StripTagAction(this.node));
        if (ExternalizeStringsUtils.isSelectionCorrect((ISelection)this.vpeMenuUtil.getSelection())) {
            this.menuManager.add((IContributionItem)new ExternalizeStringsContributionItem());
        }
        this.addSeparator();
        if (topLevelMenu) {
            this.addZoomActions();
            this.addSeparator();
        }
        this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)new Action(){

            public void run() {
                VpeEditorPreferencesPage.openPreferenceDialog();
            }

            public String getText() {
                return VpeUIMessages.VPE_PREFERENCES_MENU_LABEL;
            }
        }));
        this.addSeparator();
        if (topLevelMenu) {
            this.addIfEnabled((IAction)new DumpSourceAction());
            this.addIfEnabled((IAction)new DumpSelectedElementAction());
            this.addIfEnabled((IAction)new DumpStyleAction());
            this.addIfEnabled((IAction)new DumpMappingAction());
            this.addIfEnabled((IAction)new TestAction());
        }
        this.addSeparator();
        this.addVpePreferences();
    }

    private void addVpePreferences() {
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.menuManager, VPE_PREFERENCES_MENU_URI);
    }

    private void addCutCopyPasteActions(boolean topLevelMenu) {
        IAction cutAction = this.getSourceEditorAction(ActionFactory.CUT);
        IAction copyAction = this.getSourceEditorAction(ActionFactory.COPY);
        IAction pasteAction = this.getSourceEditorAction(ActionFactory.PASTE);
        if (topLevelMenu) {
            if (this.node != null) {
                this.menuManager.add(cutAction);
                this.menuManager.add(copyAction);
            }
            this.menuManager.add(pasteAction);
        } else {
            SelectThisTagAction selectAction = new SelectThisTagAction(this.node);
            if (selectAction.isEnabled()) {
                this.menuManager.add((IAction)new ComplexAction(cutAction.getText(), new IAction[]{selectAction, cutAction}));
                this.menuManager.add((IAction)new ComplexAction(copyAction.getText(), new IAction[]{selectAction, copyAction}));
                this.menuManager.add((IAction)new ComplexAction(pasteAction.getText(), new IAction[]{selectAction, pasteAction}));
            }
        }
    }

    private void addIfEnabled(IAction action) {
        if (action.isEnabled()) {
            this.menuManager.add(action);
        }
    }

    private void addParentTagMenuItem(final Element parent) {
        String itemName = MessageFormat.format(VpeUIMessages.PARENT_TAG_MENU_ITEM, parent.getNodeName());
        final MenuManager parentMenuManager = new MenuManager(itemName);
        parentMenuManager.setParent((IContributionManager)this.menuManager);
        parentMenuManager.setRemoveAllWhenShown(true);
        parentMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                new VpeMenuCreator(parentMenuManager, parent).createMenu(false);
            }
        });
        this.menuManager.add((IContributionItem)parentMenuManager);
    }

    private void addSeparator() {
        IContributionItem lastItem;
        int size = this.menuManager.getSize();
        if (size > 0 && !(lastItem = this.menuManager.getItems()[size - 1]).isSeparator()) {
            this.menuManager.add((IContributionItem)new Separator());
        }
    }

    private IAction getSourceEditorAction(ActionFactory actionFactory) {
        StructuredTextEditor sourceEditor = this.vpeMenuUtil.getSourceEditor();
        IAction action = sourceEditor.getAction(actionFactory.getId());
        return action;
    }

    private void addZoomActions() {
        IZoomEventManager zoomEventManager = ((VpeEditorPart)this.vpeMenuUtil.getEditor().getVisualEditor()).getController().getZoomEventManager();
        ZoomActionMenuManager manager = new ZoomActionMenuManager(zoomEventManager);
        this.menuManager.add((IContributionItem)manager);
    }

    public class DumpMappingAction
    extends Action {
        public DumpMappingAction() {
            this.setText("Dump Mapping");
        }

        public void run() {
            VpeDomMapping domMapping = VpeMenuCreator.this.vpeMenuUtil.getDomMapping();
            domMapping.printMapping();
        }

        public boolean isEnabled() {
            return VpeDebug.VISUAL_CONTEXTMENU_DUMP_MAPPING;
        }
    }

    public class DumpSelectedElementAction
    extends Action {
        public DumpSelectedElementAction() {
            this.setText("Dump Selected Element");
        }

        public void run() {
            VpeDomMapping domMapping;
            StructuredTextEditor sourceEditor = VpeMenuCreator.this.vpeMenuUtil.getSourceEditor();
            VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(sourceEditor, domMapping = VpeMenuCreator.this.vpeMenuUtil.getDomMapping());
            if (nodeMapping != null) {
                DOMTreeDumper dumper = new DOMTreeDumper(VpeDebug.VISUAL_DUMP_PRINT_HASH);
                dumper.setIgnoredAttributes(VpeDebug.VISUAL_DUMP_IGNORED_ATTRIBUTES);
                dumper.dumpNode(nodeMapping.getVisualNode());
            }
        }

        public boolean isEnabled() {
            return VpeDebug.VISUAL_CONTEXTMENU_DUMP_SELECTED_ELEMENT;
        }
    }

    public class DumpSourceAction
    extends Action {
        public DumpSourceAction() {
            this.setText("Dump Source");
        }

        public void run() {
            MozillaEditor visualEditor = VpeMenuCreator.this.vpeMenuUtil.getMozillaEditor();
            DOMTreeDumper dumper = new DOMTreeDumper(VpeDebug.VISUAL_DUMP_PRINT_HASH);
            dumper.setIgnoredAttributes(VpeDebug.VISUAL_DUMP_IGNORED_ATTRIBUTES);
            dumper.dumpToStream(System.out, visualEditor.getDomDocument());
        }

        public boolean isEnabled() {
            return VpeDebug.VISUAL_CONTEXTMENU_DUMP_SOURCE;
        }
    }

    public class DumpStyleAction
    extends Action {
        public DumpStyleAction() {
            this.setText("Dump CSS Style");
        }

        public void run() {
            VpeDomMapping domMapping;
            StructuredTextEditor sourceEditor = VpeMenuCreator.this.vpeMenuUtil.getSourceEditor();
            VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(sourceEditor, domMapping = VpeMenuCreator.this.vpeMenuUtil.getDomMapping());
            if (nodeMapping != null) {
                DOMTreeDumper dumper = new DOMTreeDumper(VpeDebug.VISUAL_DUMP_PRINT_HASH);
                dumper.setIgnoredAttributes(VpeDebug.VISUAL_DUMP_IGNORED_ATTRIBUTES);
                dumper.dumpStyle(nodeMapping.getVisualNode());
            }
        }

        public boolean isEnabled() {
            return VpeDebug.VISUAL_CONTEXTMENU_DUMP_CSS_STYLE;
        }
    }

    public static class TestAction
    extends Action {
        public TestAction() {
            this.setText("Test Action");
        }

        public void run() {
        }

        public boolean isEnabled() {
            return VpeDebug.VISUAL_CONTEXTMENU_TEST;
        }
    }
}

