/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu.action;

import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.menu.InsertType;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InsertAction2
extends Action {
    private final XModelObject item;
    private final StructuredTextEditor sourceEditor;
    private final InsertType insertType;

    public InsertAction2(String title, XModelObject item, StructuredTextEditor sourceEditor, InsertType insertType) {
        super(title);
        this.item = item;
        this.sourceEditor = sourceEditor;
        this.insertType = insertType;
    }

    public void run() {
        Point userSelection = SelectionUtil.getSourceSelectionRange(this.sourceEditor);
        this.getSourceEditor().getTextViewer().getTextWidget().setSelection(userSelection.x);
        IUndoManager undoManager = this.sourceEditor.getTextViewer().getUndoManager();
        try {
            undoManager.beginCompoundChange();
            this.prepareInsertion(userSelection);
            this.doInsertion();
        }
        finally {
            undoManager.endCompoundChange();
        }
    }

    private void prepareInsertion(Point userSelection) {
        int insertionLength;
        int insertionStart;
        int start = userSelection.x;
        int length = userSelection.y;
        Node firstNode = SelectionUtil.getNodeBySourcePosition(this.sourceEditor, userSelection.x);
        Node endNode = SelectionUtil.getNodeBySourcePosition(this.sourceEditor, userSelection.x + userSelection.y);
        if (firstNode != null) {
            start = firstNode.getNodeType() == 3 ? userSelection.x : NodesManagingUtil.getStartOffsetNode((Node)firstNode);
        }
        if (endNode != null) {
            length = endNode.getNodeType() == 3 ? userSelection.x - start + userSelection.y : NodesManagingUtil.getEndOffsetNode((Node)endNode) - start;
        }
        switch (this.insertType) {
            case INSERT_BEFORE: {
                insertionStart = start;
                insertionLength = 0;
                break;
            }
            case INSERT_AFTER: {
                insertionStart = start + length;
                insertionLength = 0;
                break;
            }
            case INSERT_INTO: {
                if (firstNode != null && firstNode.getNodeType() == 1) {
                    Element firstElement = (Element)firstNode;
                    Node prevNode = firstElement.getOwnerDocument().createTextNode("");
                    try {
                        firstElement.appendChild(prevNode);
                    }
                    catch (DOMException e) {
                        prevNode = firstNode;
                    }
                    insertionStart = NodesManagingUtil.getEndOffsetNode((Node)prevNode);
                } else {
                    insertionStart = start + length;
                }
                insertionLength = 0;
                break;
            }
            default: {
                insertionStart = start;
                insertionLength = length;
            }
        }
        if (this.insertType == InsertType.REPLACE_WITH) {
            this.sourceEditor.getTextViewer().getTextWidget().replaceTextRange(insertionStart, insertionLength, "");
        } else {
            this.sourceEditor.getTextViewer().getTextWidget().setSelection(insertionStart, insertionStart + insertionLength);
        }
    }

    private void doInsertion() {
        String tagName = this.item.getAttributeValue("name");
        XModelObject parent = this.item.getParent();
        String uri = parent == null ? "" : parent.getAttributeValue("library uri");
        String libraryVersion = parent == null ? "" : parent.getAttributeValue("library version");
        String defaultPrefix = parent == null ? "" : parent.getAttributeValue("default prefix");
        String startText = this.item.getAttributeValue("start text");
        String endText = this.item.getAttributeValue("end text");
        ISelectionProvider selectionProvider = this.sourceEditor.getSelectionProvider();
        Properties p = new Properties();
        p.setProperty("tag name", tagName);
        p.setProperty("start text", startText);
        p.setProperty("end text", endText);
        p.setProperty("automatically reformat tag body", this.item.getAttributeValue("automatically reformat tag body"));
        p.setProperty("library uri", uri);
        p.setProperty("library version", libraryVersion);
        String addTaglib = this.item.getParent().getAttributeValue("add taglib");
        p.setProperty("default prefix", defaultPrefix);
        p.setProperty("add taglib", addTaglib);
        p.put("selectionProvider", selectionProvider);
        JSPPaletteInsertHelper.getInstance().insertIntoEditor((ISourceViewer)this.sourceEditor.getTextViewer(), p);
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }
}

