/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeAttributeCreator
extends VpeAbstractCreator {
    private String name;
    private VpeExpression expression;

    VpeAttributeCreator(String name, String value, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.build(name, value, dependencyMap, caseSensitive);
    }

    private void build(String name, String value, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.name = name;
        try {
            VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(value, caseSensitive);
            this.expression = info.getExpression();
            if (dependencyMap != null) {
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
        }
        catch (VpeExpressionBuilderException e) {
            VpePlugin.reportProblem(e);
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        if (this.expression != null) {
            VpeValue vpeValue;
            if (visualNodeMap != null) {
                visualNodeMap.put(this, visualElement);
            }
            if ((vpeValue = this.expression.exec(pageContext, sourceNode)) != null && vpeValue.stringValue().length() > 0) {
                nsIDOMAttr newVisualAttribute = visualDocument.createAttribute(this.name);
                newVisualAttribute.setValue(vpeValue.stringValue());
                return new VpeCreatorInfo((nsIDOMNode)newVisualAttribute);
            }
        }
        return null;
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        this.setValue(pageContext, sourceElement, visualNodeMap);
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
        this.setValue(pageContext, sourceElement, visualNodeMap);
    }

    private void setValue(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        try {
            if (this.expression != null) {
                nsIDOMElement visualElement = (nsIDOMElement)visualNodeMap.get(this);
                VpeValue vpeValue = this.expression.exec(pageContext, sourceElement);
                if (vpeValue != null && vpeValue.stringValue().length() > 0) {
                    visualElement.setAttribute(this.name, vpeValue.stringValue());
                } else {
                    visualElement.removeAttribute(this.name);
                }
            }
        }
        catch (VpeExpressionException ex) {
            VpeExpressionException exception = new VpeExpressionException(String.valueOf(sourceElement.toString()) + " " + this.expression.toString(), ex);
            VpePlugin.reportProblem(exception);
        }
    }
}

