/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.jst.web.ui.internal.editor.preferences.VpePreference;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeOutputComment;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeCommentCreator
extends VpeAbstractCreator
implements VpeOutputComment {
    public static final String SIGNATURE_VPE_COMMENT = ":vpe:comment";
    private static final String COMMENT_STYLE = "font-style:italic; color:green";
    private static final String COMMENT_PREFIX = "";
    private static final String COMMENT_SUFFIX = "";

    VpeCommentCreator(Element element, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        dependencyMap.setCreator((VpeCreator)this, SIGNATURE_VPE_COMMENT);
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        if (!"yes".equals(VpePreference.SHOW_COMMENTS.getValue())) {
            return null;
        }
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("style", COMMENT_STYLE);
        String value = sourceNode.getNodeValue();
        nsIDOMText text = visualDocument.createTextNode(value);
        div.appendChild((nsIDOMNode)text);
        visualNodeMap.put(this, div);
        return new VpeCreatorInfo((nsIDOMNode)div);
    }

    @Override
    public void setOutputCommentValue(VpePageContext pageContext, Comment sourceComment, Map visualNodeMap) {
        nsIDOMNodeList children;
        String commentValue = "";
        nsIDOMElement div = (nsIDOMElement)visualNodeMap.get(this);
        if (div != null && (children = div.getChildNodes()) != null) {
            long len = children.getLength();
            long i = 0L;
            while (i < len) {
                String value;
                nsIDOMNode text = children.item(i);
                if (text.getNodeType() == 3 && (value = text.getNodeValue()).length() > 0) {
                    commentValue = value;
                    break;
                }
                ++i;
            }
        }
        sourceComment.setNodeValue(commentValue);
    }
}

