/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTextCreator;
import org.jboss.tools.vpe.editor.template.VpeValueCreator;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeHtmlCreator
extends VpeAbstractCreator {
    private String name;
    private VpeCreator[] attrs;
    private VpeCreator[] nodes;

    VpeHtmlCreator(Element htmlElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.build(htmlElement, dependencyMap, caseSensitive);
    }

    private void build(Element htmlElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        int len;
        NodeList htmlChildren;
        int len2;
        this.name = htmlElement.getNodeName();
        NamedNodeMap templAttrs = htmlElement.getAttributes();
        if (templAttrs != null && (len2 = templAttrs.getLength()) > 0) {
            ArrayList<VpeAttributeCreator> creatorAttrs = new ArrayList<VpeAttributeCreator>(len2);
            int i = 0;
            while (i < len2) {
                Attr templAttr = (Attr)templAttrs.item(i);
                creatorAttrs.add(new VpeAttributeCreator(templAttr.getName(), templAttr.getValue(), dependencyMap, caseSensitive));
                ++i;
            }
            this.attrs = creatorAttrs.toArray(new VpeCreator[len2]);
        }
        if ((htmlChildren = htmlElement.getChildNodes()) != null && (len = htmlChildren.getLength()) > 0) {
            ArrayList<VpeAbstractCreator> creatorNodes = new ArrayList<VpeAbstractCreator>(len);
            int i = 0;
            while (i < len) {
                Node innerNode = htmlChildren.item(i);
                switch (innerNode.getNodeType()) {
                    case 1: {
                        String innerName = innerNode.getNodeName();
                        if (innerName.startsWith("vpe:")) {
                            if (!"vpe:value".equals(innerName)) break;
                            String valueVal = ((Element)innerNode).getAttribute("expr");
                            creatorNodes.add(new VpeValueCreator(valueVal, dependencyMap, caseSensitive));
                            break;
                        }
                        creatorNodes.add(new VpeHtmlCreator((Element)innerNode, dependencyMap, caseSensitive));
                        break;
                    }
                    case 3: {
                        if (innerNode.getNodeValue().trim().length() <= 0) break;
                        creatorNodes.add(new VpeTextCreator(innerNode, dependencyMap, caseSensitive));
                    }
                }
                ++i;
            }
            this.nodes = creatorNodes.toArray(new VpeCreator[creatorNodes.size()]);
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        int i;
        nsIDOMElement visualNewElement = visualDocument.createElement(this.name);
        if (this.attrs != null) {
            i = 0;
            while (i < this.attrs.length) {
                nsIDOMAttr newVisualAttribute;
                VpeCreatorInfo attributeInfo = this.attrs[i].create(pageContext, (Element)sourceNode, visualDocument, visualNewElement, visualNodeMap);
                if (attributeInfo != null && (newVisualAttribute = (nsIDOMAttr)attributeInfo.getVisualNode()) != null) {
                    visualNewElement.setAttributeNode(newVisualAttribute);
                }
                ++i;
            }
        }
        if (this.nodes != null) {
            i = 0;
            while (i < this.nodes.length) {
                nsIDOMNode newVisualNode;
                VpeCreatorInfo nodeInfo = this.nodes[i].create(pageContext, sourceNode, visualDocument, visualNewElement, visualNodeMap);
                if (nodeInfo != null && (newVisualNode = nodeInfo.getVisualNode()) != null) {
                    visualNewElement.appendChild(newVisualNode);
                }
                ++i;
            }
        }
        return new VpeCreatorInfo((nsIDOMNode)visualNewElement);
    }
}

