/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpePanelLayoutCreator
extends VpeAbstractCreator {
    public static final String ATTR_LAYOUT_DEFAULT_VALUE = "classic";
    public static final String EMPTY_ATTR_VALUE = "";
    public static final String CSS_CLASS_HEADER_DEFAULT = "pageHeader";
    public static final String CSS_CLASS_NAVIGATOR_DEFAULT = "pageNavigation";
    public static final String CSS_CLASS_BODY_DEFAULT = "pageBody";
    public static final String CSS_CLASS_FOOTER_DEFAULT = "pageFooter";
    public static final String ATTR_PL_LAYOUT = "layout";
    public static final String ATTR_PL_CLASS = "class";
    public static final String ATTR_PL_STYLE = "style";
    public static final String LAYOUT_CLASSIC_ATTR_VALUE = "classic";
    public static final String LAYOUT_NAVIGATION_RIGHT_ATTR_VALUE = "navigationRight";
    public static final String LAYOUT_UPSIDEDOWN_VALUE = "upsideDown";
    public static final String ATTR_PL_BODY_CLASS = "bodyClass";
    public static final String ATTR_PL_BODY_STYLE = "bodyStyle";
    public static final String[][] MAP_ATTR_TO_BODY = new String[][]{{"class", "bodyClass", "pageBody"}, {"style", "bodyStyle", ""}};
    public static final String ATTR_PL_FOOTER_CLASS = "footerClass";
    public static final String ATTR_PL_FOOTER_STYLE = "footerStyle";
    public static final String[][] MAP_ATTR_TO_FOOTER = new String[][]{{"class", "footerClass", "pageFooter"}, {"style", "footerStyle", ""}};
    public static final String ATTR_PL_HEADER_CLASS = "headerClass";
    public static final String ATTR_PL_HEADER_STYLE = "headerStyle";
    public static final String[][] MAP_ATTR_TO_HEADER = new String[][]{{"class", "headerClass", "pageHeader"}, {"style", "headerStyle", ""}};
    public static final String ATTR_PL_NAVIGATION_CLASS = "navigationClass";
    public static final String ATTR_PL_NAVIOGATION = "navigationStyle";
    public static final String[][] MAP_ATTR_TO_NAVIGATION = new String[][]{{"class", "navigationClass", "pageNavigation"}, {"style", "navigationStyle", ""}};
    public static final String ATTR_PL_ID = "id";
    public static final String ATTR_PL_DIR = "dir";
    public static final String ATTR_PL_LANG = "lang";
    public static final String ATTR_PL_WIDTH = "width";
    public static final String ATTR_PL_STYLECLASS = "styleClass";
    public static final String ATTR_PL_ALLIGN = "align";
    public static final String ATTR_PL_BGCOLOR = "bgcolor";
    public static final String ATTR_PL_BORDER = "border";
    public static final String ATTR_PL_CELLPADDING = "cellpadding";
    public static final String ATTR_PL_CELLSPACING = "cellspacing";
    public static final String[][] MAP_ATTR_TO_TABLE = new String[][]{{"id", "id", ""}, {"dir", "dir", ""}, {"lang", "lang", ""}, {"width", "width", ""}, {"style", "style", ""}, {"styleClass", "styleClass", ""}, {"align", "align", ""}, {"bgcolor", "bgcolor", ""}, {"border", "border", ""}, {"cellpadding", "cellpadding", ""}, {"cellspacing", "cellspacing", ""}};
    public static final String ATTR_PL_ONCLICK = "onclick";
    public static final String ATTR_PL_ONDBCLICK = "ondblclick";
    public static final String ATTR_PL_ONKEYDOWN = "onkeydown";
    public static final String ATTR_PL_ONKEYPRESS = "onkeypress";
    public static final String ATTR_PL_ONKEYUP = "onkeyup";
    public static final String ATTR_PL_ONMOUSEDOWN = "onmousedown";
    public static final String ATTR_PL_ONMOUSEMOVE = "onmousemove";
    public static final String ATTR_PL_ONMOUSEOUT = "onmouseout";
    public static final String ATTR_PL_ONMOUSEOVER = "onmouseover";
    public static final String ATTR_PL_ONMOUSEUP = "onmouseup";
    public static final String ATTR_PL_RENDERED = "rendered";
    public static final String ATTR_PL_FRAME = "frame";
    public static final String ATTR_PL_RULES = "rules";
    public static final String ATTR_PL_SUMMARY = "summary";
    public static final String ATTR_PL_TITLE = "title";
    public static final String ATTR_PL_DATAFLD = "datafld";
    public static final String ATTR_PL_DATAFORMATS = "dataformatas";
    public static final String ATTR_PL_DATASCR = "datasrc";
    public static final String EMPTY_ATTR = null;
    private boolean caseSensitive;

    VpePanelLayoutCreator(Element panelLayout, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(panelLayout, dependencyMap);
    }

    @Override
    public boolean isRecreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        Map visualNodeMap = (Map)data;
        if (name.equals(ATTR_PL_LAYOUT)) {
            String layoutName = (String)visualNodeMap.get(ATTR_PL_LAYOUT);
            if (!value.equals(LAYOUT_NAVIGATION_RIGHT_ATTR_VALUE) && !value.equals(LAYOUT_UPSIDEDOWN_VALUE)) {
                value = "classic";
            }
            return !layoutName.equals(value);
        }
        return false;
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        VpePanelLayoutElements layoutElements = new VpePanelLayoutElements(sourceNode, pageContext);
        visualNodeMap.put(ATTR_PL_LAYOUT, layoutElements.getLayoutName());
        PanelLayoutTable layout = new PanelLayoutTable(visualDocument, sourceNode);
        visualNodeMap.put(this, layout);
        if (LAYOUT_NAVIGATION_RIGHT_ATTR_VALUE.equals(layoutElements.getLayoutName())) {
            layout.setTop(layoutElements.getHeaderFacet(), MAP_ATTR_TO_HEADER);
            layout.setRight(layoutElements.getNavigationFacet(), MAP_ATTR_TO_NAVIGATION);
            layout.setLeft(layoutElements.getBodyFacet(), MAP_ATTR_TO_BODY);
            layout.setBottom(layoutElements.getFooterFacet(), MAP_ATTR_TO_FOOTER);
        } else if (LAYOUT_UPSIDEDOWN_VALUE.equals(layoutElements.getLayoutName())) {
            layout.setBottom(layoutElements.getHeaderFacet(), MAP_ATTR_TO_HEADER);
            layout.setLeft(layoutElements.getNavigationFacet(), MAP_ATTR_TO_NAVIGATION);
            layout.setRight(layoutElements.getBodyFacet(), MAP_ATTR_TO_BODY);
            layout.setTop(layoutElements.getFooterFacet(), MAP_ATTR_TO_FOOTER);
        } else {
            layout.setTop(layoutElements.getHeaderFacet(), MAP_ATTR_TO_HEADER);
            layout.setLeft(layoutElements.getNavigationFacet(), MAP_ATTR_TO_NAVIGATION);
            layout.setRight(layoutElements.getBodyFacet(), MAP_ATTR_TO_BODY);
            layout.setBottom(layoutElements.getFooterFacet(), MAP_ATTR_TO_FOOTER);
        }
        return layout.getVpeCreatorInfo();
    }

    private void build(Element element, VpeDependencyMap dependencyMap) {
        HashSet<String> attrs = new HashSet<String>();
        int i = 0;
        while (i < MAP_ATTR_TO_TABLE.length) {
            attrs.add(VpeExpressionBuilder.attrSignature(MAP_ATTR_TO_TABLE[i][0], this.caseSensitive));
            ++i;
        }
        dependencyMap.setCreator((VpeCreator)this, attrs);
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        PanelLayoutTable layout = (PanelLayoutTable)visualNodeMap.get(this);
        VpePanelLayoutElements layoutElements = new VpePanelLayoutElements(sourceElement, pageContext);
        layout.update(sourceElement, MAP_ATTR_TO_TABLE);
        if (LAYOUT_NAVIGATION_RIGHT_ATTR_VALUE.equals(layoutElements.getLayoutName())) {
            layout.updateTop(layoutElements.getHeaderFacet(), MAP_ATTR_TO_HEADER);
            layout.updateLeft(layoutElements.getNavigationFacet(), MAP_ATTR_TO_NAVIGATION);
            layout.updateRight(layoutElements.getBodyFacet(), MAP_ATTR_TO_BODY);
            layout.updateBottom(layoutElements.getFooterFacet(), MAP_ATTR_TO_FOOTER);
        } else if (LAYOUT_UPSIDEDOWN_VALUE.equals(layoutElements.getLayoutName())) {
            layout.updateBottom(layoutElements.getHeaderFacet(), MAP_ATTR_TO_HEADER);
            layout.updateLeft(layoutElements.getNavigationFacet(), MAP_ATTR_TO_NAVIGATION);
            layout.updateRight(layoutElements.getBodyFacet(), MAP_ATTR_TO_BODY);
            layout.updateTop(layoutElements.getFooterFacet(), MAP_ATTR_TO_FOOTER);
        } else {
            layout.updateTop(layoutElements.getHeaderFacet(), MAP_ATTR_TO_HEADER);
            layout.updateLeft(layoutElements.getNavigationFacet(), MAP_ATTR_TO_NAVIGATION);
            layout.updateRight(layoutElements.getBodyFacet(), MAP_ATTR_TO_BODY);
            layout.updateBottom(layoutElements.getFooterFacet(), MAP_ATTR_TO_FOOTER);
        }
    }

    @Override
    public void validate(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualParent, nsIDOMElement visualElement, Map visualNodeMap) {
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
    }

    public class DefaultNodeWrapper
    implements ElementWrapper {
        protected nsIDOMElement element;

        public DefaultNodeWrapper(nsIDOMElement element) {
            this.element = element;
        }

        @Override
        public nsIDOMElement getDomElement() {
            return this.element;
        }

        @Override
        public nsIDOMDocument getOwnerDocument() {
            return this.element.getOwnerDocument();
        }

        @Override
        public void setAttributeValue(String name, String value) {
            this.getDomElement().setAttribute(name, value);
        }
    }

    public static interface ElementWrapper {
        public nsIDOMElement getDomElement();

        public nsIDOMDocument getOwnerDocument();

        public void setAttributeValue(String var1, String var2);
    }

    public class PanelLayoutTable {
        public static final String TABLE = "table";
        public static final String TR = "tr";
        public static final String TD = "td";
        public static final String CLASS_ATTR = "class";
        public static final String STYLE_ATTR = "style";
        Table table;
        Td top;
        Td bottom;
        Td left;
        Td right;
        VpeChildrenInfo topInfo;
        VpeChildrenInfo bottomInfo;
        VpeChildrenInfo rightInfo;
        VpeChildrenInfo leftInfo;
        VpeCreatorInfo creatorInfo;

        public PanelLayoutTable(nsIDOMDocument visualDocument, Node source) {
            this.table = new Table(visualDocument, source);
            this.creatorInfo = new VpeCreatorInfo((nsIDOMNode)this.table.getDomElement());
            Tr tr = this.table.crateRow();
            this.top = tr.createCell(2);
            tr = this.table.crateRow();
            this.left = tr.createCell();
            this.right = tr.createCell();
            tr = this.table.crateRow();
            this.bottom = tr.createCell(2);
        }

        public void setTop(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            this.topInfo = new VpeChildrenInfo(this.top.getDomElement());
            this.addVpeCreatorInfoChild(this.topInfo, this.top, node, styleMap);
        }

        public void setBottom(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            this.bottomInfo = new VpeChildrenInfo(this.bottom.getDomElement());
            this.addVpeCreatorInfoChild(this.bottomInfo, this.bottom, node, styleMap);
        }

        public void setLeft(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            this.leftInfo = new VpeChildrenInfo(this.left.getDomElement());
            this.addVpeCreatorInfoChild(this.leftInfo, this.left, node, styleMap);
        }

        public void setRight(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            this.rightInfo = new VpeChildrenInfo(this.right.getDomElement());
            this.addVpeCreatorInfoChild(this.rightInfo, this.right, node, styleMap);
        }

        public void updateTop(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            VpePanelLayoutElements.mapAttributes(this.top.getDomElement(), node, styleMap);
        }

        public void updateBottom(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            VpePanelLayoutElements.mapAttributes(this.bottom.getDomElement(), node, styleMap);
        }

        public void updateLeft(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            VpePanelLayoutElements.mapAttributes(this.left.getDomElement(), node, styleMap);
        }

        public void updateRight(Node node, String[][] styleMap) {
            if (node == null) {
                return;
            }
            VpePanelLayoutElements.mapAttributes(this.right.getDomElement(), node, styleMap);
        }

        public void update(Node node, String[][] styleMap) {
            VpePanelLayoutElements.mapAttributes(this.table.getDomElement(), node, styleMap);
        }

        public VpeCreatorInfo getVpeCreatorInfo() {
            return this.creatorInfo;
        }

        private void addVpeCreatorInfoChild(VpeChildrenInfo info, Td td, Node source, String[][] styleMap) {
            info.addSourceChild(source);
            VpePanelLayoutElements.mapAttributes(td.getDomElement(), source, styleMap);
            this.creatorInfo.addChildrenInfo(info);
        }
    }

    public class Table
    extends DefaultNodeWrapper {
        public Table(nsIDOMDocument visualDocument, Node source) {
            super(visualDocument.createElement("table"));
            VpePanelLayoutElements.mapAttributes(this.getDomElement(), source, MAP_ATTR_TO_TABLE);
        }

        public Tr crateRow() {
            nsIDOMElement tr = this.getOwnerDocument().createElement("tr");
            this.getDomElement().appendChild((nsIDOMNode)tr);
            return new Tr(tr);
        }
    }

    public class Td
    extends DefaultNodeWrapper {
        public Td(nsIDOMElement cellNode) {
            super(cellNode);
        }
    }

    public class Tr
    extends DefaultNodeWrapper {
        public Tr(nsIDOMElement rowNode) {
            super(rowNode);
        }

        public Td createCell() {
            nsIDOMElement tr = this.getOwnerDocument().createElement("td");
            this.getDomElement().appendChild((nsIDOMNode)tr);
            return new Td(tr);
        }

        public Td createCell(int colspanNumber) {
            Td td = this.createCell();
            td.setAttributeValue("colspan", VpePanelLayoutCreator.EMPTY_ATTR_VALUE + colspanNumber);
            return td;
        }
    }

    public static class VpePanelLayoutElements {
        Node layout = null;
        Node header = null;
        Node footer = null;
        Node navigation = null;
        Node body = null;
        VpePageContext pageContext = null;
        public static int DEST = 0;
        public static int SOURCE = 1;
        public static int DEFAULT = 2;

        public VpePanelLayoutElements(Node source, VpePageContext context) {
            this.pageContext = context;
            this.init(source);
            this.layout = source;
        }

        public Node getLayoutNode() {
            return this.layout;
        }

        public String getLayoutName() {
            String name = VpePanelLayoutElements.getAttributeValue(this.layout, VpePanelLayoutCreator.ATTR_PL_LAYOUT, "classic");
            if (name.equals(VpePanelLayoutCreator.LAYOUT_NAVIGATION_RIGHT_ATTR_VALUE) || name.equals(VpePanelLayoutCreator.LAYOUT_UPSIDEDOWN_VALUE)) {
                return name;
            }
            return "classic";
        }

        private void init(Node source) {
            this.init(source, null);
        }

        private void init(Node source, Node include) {
            int cnt;
            NodeList list = source.getChildNodes();
            int n = cnt = list != null ? list.getLength() : 0;
            if (cnt > 0) {
                int i = 0;
                while (i < cnt) {
                    block26: {
                        Node node = list.item(i);
                        if (node.getNodeType() == 1) {
                            boolean isFacet = node.getNodeName().indexOf(":facet") > 0;
                            boolean isInclude = node.getNodeName().indexOf("jsp:include") >= 0 || node.getNodeName().indexOf("jsp:directive.include") >= 0;
                            Node attrName = node.getAttributes().getNamedItem("name");
                            if (isFacet && attrName != null) {
                                String nodeValue = attrName.getNodeValue();
                                if ("header".equals(nodeValue)) {
                                    this.header = include != null ? include : node;
                                } else if ("navigation".equals(nodeValue)) {
                                    this.navigation = include != null ? include : node;
                                } else if ("body".equals(nodeValue)) {
                                    this.body = include != null ? include : node;
                                } else if ("footer".equals(nodeValue)) {
                                    this.footer = include != null ? include : node;
                                }
                            } else if (isInclude) {
                                IDOMModel wtpModel = null;
                                Attr page = ((Element)node).getAttributeNode("page");
                                if (page == null) {
                                    page = ((Element)node).getAttributeNode("file");
                                }
                                if (page != null) {
                                    String pageName = page.getNodeValue();
                                    IEditorInput input = this.pageContext.getEditPart().getEditorInput();
                                    IFile resource = FileUtil.getFile(input, pageName);
                                    if (resource != null && resource.exists()) {
                                        try {
                                            wtpModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(resource);
                                            if (wtpModel != null) {
                                                this.init((Node)wtpModel.getDocument(), node);
                                            }
                                        }
                                        catch (IOException ex) {
                                            VpePlugin.reportProblem(ex);
                                            if (wtpModel != null) {
                                                wtpModel.releaseFromRead();
                                            }
                                            break block26;
                                        }
                                        catch (CoreException ex) {
                                            try {
                                                VpePlugin.reportProblem((Exception)((Object)ex));
                                                break block26;
                                            }
                                            catch (Throwable throwable) {
                                                throw throwable;
                                            }
                                            finally {
                                                if (wtpModel != null) {
                                                    wtpModel.releaseFromRead();
                                                }
                                            }
                                        }
                                        if (wtpModel == null) break block26;
                                        wtpModel.releaseFromRead();
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        public Node getHeaderFacet() {
            return this.header;
        }

        public Node getFooterFacet() {
            return this.footer;
        }

        public Node getNavigationFacet() {
            return this.navigation;
        }

        public Node getBodyFacet() {
            return this.body;
        }

        public String getPanelLayoutAttribute(String nodeName, String defaultValue) {
            return VpePanelLayoutElements.getAttributeValue(this.layout, nodeName, defaultValue);
        }

        static String getAttributeValue(Node node, String attributeName, String defaultValue) {
            NamedNodeMap attrs = node.getAttributes();
            Node attr = attrs.getNamedItem(attributeName);
            if (attr != null) {
                return attr.getNodeValue();
            }
            return defaultValue;
        }

        static void mapAttributes(nsIDOMElement dest, Node source, String[][] map) {
            int i = 0;
            while (i < map.length) {
                dest.setAttribute(map[i][DEST], VpePanelLayoutElements.getAttributeValue(source, map[i][SOURCE], map[i][DEFAULT]));
                ++i;
            }
        }
    }
}

