/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.vpe.editor.template.VpeTemplateFileList;

public class VpeTemplateFile {
    private IPath path;
    long stamp;
    IConfigurationElement configElement;

    VpeTemplateFile(String fileName, IConfigurationElement element) throws IOException {
        this(VpeTemplateFileList.getFilePath(fileName, element), element);
    }

    VpeTemplateFile(IPath path, IConfigurationElement element) {
        this(element);
        this.path = path;
        File file = path.toFile();
        if (file.exists() && file.isFile()) {
            this.stamp = file.lastModified();
        }
    }

    VpeTemplateFile(IConfigurationElement element) {
        this.configElement = element;
    }

    boolean isEqual(VpeTemplateFile otherTemplateFile) {
        if (otherTemplateFile == null) {
            return false;
        }
        if (!this.path.equals((Object)otherTemplateFile.getPath())) {
            return false;
        }
        return this.stamp == otherTemplateFile.getStamp();
    }

    IPath getPath() {
        return this.path;
    }

    long getStamp() {
        return this.stamp;
    }

    public IConfigurationElement getConfigurableElement() {
        return this.configElement;
    }
}

