/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class VpeValue {
    public static final int NONE_VALUE = 0;
    public static final int BOOLEAN_VALUE = 1;
    public static final int STRING_VALUE = 2;
    private static final String ERROR_TYPE_CONVERSION = VpeUIMessages.ERROR_OF_TYPE_CONVERSION;
    private int type = 0;
    private boolean booleanValue;
    private String stringValue;

    public VpeValue(boolean value) {
        this.booleanValue = value;
        this.type = 1;
    }

    public VpeValue(String value) {
        this.stringValue = value;
        this.type = 2;
    }

    public int type() {
        return this.type;
    }

    public boolean booleanValue() throws VpeExpressionException {
        if (this.type == 1) {
            return this.booleanValue;
        }
        throw new VpeExpressionException(String.valueOf(ERROR_TYPE_CONVERSION) + " for[" + this.stringValue + "]");
    }

    public String stringValue() {
        switch (this.type) {
            case 2: {
                return this.stringValue;
            }
            case 1: {
                return this.booleanValue ? "true" : "false";
            }
        }
        return "";
    }

    VpeValue equal(VpeValue other) throws VpeExpressionException {
        boolean value;
        if (this.type != other.type()) {
            throw new VpeExpressionException(String.valueOf(ERROR_TYPE_CONVERSION) + " for[" + this.stringValue + "]");
        }
        switch (this.type) {
            case 2: {
                value = this.stringValue.equals(other.stringValue());
                break;
            }
            case 1: {
                value = this.booleanValue == other.booleanValue();
                break;
            }
            default: {
                value = false;
            }
        }
        return new VpeValue(value);
    }

    VpeValue not() throws VpeExpressionException {
        if (this.type != 1) {
            throw new VpeExpressionException(String.valueOf(ERROR_TYPE_CONVERSION) + " for[" + this.stringValue + "]");
        }
        return new VpeValue(!this.booleanValue);
    }

    VpeValue and(VpeValue other) throws VpeExpressionException {
        if (this.type != 1 || other.type() != 1) {
            throw new VpeExpressionException(String.valueOf(ERROR_TYPE_CONVERSION) + " for[" + this.stringValue + "]");
        }
        return new VpeValue(this.booleanValue && other.booleanValue());
    }

    VpeValue or(VpeValue other) throws VpeExpressionException {
        if (this.type != 1 || other.type() != 1) {
            throw new VpeExpressionException(String.valueOf(ERROR_TYPE_CONVERSION) + " for[" + this.stringValue + "]");
        }
        return new VpeValue(this.booleanValue || other.booleanValue());
    }

    VpeValue plus(VpeValue other) throws VpeExpressionException {
        if (this.type != 2 || other.type() != 2) {
            throw new VpeExpressionException(String.valueOf(ERROR_TYPE_CONVERSION) + " for[" + this.stringValue + "]");
        }
        return new VpeValue(String.valueOf(this.stringValue) + other.stringValue());
    }
}

