/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar;

import org.eclipse.compare.Splitter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.toolbar.IVpeToolBar;
import org.jboss.tools.vpe.editor.toolbar.IVpeToolBarManager;

public class VpeToolBarManager
implements IVpeToolBarManager {
    private Splitter splitter;
    private Composite cmpToolBar;

    @Override
    public Composite createToolBarComposite(Composite parent) {
        this.splitter = new Splitter(parent, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                int countVisibleChild = 0;
                Control[] controlArray = this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child.getVisible()) {
                        ++countVisibleChild;
                    }
                    ++n2;
                }
                if (countVisibleChild == 0) {
                    return new Point(0, 0);
                }
                return super.computeSize(hint, hint2, changed);
            }
        };
        this.splitter.setLayoutData((Object)new GridData(768));
        return this.splitter;
    }

    @Override
    public void addToolBar(IVpeToolBar bar) {
        this.cmpToolBar = new Composite((Composite)this.splitter, 0);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        GridLayout layoutTl = new GridLayout(2, false);
        layoutTl.marginBottom = 0;
        layoutTl.marginHeight = 0;
        layoutTl.marginWidth = 0;
        layoutTl.verticalSpacing = 0;
        layoutTl.horizontalSpacing = 0;
        this.cmpToolBar.setLayout((Layout)layoutTl);
        this.cmpToolBar.setLayoutData((Object)new GridData(768));
        bar.createToolBarControl(this.cmpToolBar);
        ToolbarContainer toolbarContainer = new ToolbarContainer(this.cmpToolBar, bar);
        this.setStateToolbar((Control)this.cmpToolBar, WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Text Formatting bar"));
    }

    @Override
    public void setToolbarVisibility(boolean isVisible) {
        if (this.cmpToolBar != null) {
            this.setStateToolbar((Control)this.cmpToolBar, isVisible);
        } else {
            VpePlugin.getDefault().logError("Toolbar control is not initialized.");
        }
    }

    @Override
    public boolean isToolbarVisible() {
        boolean toolbarVisibility = false;
        if (this.cmpToolBar != null) {
            toolbarVisibility = this.cmpToolBar.isVisible();
        }
        return toolbarVisibility;
    }

    protected void setStateToolbar(Control toolBar, boolean show) {
        this.splitter.setVisible(toolBar, show);
        this.splitter.getParent().layout(true, true);
    }

    @Override
    public void dispose() {
        if (this.splitter != null) {
            this.splitter.dispose();
            this.splitter = null;
        }
    }

    private static class ToolbarContainer {
        private Composite parent;
        private IVpeToolBar toolbar;

        public ToolbarContainer(Composite parent, IVpeToolBar toolbar) {
            this.parent = parent;
            this.toolbar = toolbar;
        }

        public Composite getParent() {
            return this.parent;
        }

        public IVpeToolBar getToolbar() {
            return this.toolbar;
        }
    }
}

