/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SelectedNodeInfo;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SourceSelection;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SourceSelectionBuilder;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VisualController;
import org.jboss.tools.vpe.editor.template.textformating.FormatData;
import org.jboss.tools.vpe.editor.template.textformating.TextFormatingData;
import org.jboss.tools.vpe.editor.toolbar.format.IFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.IFormatItemSelector;
import org.jboss.tools.vpe.editor.toolbar.format.handler.FormatHandler;
import org.jboss.tools.vpe.editor.toolbar.format.handler.HandlerFactory;
import org.jboss.tools.vpe.editor.toolbar.format.handler.IFormatHandler;
import org.w3c.dom.Node;

public class FormatControllerManager {
    private VisualController vpeController = null;
    private List<IFormatController> formatControllers = new ArrayList<IFormatController>();
    private HandlerFactory handlerFactory = new HandlerFactory(this);
    private FormatData currentFormatData;
    private Node currentSelectedNode;
    private Node currentSelectedElement;
    private SelectedNodeInfo currentSelectedNodeInfo;
    private boolean controllerNotifedSelectionChange = false;
    private String currentSelectedTagValue;
    private boolean ignoreSelectionChanges = false;

    public void setVpeController(VisualController vpeController) {
        this.vpeController = vpeController;
    }

    public void selectionChanged() {
        List<SelectedNodeInfo> cleanNodesList = this.getCleanSelectedNodesList();
        if (cleanNodesList.size() == 1) {
            SelectedNodeInfo newNodeInfo = cleanNodesList.get(0);
            if (newNodeInfo != null) {
                Node newNode = newNodeInfo.getNode();
                if (this.currentSelectedNode == newNode && newNode.getNodeType() == 1) {
                    ElementImpl elementImpl = (ElementImpl)newNode;
                    int startOffset = elementImpl.getStartOffset();
                    int startEndOffset = elementImpl.getStartEndOffset();
                    StructuredTextViewer viewer = this.getVpeController().getSourceEditor().getTextViewer();
                    try {
                        String newSelectedTagValue = viewer.getDocument().get(startOffset, startEndOffset - startOffset);
                        if (this.currentSelectedTagValue != null && this.currentSelectedTagValue.equals(newSelectedTagValue)) {
                            return;
                        }
                        this.currentSelectedTagValue = newSelectedTagValue;
                    }
                    catch (BadLocationException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                    }
                } else {
                    this.currentSelectedTagValue = null;
                }
                this.currentSelectedNode = newNodeInfo.getNode();
            }
            this.currentSelectedNodeInfo = newNodeInfo;
            this.currentSelectedElement = this.currentSelectedNode;
            TextFormatingData textFormatingData = this.getFormatTemplateForSelectedNode();
            if (textFormatingData != null) {
                this.selectionChanged(textFormatingData);
            } else {
                this.disableAllFormatControllers();
            }
        } else {
            this.disableAllFormatControllers();
            this.currentSelectedTagValue = null;
            this.currentSelectedNodeInfo = null;
            this.currentSelectedElement = this.currentSelectedNode = null;
        }
    }

    private void selectionChanged(TextFormatingData textFormatingData) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        int i = 0;
        while (i < this.formatControllers.size()) {
            IFormatController controller = this.formatControllers.get(i);
            FormatData[] formatDatas = textFormatingData.getFormatDatas(controller.getType());
            boolean enabled = false;
            int j = 0;
            while (j < formatDatas.length) {
                FormatData formatData;
                this.currentFormatData = formatData = formatDatas[j];
                IFormatHandler handler = this.handlerFactory.createHandler(formatData);
                if (handler != null) {
                    if (handler instanceof FormatHandler) {
                        FormatHandler formatHandler = (FormatHandler)handler;
                        formatHandler.setFormatController(controller);
                    }
                    if (handler instanceof IFormatItemSelector) {
                        IFormatItemSelector itemHandler = (IFormatItemSelector)((Object)handler);
                        if (handler.formatIsAllowable()) {
                            itemHandler.setToolbarItemEnabled(true);
                            enabled = true;
                            break;
                        }
                    } else if (handler.formatIsAllowable()) {
                        controller.setToolbarItemEnabled(true);
                        enabled = true;
                        break;
                    }
                } else {
                    boolean allowable;
                    boolean bl = allowable = formatData.getFormatAttributes().length > 0;
                    if (allowable) {
                        controller.setToolbarItemEnabled(true);
                        enabled = true;
                        break;
                    }
                }
                ++j;
            }
            if (!enabled) {
                controller.setToolbarItemEnabled(false);
            }
            ++i;
        }
    }

    private TextFormatingData getParentFormatingDataForTextNode(SelectedNodeInfo selectedNodeInfo) {
        Node selectedNode = selectedNodeInfo.getNode();
        if (selectedNode instanceof TextImpl) {
            this.currentSelectedElement = selectedNode.getParentNode();
            return this.getFormatTemplateForTag(selectedNode.getParentNode());
        }
        return null;
    }

    public TextFormatingData getFormatTemplateForSelectedNode() {
        if (this.currentSelectedNodeInfo == null) {
            return null;
        }
        TextFormatingData textFormatingData = this.getFormatTemplateForTag(this.currentSelectedNodeInfo.getNode());
        if (textFormatingData != null) {
            this.currentSelectedElement = this.currentSelectedNode = this.currentSelectedNodeInfo.getNode();
            return textFormatingData;
        }
        textFormatingData = this.getParentFormatingDataForTextNode(this.currentSelectedNodeInfo);
        if (textFormatingData != null) {
            return textFormatingData;
        }
        return null;
    }

    public TextFormatingData getFormatTemplateForTag(Node node) {
        return null;
    }

    public SelectedNodeInfo computeSelectedNode() {
        List<SelectedNodeInfo> nodes = this.getCleanSelectedNodesList();
        if (nodes.size() == 0) {
            return null;
        }
        return nodes.get(0);
    }

    private List<SelectedNodeInfo> getCleanSelectedNodesList() {
        SourceSelection selection = this.getSelection();
        if (selection == null) {
            return new ArrayList<SelectedNodeInfo>();
        }
        List dirtyNodesList = selection.getSelectedNodes();
        List<SelectedNodeInfo> cleanNodesList = this.getCleanSelectedNodesList(dirtyNodesList);
        return cleanNodesList;
    }

    private List<SelectedNodeInfo> getCleanSelectedNodesList(List dirtyNodesList) {
        ArrayList<SelectedNodeInfo> nodes = new ArrayList<SelectedNodeInfo>(dirtyNodesList.size());
        HashSet<Node> parentNodes = new HashSet<Node>();
        int i = 0;
        while (i < dirtyNodesList.size()) {
            SelectedNodeInfo nodeInfo = (SelectedNodeInfo)dirtyNodesList.get(i);
            Node node = nodeInfo.getNode();
            if (parentNodes.contains(node.getParentNode())) {
                parentNodes.add(node);
            } else {
                TextImpl textNode;
                String value;
                parentNodes.add(node);
                if (!(node instanceof TextImpl) || (value = (textNode = (TextImpl)node).getNodeValue().trim()) != null && value.length() != 0) {
                    nodes.add(nodeInfo);
                }
            }
            ++i;
        }
        return nodes;
    }

    private void disableAllFormatControllers() {
        int i = 0;
        while (i < this.formatControllers.size()) {
            this.formatControllers.get(i).setToolbarItemEnabled(false);
            ++i;
        }
    }

    public SourceSelection getSelection() {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.vpeController.getSourceEditor());
        return sourceSelectionBuilder.getSelection();
    }

    public void addFormatController(IFormatController controller) {
        this.formatControllers.add(controller);
    }

    public VisualController getVpeController() {
        return this.vpeController;
    }

    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public Node getCurrentSelectedNode() {
        return this.currentSelectedElement;
    }

    public FormatData getCurrentFormatData() {
        return this.currentFormatData;
    }

    public SelectedNodeInfo getCurrentSelectedNodeInfo() {
        return this.currentSelectedNodeInfo;
    }

    public boolean didControllerNotifySelectionChange() {
        return this.controllerNotifedSelectionChange;
    }

    public void setControllerNotifedSelectionChange(boolean controllerNotifedSelectionChange) {
        this.controllerNotifedSelectionChange = controllerNotifedSelectionChange;
    }

    public boolean isIgnoreSelectionChanges() {
        return this.ignoreSelectionChanges;
    }

    public void setIgnoreSelectionChanges(boolean ignoreSelectionChanges) {
        this.ignoreSelectionChanges = ignoreSelectionChanges;
    }
}

