/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.vpe.preview.core.util.PlatformUtil;

public class VpePlatformUtil {
    public static final String LOAD_XULRUNNER_ENGINE = "org.jboss.tools.vpe.engine.xulrunner";
    public static final String LOAD_DEFAULT_ENGINE = "org.jboss.tools.vpe.engine.default";
    private static final String SWT_GTK3 = "SWT_GTK3";
    private static final String LOAD_XULRUNNER_SYSTEM_PROPERTY = "org.jboss.tools.vpe.loadxulrunner";
    public static boolean EMBEDDED_XULRUNNER_ENABLED = !"false".equals(System.getProperty("org.jboss.tools.vpe.loadxulrunner"));

    public static boolean isGTK3() {
        if ("gtk".equals(Platform.getWS())) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Field field = clazz.getDeclaredField("GTK3");
                boolean gtk3 = field.getBoolean(field);
                return gtk3;
            }
            catch (ClassNotFoundException e) {
                return VpePlatformUtil.isGTK3Env();
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            catch (SecurityException e) {
                return VpePlatformUtil.isGTK3Env();
            }
            catch (IllegalArgumentException e) {
                return VpePlatformUtil.isGTK3Env();
            }
            catch (IllegalAccessException e) {
                return VpePlatformUtil.isGTK3Env();
            }
        }
        return false;
    }

    private static boolean isGTK3Env() {
        String gtk3 = System.getProperty(SWT_GTK3);
        if (gtk3 == null) {
            gtk3 = System.getenv(SWT_GTK3);
        }
        return !"0".equals(gtk3);
    }

    public static boolean isXulrunnerForced() {
        return Boolean.valueOf(System.getProperty(LOAD_XULRUNNER_ENGINE));
    }

    public static boolean isDefaultBrowserForced() {
        return Boolean.valueOf(System.getProperty(LOAD_DEFAULT_ENGINE));
    }

    public static boolean xulrunnerCanBeLoadedOnLinux() {
        return PlatformUtil.isLinux() && EMBEDDED_XULRUNNER_ENABLED && !VpePlatformUtil.isGTK3();
    }
}

