/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.usage.event.UsageEvent;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JBossJaxrsUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.ws.jaxrs.ui";
    private static JBossJaxrsUIPlugin plugin;
    private ImageRegistry imageRegistry = null;
    private ImageRegistry imageDescriptorRegistry = null;
    private final UsageEventType requestSubmittedEventType = new UsageEventType((Plugin)this, "jaxrstester", "Request method (GET|POST|PUT|DELETE|OPTIONS)", UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.imageRegistry = new ImageRegistry(Display.getDefault());
        this.imageDescriptorRegistry = new ImageRegistry(Display.getDefault());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.imageRegistry.dispose();
        this.imageDescriptorRegistry.dispose();
        super.stop(context);
    }

    public static JBossJaxrsUIPlugin getDefault() {
        return plugin;
    }

    public final ImageDescriptor getImageDescriptor(String imagePath) {
        if (this.imageDescriptorRegistry.get(imagePath) == null) {
            this.imageDescriptorRegistry.put(imagePath, this.createImageDescriptor(imagePath, 0));
        }
        return this.imageDescriptorRegistry.getDescriptor(imagePath);
    }

    public final Image getImage(String imagePath) {
        return this.getImage(imagePath, 0);
    }

    public final Image getImage(String imagePath, int level) {
        Logger.debug("Loading image {} with decorator level {}", imagePath, level);
        if (imagePath == null) {
            return null;
        }
        String imageKey = imagePath.concat(String.valueOf(level));
        if (this.imageRegistry.get(imageKey) == null) {
            ImageDescriptor imageDescriptor = this.createImageDescriptor(imagePath, level);
            this.imageRegistry.put(imageKey, imageDescriptor.createImage());
        }
        return this.imageRegistry.get(imageKey);
    }

    public final ImageDescriptor createImageDescriptor(String imagePath, int problemLevel) {
        Path imageFilePath = new Path("/icons/" + imagePath);
        URL imageFileUrl = FileLocator.find((Bundle)this.getBundle(), (IPath)imageFilePath, null);
        ImageDescriptor baseImageDescriptor = ImageDescriptor.createFromURL((URL)imageFileUrl);
        switch (problemLevel) {
            case 2: {
                return this.createDecoratedImageDescriptor(baseImageDescriptor, "IMG_DEC_FIELD_ERROR");
            }
            case 1: {
                return this.createDecoratedImageDescriptor(baseImageDescriptor, "IMG_DEC_FIELD_WARNING");
            }
        }
        return baseImageDescriptor;
    }

    private ImageDescriptor createDecoratedImageDescriptor(ImageDescriptor baseImageDescriptor, String decoratorId) {
        ImageDescriptor decoratorDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(decoratorId);
        Image baseImage = baseImageDescriptor.createImage();
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[2] = decoratorDescriptor;
        DecorationOverlayIcon result = new DecorationOverlayIcon(baseImage, imageDescriptorArray, new Point(16, 16));
        return result;
    }

    public void countRequestSubmitted(String method) {
        UsageEvent requestSubmittedEvent = this.requestSubmittedEventType.event(method);
        UsageReporter.getInstance().countEvent(requestSubmittedEvent);
    }
}

