/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf.action;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateElement;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateMediaTypeMappingElement;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateMethodMappingElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class OpenJavaEditorAction
extends Action
implements ISelectionChangedListener {
    private ISelection selection = null;

    public OpenJavaEditorAction() {
        super("Open in Java Editor");
    }

    public void run() {
        ITreeSelection treeSelection = (ITreeSelection)this.selection;
        for (Object selection : treeSelection.toList()) {
            try {
                IMethod javaMethod;
                IJaxrsResourceMethod lastMethod;
                if (selection instanceof UriPathTemplateElement) {
                    lastMethod = ((UriPathTemplateElement)selection).getLastMethod();
                    javaMethod = lastMethod.getJavaElement();
                    JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)javaMethod), (IJavaElement)javaMethod);
                    continue;
                }
                if (selection instanceof UriPathTemplateMethodMappingElement) {
                    lastMethod = ((UriPathTemplateMethodMappingElement)selection).getResourceMethod();
                    javaMethod = lastMethod.getJavaElement();
                    JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)javaMethod), (IJavaElement)javaMethod);
                    continue;
                }
                if (!(selection instanceof UriPathTemplateMediaTypeMappingElement)) continue;
                IJavaElement element = ((UriPathTemplateMediaTypeMappingElement)selection).getElement();
                JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)element), (IJavaElement)element);
            }
            catch (Exception e) {
                Logger.error("Failed to open Java editor", e);
            }
        }
        super.run();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source instanceof CommonViewer) {
            this.selection = ((CommonViewer)source).getSelection();
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

