/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsWebxmlApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.wtp.WtpUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsMetamodelValidator;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsMetamodelValidatorDelegate {
    private final IMarkerManager markerManager;

    public JaxrsMetamodelValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    void validate(JaxrsMetamodel metamodel) throws CoreException {
        Logger.debug("Validating element {}", metamodel);
        JaxrsMetamodelValidator.removeJaxrsMarkers(metamodel.getProject());
        metamodel.resetProblemLevel();
        Set javaApplications = metamodel.findJavaApplications();
        Set webxmlApplications = metamodel.findWebxmlApplications();
        if (javaApplications.isEmpty() && webxmlApplications.isEmpty() && metamodel.hasCustomElements()) {
            this.markerManager.addMarker(metamodel, JaxrsValidationMessages.APPLICATION_NO_OCCURRENCE_FOUND, new String[0], JaxrsPreferences.APPLICATION_NO_OCCURRENCE_FOUND);
        } else if (javaApplications.size() >= 2 || javaApplications.size() >= 1 && webxmlApplications.size() >= 1) {
            for (JaxrsJavaApplication javaApplication : javaApplications) {
                this.validateApplication(javaApplication);
            }
            for (IJaxrsApplication webxmlapplication : webxmlApplications) {
                this.validateWebxmlApplication(webxmlapplication, javaApplications);
            }
        }
    }

    private void validateWebxmlApplication(IJaxrsApplication webxmlapplication, Collection<JaxrsJavaApplication> javaApplications) throws CoreException, JavaModelException {
        JaxrsWebxmlApplication webxmlApplication = (JaxrsWebxmlApplication)webxmlapplication;
        if (webxmlApplication.isOverride() && javaApplications.size() >= 2 || !webxmlApplication.isOverride() && javaApplications.size() >= 1) {
            ISourceRange webxmlNameRange = WtpUtils.getApplicationPathLocation((IResource)webxmlApplication.getResource(), (String)webxmlApplication.getJavaClassName());
            if (webxmlNameRange == null) {
                Logger.warn("Cannot add a problem marker: unable to locate '" + webxmlApplication.getJavaClassName() + "' in resource '" + webxmlApplication.getResource().getFullPath().toString() + "'. ");
            } else {
                this.addTooManyOccurrencesMarker((JaxrsBaseElement)webxmlApplication, webxmlNameRange);
                if (webxmlApplication.isOverride()) {
                    JaxrsJavaApplication javaApplication = webxmlApplication.getOverridenJaxrsJavaApplication();
                    ISourceRange javaNameRange = ((IType)javaApplication.getJavaElement()).getNameRange();
                    this.addTooManyOccurrencesMarker((JaxrsBaseElement)javaApplication, javaNameRange);
                }
            }
        }
    }

    private void validateApplication(JaxrsJavaApplication javaApplication) throws CoreException, JavaModelException {
        if (javaApplication.isOverriden()) {
            return;
        }
        ISourceRange javaNameRange = ((IType)javaApplication.getJavaElement()).getNameRange();
        this.addTooManyOccurrencesMarker((JaxrsBaseElement)javaApplication, javaNameRange);
    }

    public void addTooManyOccurrencesMarker(JaxrsBaseElement application, ISourceRange javaNameRange) throws CoreException {
        this.markerManager.addMarker(application, javaNameRange, JaxrsValidationMessages.APPLICATION_TOO_MANY_OCCURRENCES, new String[0], JaxrsPreferences.APPLICATION_TOO_MANY_OCCURRENCES);
    }
}

