/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.preferences.SettingsPage;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.ws.jaxrs.core.configuration.ProjectNatureUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferencesMessages;

public class JaxrsSettingsPreferencePage
extends SettingsPage {
    public static final String ID = "org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsSettingsPreferencePage";
    private IProject project;
    private boolean jaxrsEnabled;
    private boolean initialState;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        try {
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = false;
            GridLayout gridLayout = new GridLayout(1, false);
            root.setLayout((Layout)gridLayout);
            Composite generalGroup = new Composite(root, 0);
            generalGroup.setLayoutData((Object)gd);
            gridLayout = new GridLayout(4, false);
            generalGroup.setLayout((Layout)gridLayout);
            this.initialState = this.isJaxrsEnabled(this.project);
            IFieldEditor jaxrsSupportCheckBox = IFieldEditorFactory.INSTANCE.createCheckboxEditor(JaxrsPreferencesMessages.JAXRS_SETTINGS_PREFERENCE_PAGE_JAXRS_SUPPORT, JaxrsPreferencesMessages.JAXRS_SETTINGS_PREFERENCE_PAGE_JAXRS_SUPPORT, this.initialState);
            jaxrsSupportCheckBox.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object value = evt.getNewValue();
                    if (value instanceof Boolean) {
                        boolean v = (Boolean)value;
                        JaxrsSettingsPreferencePage.this.setEnabledJaxrsSuport(v);
                    }
                }
            });
            this.jaxrsEnabled = this.isJaxrsEnabled(this.project);
            this.registerEditor(jaxrsSupportCheckBox, generalGroup);
            this.validate();
        }
        catch (CoreException e) {
            Logger.error("Failed to display JAX-RS settings page", e);
        }
        return root;
    }

    protected void performDefaults() {
        try {
            this.getEditor(JaxrsPreferencesMessages.JAXRS_SETTINGS_PREFERENCE_PAGE_JAXRS_SUPPORT).setValue((Object)this.isJaxrsEnabled(this.project));
            this.validate();
        }
        catch (CoreException e) {
            Logger.error("Failed to restore defaults on JAX-RS settings page", e);
        }
    }

    public boolean performOk() {
        try {
            if (this.isJaxrsEnabled() != this.initialState) {
                if (this.isJaxrsEnabled()) {
                    this.addJaxrsSupport(this.project);
                } else {
                    this.removeJaxrsSupport(this.project);
                }
                this.initialState = this.isJaxrsEnabled();
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to apply changes on JAX-RS settings page", e);
        }
        return true;
    }

    private void addJaxrsSupport(IProject project) throws CoreException {
        if (project == null) {
            return;
        }
        ProjectNatureUtils.installProjectNature((IProject)project, (String)"org.jboss.tools.ws.jaxrs.nature");
    }

    private void removeJaxrsSupport(IProject project) throws CoreException {
        ProjectNatureUtils.uninstallProjectNature((IProject)project, (String)"org.jboss.tools.ws.jaxrs.nature");
    }

    private boolean isJaxrsEnabled(IProject project) throws CoreException {
        return ProjectNatureUtils.isProjectNatureInstalled((IProject)project, (String)"org.jboss.tools.ws.jaxrs.nature");
    }

    private boolean isJaxrsEnabled() {
        return this.jaxrsEnabled;
    }

    public void setEnabledJaxrsSuport(boolean enabled) {
        this.jaxrsEnabled = enabled;
        ((IFieldEditor)this.editorRegistry.get(JaxrsPreferencesMessages.JAXRS_SETTINGS_PREFERENCE_PAGE_JAXRS_SUPPORT)).setValue((Object)enabled);
    }

    protected void validate() {
    }
}

