/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.usage.event.UsageEvent;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.views.WSType;
import org.osgi.framework.BundleContext;

public class JBossWSUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.ws.ui";
    public static final String WSTYPE_EXTENSION_POINT = "org.jboss.tools.ws.ui.wsType";
    public static final String IMG_DESC_START = "obj16/run.gif";
    public static final String IMG_DESC_SHOWTREE = "obj16/hierarchicalLayout.gif";
    public static final String IMG_DESC_SHOWRAW = "obj16/binary.gif";
    public static final String IMG_DESC_SHOWWEB = "obj16/web.gif";
    public static final String IMG_DESC_SHOWEDITOR = "obj16/properties.gif";
    public static final String IMG_DESC_SAVE = "obj16/save_edit.gif";
    private static JBossWSUIPlugin plugin;
    private final UsageEventType requestSubmittedEventType = new UsageEventType((Plugin)this, "wstester", "Request method (JAX-WS|GET|POST|PUT|DELETE|OPTIONS)", UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);
    private static List<WSType> wsTypes;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        UsageReporter.getInstance().registerEvent(this.requestSubmittedEventType);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JBossWSUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        path = "icons/" + path;
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(Throwable ex) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, JBossWSUIMessages.JBossWS_UI_PLUGIN_NO_MESSAGES, ex));
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    private IWorkbenchWindow internalGetActiveWorkbenchWindow() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window;
    }

    public static IWorkbenchPage getActivePage() {
        return JBossWSUIPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JBossWSUIPlugin.getDefault().internalGetActiveWorkbenchWindow();
    }

    public void countRequestSubmitted(String method) {
        UsageEvent requestSubmittedEvent = this.requestSubmittedEventType.event(method);
        UsageReporter.getInstance().countEvent(requestSubmittedEvent);
    }

    public static List<WSType> getSupportedWSTypes() {
        if (wsTypes == null) {
            IConfigurationElement[] elements;
            wsTypes = new ArrayList<WSType>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(WSTYPE_EXTENSION_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    WSType wsType = (WSType)e.createExecutableExtension("class");
                    wsTypes.add(wsType);
                }
                catch (Exception ex) {
                    JBossWSUIPlugin.log(ex);
                }
                ++n2;
            }
        }
        return wsTypes;
    }
}

