/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.ResultsXMLStorage;
import org.jboss.tools.ws.ui.utils.ResultsXMLStorageInput;
import org.jboss.tools.ws.ui.utils.WSTestUtils;
import org.jboss.tools.ws.ui.utils.XMLParser;
import org.jboss.tools.ws.ui.views.FormExpansionAdapter;
import org.jboss.tools.ws.ui.views.ShowRawAction;
import org.jboss.tools.ws.ui.views.TestEntry;
import org.jboss.tools.ws.ui.views.TestHistory;
import org.jboss.tools.ws.ui.views.ToggleAction;
import org.jboss.tools.ws.ui.views.UidPwdDialog;
import org.jboss.tools.ws.ui.views.WSProperty;
import org.jboss.tools.ws.ui.views.WSTestStatus;
import org.jboss.tools.ws.ui.views.WSType;

public class WebServicesTestView
extends ViewPart {
    private static final String PAGE1_KEY = "page1";
    private static final String PAGE2_KEY = "page2";
    private static final String EMPTY_STRING = "";
    private static final String HTTPS_STRING = "https";
    public static final String ID = "org.jboss.tools.ws.ui.tester.views.TestWSView";
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String XML_EDITOR_ID = "org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart";
    private Text resultsText;
    private Browser resultsBrowser;
    private Combo urlCombo;
    private ComboViewer methodComboViewer;
    private ListViewer resultHeadersListViewer;
    private Composite additionalDetailsComposite;
    private Section requestSection;
    private Button useBasicAuthCB;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private ToolBarManager toolBarManager;
    private MenuItem openInXMLEditorAction;
    private Menu resultsTextMenu;
    private MenuItem copyMenuAction;
    private Menu resultsHeaderMenu;
    private MenuItem copyResultHeaderMenuAction;
    private Action startAction;
    private TestHistory history = new TestHistory();
    private TestEntry currentEntry;
    private List<WSType> wsTypes = JBossWSUIPlugin.getSupportedWSTypes();

    public WebServicesTestView() {
        for (WSType ws : this.wsTypes) {
            ws.setWebServicesView(this);
        }
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                WebServicesTestView.this.form.setRedraw(false);
                WebServicesTestView.this.form.reflow(true);
                WebServicesTestView.this.form.layout(true, true);
                WebServicesTestView.this.form.setRedraw(true);
            }
        });
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        layout.verticalSpacing = 1;
        GridData gridData = new GridData(4, 0x1000000, true, true);
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)gridData);
        this.createURLAndToolbar();
        SashForm sashForm = new SashForm(this.form.getBody(), 0);
        sashForm.setOrientation(256);
        this.toolkit.adapt((Composite)sashForm);
        GridLayout sashLayout = new GridLayout(2, false);
        sashForm.setLayout((Layout)sashLayout);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        gd3.widthHint = 1;
        sashForm.setLayoutData((Object)gd3);
        this.createRequestSide(sashForm);
        this.createResponseSide(sashForm);
        this.toolkit.paintBordersFor((Composite)this.form);
        this.form.reflow(true);
        this.methodComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.wsTypes.get(0)));
        this.updateControlsForCurrentURL();
        this.updateControlsForCurrentWSType();
        this.updateMenuForResponse();
    }

    public String getURL() {
        return this.urlCombo.getText();
    }

    public void setURL(String url) {
        this.urlCombo.setText(url);
    }

    public void setType(String url, String type) {
        for (WSType wsType : this.wsTypes) {
            if (!wsType.getType().equals(type)) continue;
            this.methodComboViewer.setSelection((ISelection)new StructuredSelection((Object)wsType));
            this.getCurrentEntry().setWsTech(wsType);
            break;
        }
        this.urlCombo.setText(url);
        this.getCurrentEntry().setCustomEntry(null);
        this.getCurrentEntry().setResult(null);
        this.getCurrentEntry().setResultHeaders(null);
        this.getCurrentEntry().setUrl(url);
        this.updateControlsForCurrentURL();
        this.updateControlsForCurrentWSType();
        this.updateMenuForResponse();
    }

    public void redrawRequestDetails() {
        this.form.setRedraw(false);
        this.form.reflow(true);
        this.form.layout(true, true);
        this.form.setRedraw(true);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    private void createResponseToolbar(ScrolledPageBook pageBook, ExpandableComposite parent) {
        final ShowRawAction rawAction = new ShowRawAction(pageBook, PAGE1_KEY);
        rawAction.setChecked(true);
        final ShowInBrowserAction browserAction = new ShowInBrowserAction(pageBook);
        rawAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                if (rawAction.isChecked() && browserAction.isChecked()) {
                    browserAction.setChecked(false);
                }
            }
        });
        browserAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                if (browserAction.isChecked() && rawAction.isChecked()) {
                    rawAction.setChecked(false);
                }
            }
        });
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)parent);
        toolBarManager.add((IAction)new FileSaveAction());
        toolBarManager.add((IAction)new OpenInXMLEditorAction());
        toolBarManager.add((IAction)rawAction);
        toolBarManager.add((IAction)browserAction);
        toolBarManager.update(true);
        parent.setTextClient((Control)toolbar);
    }

    private WSType getCurrentTestType() {
        if (this.methodComboViewer != null && this.methodComboViewer.getSelection() != null) {
            return (WSType)((IStructuredSelection)this.methodComboViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    private void createURLAndToolbar() {
        Composite urlAndToolComposite = new Composite(this.form.getBody(), 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(urlAndToolComposite);
        GridData comp1data = new GridData(4, 0x1000000, true, false);
        urlAndToolComposite.setLayoutData((Object)comp1data);
        this.urlCombo = new Combo(urlAndToolComposite, 2052);
        GridData gdURL = new GridData(4, 0x1000000, true, false);
        this.urlCombo.setLayoutData((Object)gdURL);
        this.urlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource().equals(WebServicesTestView.this.urlCombo)) {
                    String newURL = WebServicesTestView.this.urlCombo.getText();
                    WebServicesTestView.this.updateControlsForCurrentURL();
                    WebServicesTestView.this.getCurrentEntry().setUrl(newURL);
                }
            }
        });
        this.urlCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                WebServicesTestView.this.updateControlsForCurrentURL();
                WebServicesTestView.this.getCurrentEntry().setUrl(WebServicesTestView.this.urlCombo.getText());
                if (e.keyCode == 13 && WebServicesTestView.this.startAction.isEnabled()) {
                    WebServicesTestView.this.handleTest(WebServicesTestView.this.getCurrentTestType());
                }
            }
        });
        this.urlCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String testURL = WebServicesTestView.this.urlCombo.getText();
                TestEntry entry = WebServicesTestView.this.history.findEntryByURL(testURL);
                if (entry != null) {
                    try {
                        WebServicesTestView.this.currentEntry = entry.clone();
                        WebServicesTestView.this.methodComboViewer.setSelection((ISelection)new StructuredSelection((Object)WebServicesTestView.this.currentEntry.getWsTech()));
                        WebServicesTestView.this.updateControlsForSelectedEntry(entry);
                    }
                    catch (CloneNotSupportedException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    WebServicesTestView.this.getCurrentEntry().setUrl(WebServicesTestView.this.urlCombo.getText());
                    WebServicesTestView.this.updateControlsForCurrentURL();
                }
            }
        });
        Combo methodCombo = new Combo(urlAndToolComposite, 2056);
        methodCombo.setBackground(this.form.getBody().getBackground());
        this.methodComboViewer = new ComboViewer(methodCombo);
        this.methodComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.methodComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof WSType) {
                    return ((WSType)element).getType();
                }
                return null;
            }
        });
        this.methodComboViewer.setInput(this.wsTypes);
        this.methodComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                WebServicesTestView.this.updateControlsForCurrentWSType();
                List<IAction> actions = ((WSType)e.getStructuredSelection().getFirstElement()).getAdditonalToolActions();
                WebServicesTestView.this.updateToolBar(actions);
            }
        });
        ToolBar toolbar = new ToolBar(urlAndToolComposite, 0x800000);
        this.toolBarManager = new ToolBarManager(toolbar);
        if (this.getCurrentTestType() != null) {
            List<IAction> actions = this.getCurrentTestType().getAdditonalToolActions();
            for (IAction action : actions) {
                this.toolBarManager.add(action);
            }
            this.toolBarManager.update(true);
        }
        this.startAction = new Action(){

            public void run() {
                WebServicesTestView.this.handleTest(WebServicesTestView.this.getCurrentTestType());
            }

            public String getToolTipText() {
                return JBossWSUIMessages.JAXRSWSTestView2_Go_Tooltip;
            }

            public ImageDescriptor getImageDescriptor() {
                return JBossWSUIPlugin.getImageDescriptor("obj16/run.gif");
            }
        };
        this.updateToolBar(null);
        this.toolkit.adapt(urlAndToolComposite);
    }

    private void updateToolBar(List<IAction> additionalActions) {
        this.toolBarManager.removeAll();
        if (additionalActions != null) {
            for (IAction action : additionalActions) {
                this.toolBarManager.add(action);
            }
        }
        this.toolBarManager.add((IAction)this.startAction);
        this.toolBarManager.update(true);
    }

    private void createRequestSide(SashForm sashForm) {
        this.requestSection = this.toolkit.createSection((Composite)sashForm, 322);
        this.requestSection.setText(JBossWSUIMessages.JAXRSWSTestView2_RequestDetails_Section);
        Composite sectionComposite = this.toolkit.createComposite((Composite)this.requestSection);
        sectionComposite.setLayout((Layout)new GridLayout());
        sectionComposite.setLayoutData((Object)new GridData());
        this.useBasicAuthCB = this.toolkit.createButton(sectionComposite, JBossWSUIMessages.JAXRSWSTestView2_Checkbox_Basic_Authentication, 32);
        GridData gd10 = new GridData(4, 0, true, false);
        gd10.horizontalIndent = 3;
        this.useBasicAuthCB.setLayoutData((Object)gd10);
        this.additionalDetailsComposite = new Composite(sectionComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.additionalDetailsComposite);
        GridData detailsData = new GridData(4, 0, true, false);
        this.additionalDetailsComposite.setLayoutData((Object)detailsData);
        this.requestSection.addExpansionListener((IExpansionListener)new FormExpansionAdapter(this));
        this.requestSection.setClient((Control)sectionComposite);
    }

    public TestEntry getCurrentEntry() {
        if (this.currentEntry == null) {
            this.currentEntry = new TestEntry();
        }
        return this.currentEntry;
    }

    private void createResponseSide(SashForm sashForm) {
        Section section2 = this.toolkit.createSection((Composite)sashForm, 322);
        section2.setText(JBossWSUIMessages.JAXRSWSTestView2_ResponseDetails_Section);
        Composite sectionClient2 = this.toolkit.createComposite((Composite)section2);
        sectionClient2.setLayout((Layout)new GridLayout());
        sectionClient2.setLayoutData((Object)new GridData(4, 4, true, true));
        ExpandableComposite ec2 = this.toolkit.createExpandableComposite(sectionClient2, 276);
        ec2.setText(JBossWSUIMessages.JAXRSWSTestView2_ResponseHeaders_Section);
        ec2.setLayout((Layout)new GridLayout());
        final org.eclipse.swt.widgets.List resultHeadersList = new org.eclipse.swt.widgets.List((Composite)ec2, 2560);
        this.resultHeadersListViewer = new ListViewer(resultHeadersList);
        this.resultHeadersListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resultHeadersListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                WSProperty rProperty = (WSProperty)element;
                return rProperty.toString();
            }
        });
        ec2.setClient((Control)resultHeadersList);
        this.resultsHeaderMenu = new Menu((Decorations)resultHeadersList.getShell(), 8);
        this.copyResultHeaderMenuAction = new MenuItem(this.resultsHeaderMenu, 8);
        this.copyResultHeaderMenuAction.setText(JBossWSUIMessages.JAXRSWSTestView_CopyResultMenu_Text);
        this.copyResultHeaderMenuAction.setAccelerator(262211);
        this.copyResultHeaderMenuAction.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                if (resultHeadersList.getSelectionCount() == 0) {
                    resultHeadersList.selectAll();
                }
                Display display = Display.getDefault();
                Clipboard cb = new Clipboard(display);
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents((Object[])resultHeadersList.getSelection(), new Transfer[]{textTransfer});
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        resultHeadersList.setMenu(this.resultsHeaderMenu);
        resultHeadersList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                WebServicesTestView.this.updateMenuForResponse();
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        GridData gd6 = new GridData(4, 4, true, false);
        gd6.heightHint = 1;
        gd6.minimumHeight = 50;
        ec2.setLayoutData((Object)gd6);
        ec2.addExpansionListener((IExpansionListener)new FormExpansionAdapter(this));
        ExpandableComposite ec4 = this.toolkit.createExpandableComposite(sectionClient2, 338);
        ec4.setText(JBossWSUIMessages.JAXRSWSTestView2_ResponseBody_Section);
        ScrolledPageBook pageBook = this.toolkit.createPageBook((Composite)ec4, 0);
        this.createResponseToolbar(pageBook, ec4);
        Composite page1 = pageBook.createPage((Object)PAGE1_KEY);
        page1.setLayout((Layout)new GridLayout());
        this.resultsText = this.toolkit.createText(page1, EMPTY_STRING, 2624);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.heightHint = 1;
        this.resultsText.setLayoutData((Object)gd7);
        pageBook.showPage((Object)PAGE1_KEY);
        Composite page2 = pageBook.createPage((Object)PAGE2_KEY);
        page2.setLayout((Layout)new GridLayout());
        this.resultsBrowser = new Browser(page2, 2112);
        GridData gd10 = new GridData(4, 4, true, true);
        gd10.heightHint = 1;
        this.toolkit.adapt((Composite)this.resultsBrowser);
        this.resultsBrowser.setLayoutData((Object)gd10);
        pageBook.showPage((Object)PAGE2_KEY);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 1;
        gd.minimumHeight = 100;
        pageBook.setLayoutData((Object)gd);
        pageBook.showPage((Object)PAGE1_KEY);
        this.resultsTextMenu = new Menu((Decorations)this.resultsText.getShell(), 8);
        this.copyMenuAction = new MenuItem(this.resultsTextMenu, 8);
        this.copyMenuAction.setText(JBossWSUIMessages.JAXRSWSTestView_CopyResultsMenu);
        this.copyMenuAction.setAccelerator(262211);
        this.copyMenuAction.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                if (WebServicesTestView.this.resultsText.getSelectionCount() == 0) {
                    WebServicesTestView.this.resultsText.selectAll();
                }
                WebServicesTestView.this.resultsText.copy();
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        new MenuItem(this.resultsTextMenu, 2);
        this.openInXMLEditorAction = new MenuItem(this.resultsTextMenu, 8);
        this.openInXMLEditorAction.setText(JBossWSUIMessages.JAXRSWSTestView_Open_Result_in_XML_Editor);
        this.openInXMLEditorAction.setAccelerator(262223);
        this.openInXMLEditorAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String string = WebServicesTestView.this.resultsText.getText();
                WebServicesTestView.this.openXMLEditor(string);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.resultsText.setMenu(this.resultsTextMenu);
        this.resultsText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
            }

            public void focusGained(FocusEvent arg0) {
                WebServicesTestView.this.updateMenuForResponse();
            }
        });
        ec4.setClient((Control)pageBook);
        GridData gd8 = new GridData(4, 4, true, true);
        gd8.heightHint = 1;
        ec4.setLayoutData((Object)gd8);
        ec4.addExpansionListener((IExpansionListener)new FormExpansionAdapter(this));
        section2.addExpansionListener((IExpansionListener)new FormExpansionAdapter(this));
        section2.setClient((Control)sectionClient2);
    }

    private void updateMenuForResponse() {
        boolean enabled;
        if (this.resultsText != null && !this.resultsText.isDisposed()) {
            enabled = this.resultsText.getText().trim().length() > 0;
            this.copyMenuAction.setEnabled(enabled);
            this.openInXMLEditorAction.setEnabled(enabled);
        }
        if (this.resultHeadersListViewer != null && !this.resultHeadersListViewer.getControl().isDisposed()) {
            enabled = this.resultHeadersListViewer.getList().getItemCount() > 0;
            this.copyResultHeaderMenuAction.setEnabled(enabled);
        }
    }

    private void updateControlsForSelectedEntry(TestEntry entry) {
        if (entry != null) {
            if (entry.getWsTech() != null) {
                this.methodComboViewer.setSelection((ISelection)new StructuredSelection((Object)entry.getWsTech()));
                entry.getWsTech().updateControlsForSelectedEntry(entry);
            }
            if (this.resultsText.isEnabled() && this.resultsBrowser.isEnabled()) {
                this.resultsText.setText(entry.getResult());
                this.resultsBrowser.setText(entry.getResult());
            }
            if (entry.getUrl().trim().length() > 0) {
                String urlText = entry.getUrl();
                try {
                    new URL(urlText);
                    this.startAction.setEnabled(true);
                }
                catch (MalformedURLException malformedURLException) {
                    this.startAction.setEnabled(false);
                    return;
                }
            } else {
                this.startAction.setEnabled(false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateControlsForCurrentURL() {
        if (this.urlCombo.getText().trim().length() > 0) {
            String urlText = this.urlCombo.getText();
            try {
                new URL(urlText);
                this.startAction.setEnabled(true);
                if (!urlText.trim().startsWith(HTTPS_STRING)) return;
                this.useBasicAuthCB.setSelection(true);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                this.startAction.setEnabled(false);
                return;
            }
        } else {
            this.startAction.setEnabled(false);
        }
    }

    private void updateControlsForCurrentWSType() {
        Control[] controlArray = this.additionalDetailsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        WSType type = this.getCurrentTestType();
        if (type != null) {
            type.fillAdditionalRequestDetails(this.additionalDetailsComposite);
        }
        this.additionalDetailsComposite.layout();
        this.requestSection.layout();
    }

    private void handleTest(final WSType wsTech) {
        final String urlText = this.urlCombo.getText();
        try {
            new URL(urlText);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String tempUID = null;
        String tempPwd = null;
        if (this.useBasicAuthCB.getSelection()) {
            UidPwdDialog authDialog = new UidPwdDialog(this.getSite().getShell());
            int rtnCode = authDialog.open();
            if (rtnCode == 0) {
                tempUID = authDialog.getUID();
                tempPwd = authDialog.getPwd();
            } else {
                return;
            }
        }
        final String uid = tempUID;
        final String pwd = tempPwd;
        this.startAction.setEnabled(false);
        Job aJob = new Job(JBossWSUIMessages.JAXRSWSTestView_Invoking_WS_Status){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                status = wsTech.handleWSTest(monitor, urlText, uid, pwd);
                monitor.done();
                return status;
            }
        };
        aJob.setUser(true);
        aJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                try {
                    if (event.getResult() instanceof WSTestStatus) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                TestEntry historyEntry = WebServicesTestView.this.getCurrentEntry();
                                WSTestStatus status = (WSTestStatus)event.getResult();
                                if (status.getResultsText() != null) {
                                    String results = status.getResultsText();
                                    results = XMLParser.isValidXML(results) ? XMLParser.prettyPrint(results) : XMLParser.prettyPrintJSON(results);
                                    historyEntry.setResult(results);
                                    historyEntry.setUrl(WebServicesTestView.this.urlCombo.getText());
                                    historyEntry.setWsTech((WSType)WebServicesTestView.this.methodComboViewer.getStructuredSelection().getFirstElement());
                                    WebServicesTestView.this.resultsText.setText(results);
                                    WebServicesTestView.this.resultsBrowser.setText(results);
                                    WebServicesTestView.this.form.reflow(true);
                                } else if (status.getMessage() != null) {
                                    historyEntry.setResult(status.getMessage());
                                    historyEntry.setUrl(WebServicesTestView.this.urlCombo.getText());
                                    historyEntry.setWsTech((WSType)WebServicesTestView.this.methodComboViewer.getStructuredSelection().getFirstElement());
                                    WebServicesTestView.this.resultsText.setText(status.getMessage());
                                    WebServicesTestView.this.resultsBrowser.setText(status.getMessage());
                                    WebServicesTestView.this.form.reflow(true);
                                }
                                Map<String, List<String>> headersMap = status.getHeaders();
                                LinkedHashSet<WSProperty> headers = new LinkedHashSet<WSProperty>();
                                if (headersMap != null) {
                                    for (String key : headersMap.keySet()) {
                                        List<String> obj = headersMap.get(key);
                                        String objStringValue = WebServicesTestView.EMPTY_STRING;
                                        if (obj != null) {
                                            objStringValue = obj.toString();
                                        }
                                        headers.add(new WSProperty(key, objStringValue));
                                    }
                                }
                                WebServicesTestView.this.resultHeadersListViewer.setInput(headers);
                                historyEntry.setResultHeaders(headers);
                                TestEntry oldEntry = WebServicesTestView.this.history.findEntryByURL(WebServicesTestView.this.getCurrentEntry().getUrl());
                                if (oldEntry != null) {
                                    WebServicesTestView.this.history.replaceEntry(oldEntry, WebServicesTestView.this.getCurrentEntry());
                                } else {
                                    try {
                                        WebServicesTestView.this.history.addEntry(WebServicesTestView.this.getCurrentEntry().clone());
                                    }
                                    catch (CloneNotSupportedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            List<String> aList;
                            WebServicesTestView.this.startAction.setEnabled(true);
                            WebServicesTestView.this.updateMenuForResponse();
                            if (WebServicesTestView.this.urlCombo.getItemCount() > 0 && (aList = Arrays.asList(WebServicesTestView.this.urlCombo.getItems())).contains(WebServicesTestView.this.urlCombo.getText())) {
                                return;
                            }
                            WebServicesTestView.this.urlCombo.add(WebServicesTestView.this.urlCombo.getText());
                        }
                    });
                    throw throwable;
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        });
        aJob.schedule();
    }

    public void setFocus() {
        this.urlCombo.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }

    private void openXMLEditor(String text) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ResultsXMLStorage storage = new ResultsXMLStorage(text);
        ResultsXMLStorageInput input = new ResultsXMLStorageInput(storage);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            try {
                if (WSTestUtils.isTextXML(text)) {
                    if (PlatformUI.getWorkbench().getEditorRegistry().findEditor(XML_EDITOR_ID) != null) {
                        page.openEditor((IEditorInput)input, XML_EDITOR_ID);
                    } else {
                        page.openEditor((IEditorInput)input, DEFAULT_TEXT_EDITOR_ID);
                    }
                } else {
                    page.openEditor((IEditorInput)input, DEFAULT_TEXT_EDITOR_ID);
                }
            }
            catch (PartInitException e) {
                JBossWSUIPlugin.log(e);
            }
        }
    }

    class FileSaveAction
    extends Action {
        FileSaveAction() {
        }

        public void run() {
            IStatus status = WSTestUtils.saveTextToFile(WebServicesTestView.this.resultsText.getText());
            if (status.getCode() == 4) {
                MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)JBossWSUIMessages.JAXRSWSTestView2_SaveResponseText_Error, (String)status.getMessage());
            }
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_SaveResponseText_tooltip;
        }

        public ImageDescriptor getImageDescriptor() {
            return JBossWSUIPlugin.getImageDescriptor("obj16/save_edit.gif");
        }
    }

    class OpenInXMLEditorAction
    extends Action {
        OpenInXMLEditorAction() {
        }

        public void run() {
            WebServicesTestView.this.openXMLEditor(WebServicesTestView.this.resultsText.getText());
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_OpenInEditor_Action;
        }

        public ImageDescriptor getImageDescriptor() {
            return JBossWSUIPlugin.getImageDescriptor("obj16/properties.gif");
        }
    }

    class ShowInBrowserAction
    extends ToggleAction {
        private ScrolledPageBook pageBook;

        public ShowInBrowserAction(ScrolledPageBook pageBook) {
            this.pageBook = pageBook;
        }

        public void run() {
            this.pageBook.showPage((Object)WebServicesTestView.PAGE2_KEY);
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_ShowInBrowser_Tooltip;
        }

        public ImageDescriptor getImageDescriptor() {
            return JBossWSUIPlugin.getImageDescriptor("obj16/web.gif");
        }
    }
}

