/*
 * Decompiled with CFR 0.152.
 */
package tern.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.resources.AbstractTernFile;
import tern.utils.ExtensionUtils;
import tern.utils.IOUtils;

public class FilesystemTernFile
extends AbstractTernFile
implements ITernFile {
    private File file;
    private File canonical;

    public FilesystemTernFile(File file) {
        this.file = file;
    }

    @Override
    public boolean isAccessible() {
        return this.file.isFile() && this.file.canRead();
    }

    @Override
    public String getFullName(ITernProject project) {
        if (this.canonical == null) {
            try {
                this.canonical = this.file.getCanonicalFile();
            }
            catch (IOException iOException) {
                this.canonical = this.file;
            }
        }
        if (project != null) {
            try {
                String fileName;
                String path = project.getProjectDir().getCanonicalPath().replace('\\', '/');
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
                if ((fileName = this.canonical.toString().replace('\\', '/')).startsWith(path)) {
                    return fileName.substring(path.length());
                }
            }
            catch (Exception exception) {}
        }
        return "external://" + this.canonical.toString();
    }

    @Override
    public String getFileName() {
        String full = this.getFullName(null);
        int last = full.lastIndexOf(47);
        if (last >= 0) {
            return full.substring(last + 1);
        }
        return full;
    }

    @Override
    public String getContents() throws IOException {
        FileInputStream input = new FileInputStream(this.file);
        try {
            String string = IOUtils.toString(input);
            return string;
        }
        finally {
            input.close();
        }
    }

    @Override
    public ITernFile getRelativeFile(String relativePath) {
        File f = new File(this.file, relativePath);
        return TernResourcesManager.getTernFile(f);
    }

    @Override
    public String getFileExtension() {
        return ExtensionUtils.getFileExtension(this.getFileName());
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass == File.class) {
            return this.file;
        }
        return null;
    }

    public String toString() {
        return this.file.toString();
    }
}

