/*
 * Decompiled with CFR 0.152.
 */
package tern.resources;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import tern.ITernFile;
import tern.ITernFileSynchronizer;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.resources.ITernFileUploader;
import tern.resources.SynchronousTernFileUploader;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.ITernScriptResource;
import tern.server.ITernServer;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernFile;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.TernCompletionsQuery;
import tern.server.protocol.definition.TernDefinitionQuery;
import tern.server.protocol.lint.TernLintQuery;
import tern.utils.StringUtils;

public class TernFileSynchronizer
implements ITernFileSynchronizer {
    private static final int TIMEOUT = 200;
    private static final int MAX_ALLOWED_SIZE = 0xC00000;
    private final ITernProject project;
    private final ITernFileUploader uploader;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Map<String, String> sentFiles = new HashMap<String, String>();
    private final Set<String> toRefresh = new HashSet<String>();
    private final Map<ITernScriptPath, Set<String>> syncedFilesPerPath = new HashMap<ITernScriptPath, Set<String>>();
    private ITernServer targetServer;

    public TernFileSynchronizer(ITernProject project) {
        this.project = project;
        this.uploader = this.createTernFileUploader();
    }

    public ITernFileUploader getTernFileUploader() {
        return this.uploader;
    }

    protected ITernFileUploader createTernFileUploader() {
        return new SynchronousTernFileUploader(this.project);
    }

    @Override
    public ITernProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFailed(TernDoc doc) {
        Set<String> set = this.toRefresh;
        synchronized (set) {
            for (JsonValue val : doc.getFiles()) {
                if (!(val instanceof TernFile)) continue;
                this.toRefresh.add(((TernFile)val).getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Object file) {
        ITernFile tf = TernResourcesManager.getTernFile(file);
        if (tf != null) {
            Set<String> set = this.toRefresh;
            synchronized (set) {
                this.toRefresh.add(tf.getFullName(this.getProject()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanIndexedFiles() {
        this.writeLock.lock();
        try {
            this.sentFiles.clear();
            this.syncedFilesPerPath.clear();
        }
        finally {
            this.writeLock.unlock();
        }
        Set<String> set = this.toRefresh;
        synchronized (set) {
            this.toRefresh.clear();
        }
    }

    @Override
    public void fillSyncedFileNames(JsonArray fileNames, ITernScriptPath path) {
        this.readLock.lock();
        try {
            Set<String> files = path != null ? this.syncedFilesPerPath.get(path) : this.sentFiles.keySet();
            if (files != null) {
                for (String file : files) {
                    fileNames.add(file);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void sizeExceeded() {
        System.out.println(MessageFormat.format("Size of scripts on {0} script path exceeds 12MB. Content assist might be incomplete.", this.getProject().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureSynchronized() {
        TernDoc doc = new TernDoc();
        this.writeLock.lock();
        try {
            if (this.project.getTernServer() != this.targetServer) {
                this.targetServer = this.project.getTernServer();
                this.cleanIndexedFiles();
            }
            this.syncedFilesPerPath.clear();
            HashSet<String> synced = new HashSet<String>(this.sentFiles.keySet());
            HashSet<String> toRefreshLocal = new HashSet<String>();
            Set<String> set = this.toRefresh;
            synchronized (set) {
                toRefreshLocal.addAll(this.toRefresh);
                this.toRefresh.clear();
            }
            synced.removeAll(toRefreshLocal);
            long totalSize = 0L;
            for (String file : synced) {
                totalSize += (long)this.sentFiles.get(file).length();
            }
            block9: for (ITernScriptPath path : this.getProject().getScriptPaths()) {
                HashSet<String> perPath = new HashSet<String>();
                this.syncedFilesPerPath.put(path, perPath);
                for (ITernScriptResource resource : path.getScriptResources()) {
                    if (totalSize >= 0xC00000L) {
                        this.sizeExceeded();
                        continue block9;
                    }
                    ITernFile file = resource.getFile();
                    if (file == null) continue;
                    String name = file.getFullName(this.getProject());
                    perPath.add(name);
                    if (synced.contains(name)) continue;
                    try {
                        TernFile tf = file.toTernServerFile(this.getProject());
                        doc.addFile(tf);
                        synced.add(name);
                        totalSize += (long)tf.getText().length();
                    }
                    catch (IOException e) {
                        this.getProject().handleException(e);
                    }
                }
            }
            toRefreshLocal.removeAll(synced);
            for (String toRemove : toRefreshLocal) {
                doc.delFile(toRemove);
            }
            this.sendFiles(doc);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void synchronizeFile(ITernFile file) throws IOException {
        this.writeLock.lock();
        try {
            TernFile tf = file.toTernServerFile(this.getProject());
            String oldText = this.sentFiles.get(tf.getName());
            if (tf.getText().equals(oldText) && !this.uploader.cancel(tf.getName())) {
                return;
            }
            TernDoc doc = new TernDoc();
            doc.addFile(tf);
            this.sendFiles(doc);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void synchronizeFile(TernDoc doc, ITernFile file) throws IOException {
        this.writeLock.lock();
        try {
            try {
                TernQuery query = doc.getQuery();
                if (query != null) {
                    String queryType;
                    if (TernResourcesManager.isJSFile(file)) {
                        this.addJSFile(doc, file);
                        return;
                    }
                    if (TernResourcesManager.isHTMLFile(file) && (TernCompletionsQuery.isQueryType(queryType = query.getType()) || TernDefinitionQuery.isQueryType(queryType) || query instanceof TernLintQuery)) {
                        this.addHTMLFile(doc, file);
                        return;
                    }
                }
                TernFile tf = file.toTernServerFile(this.getProject());
                String oldText = this.sentFiles.get(tf.getName());
                if (tf.getText().equals(oldText) && !this.uploader.cancel(tf.getName())) {
                    return;
                }
                doc.addFile(tf);
                return;
            }
            finally {
                this.updateSentFiles(doc);
                this.uploader.join(200L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void addJSFile(TernDoc doc, ITernFile file) throws IOException {
        TernQuery query = doc.getQuery();
        String fileName = file.getFullName(this.getProject());
        query.setFile(fileName);
        TernFile tf = file.toTernServerFile(this.getProject());
        doc.addFile(tf);
    }

    protected void addHTMLFile(TernDoc doc, ITernFile file) throws IOException {
        TernQuery query = doc.getQuery();
        TernFile tf = file.toTernServerFile(this.getProject());
        doc.addFile(tf);
        query.set("file", "#" + (doc.getFiles().size() - 1));
    }

    @Override
    public void synchronizeScriptPath(ITernScriptPath path, String ... forced) {
        TernDoc doc = new TernDoc();
        this.writeLock.lock();
        try {
            HashSet<String> requestedFiles = new HashSet<String>(this.sentFiles.keySet());
            HashSet<String> perPath = new HashSet<String>();
            this.syncedFilesPerPath.put(path, perPath);
            requestedFiles.removeAll(Arrays.asList(forced));
            long totalSize = 0L;
            for (String file : requestedFiles) {
                totalSize += (long)this.sentFiles.get(file).length();
            }
            for (ITernScriptResource resource : path.getScriptResources()) {
                if (totalSize >= 0xC00000L) {
                    this.sizeExceeded();
                    break;
                }
                ITernFile file = resource.getFile();
                if (file == null) continue;
                String name = file.getFullName(this.getProject());
                perPath.add(name);
                if (requestedFiles.contains(name)) continue;
                try {
                    TernFile tf = file.toTernServerFile(this.getProject());
                    doc.addFile(tf);
                    totalSize += (long)tf.getText().length();
                    requestedFiles.add(name);
                }
                catch (IOException e) {
                    this.getProject().handleException(e);
                }
            }
            this.sendFiles(doc);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateSentFiles(TernDoc doc) {
        for (JsonValue value : doc.getFiles()) {
            TernFile file;
            if (!(value instanceof TernFile) || !(file = (TernFile)value).isType(TernFile.FileType.full)) continue;
            String contents = file.getText();
            if (StringUtils.isEmpty(contents)) {
                this.sentFiles.remove(file.getName());
                continue;
            }
            this.sentFiles.put(file.getName(), contents);
        }
    }

    protected void sendFiles(TernDoc doc) {
        if (doc.hasFiles()) {
            this.updateSentFiles(doc);
            this.uploader.request(doc);
        }
    }

    protected String getSentFileContent(String file) {
        this.readLock.lock();
        try {
            String string = this.sentFiles.get(file);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.cleanIndexedFiles();
    }
}

