/*
 * Decompiled with CFR 0.152.
 */
package tern.scriptpath.impl;

import tern.ITernFile;
import tern.ITernProject;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.impl.AbstractTernScriptPath;

public abstract class AbstractTernFileScriptPath
extends AbstractTernScriptPath {
    private final ITernFile file;

    public AbstractTernFileScriptPath(ITernProject project, ITernFile file, String externalLabel) {
        super(project, ITernScriptPath.ScriptPathsType.FILE, externalLabel);
        this.file = file;
    }

    protected ITernFile getFile() {
        return this.file;
    }

    @Override
    public String getLabel() {
        String fName = this.file.getFullName(this.getOwnerProject());
        if (fName.startsWith("project://")) {
            fName = fName.substring("project://".length() + 1);
        } else if (fName.startsWith("external://")) {
            fName = fName.substring("external://".length() + 1);
        }
        StringBuilder text = new StringBuilder(this.file.getFileName()).append(" - ").append(fName);
        if (this.getExternalLabel() != null) {
            text.append(" (").append(this.getExternalLabel()).append(")");
        }
        return text.toString();
    }

    @Override
    public String getPath() {
        return this.file.getFullName(this.getOwnerProject());
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == ITernFile.class) {
            return this.file;
        }
        return this.file.getAdapter(clazz);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 17 + this.file.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractTernFileScriptPath) {
            return super.equals(obj) && this.file.equals(((AbstractTernFileScriptPath)obj).file);
        }
        return false;
    }
}

