/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tern.EcmaVersion;
import tern.ITernProject;
import tern.TernException;
import tern.repository.ITernRepository;
import tern.server.AbstractTernServer;
import tern.server.ITernModule;
import tern.server.TernDef;
import tern.utils.IOUtils;

public abstract class AbstractScriptEngineTernServer
extends AbstractTernServer {
    private final String[] ACORN_SCRIPTS = new String[]{"acorn/dist/acorn.js", "acorn/dist/acorn_loose.js", "acorn/dist/walk.js"};
    private final String[] TERN_SCRIPTS = new String[]{"tern/lib/signal.js", "tern/lib/tern.js", "tern/lib/def.js", "tern/lib/comment.js", "tern/lib/infer.js"};

    public AbstractScriptEngineTernServer(ITernProject project) {
        super(project);
    }

    protected TernResources loadTern() throws TernException {
        ITernRepository repository = this.getProject().getRepository();
        if (repository == null) {
            throw new TernException("Tern repository must be initialized.");
        }
        try {
            JsonObject plugins;
            ArrayList<TernResource> scripts = new ArrayList<TernResource>();
            ArrayList<TernResource> defs = new ArrayList<TernResource>();
            int i = 0;
            while (i < this.ACORN_SCRIPTS.length) {
                scripts.add(this.getResource(new File(repository.getNodeModulesDir(), this.ACORN_SCRIPTS[i])));
                ++i;
            }
            i = 0;
            while (i < this.TERN_SCRIPTS.length) {
                scripts.add(this.getResource(new File(repository.getNodeModulesDir(), this.TERN_SCRIPTS[i])));
                ++i;
            }
            EcmaVersion ecmaVersion = super.getProject().getEcmaVersion();
            if (ecmaVersion == null) {
                ecmaVersion = EcmaVersion.ES5;
            }
            switch (ecmaVersion) {
                case ES5: {
                    this.addDef(TernDef.ecma5.getName(), repository, defs, false);
                    break;
                }
                case ES6: {
                    this.addDef(TernDef.ecma5.getName(), repository, defs, false);
                    this.addDef(TernDef.ecma6.getName(), repository, defs, false);
                }
            }
            JsonArray libs = this.getProject().getLibs();
            if (libs != null) {
                for (JsonValue lib : libs) {
                    this.addDef(lib.asString(), repository, defs, true);
                }
            }
            if ((plugins = this.getProject().getPlugins()) != null) {
                ITernModule module = null;
                File pluginFile = null;
                List names = plugins.names();
                for (String name : names) {
                    module = repository.getModule(name);
                    if (module == null || (pluginFile = repository.getFile(module)) == null || !pluginFile.exists()) continue;
                    scripts.add(this.getResource(pluginFile));
                }
            }
            return new TernResources(scripts, defs);
        }
        catch (IOException e) {
            throw new TernException(e);
        }
    }

    protected void addDef(String def, ITernRepository repository, List<TernResource> defs, boolean ignoreEcma) throws IOException {
        File defFile;
        if (ignoreEcma && (def.equals(TernDef.ecma5.getName()) || def.equals(TernDef.ecma6.getName()))) {
            return;
        }
        ITernModule module = repository.getModule(def);
        if (module != null && (defFile = repository.getFile(module)) != null && defFile.exists()) {
            defs.add(this.getResource(defFile));
        }
    }

    protected TernResource getResource(File scriptFile) throws IOException {
        String script = this.getScriptContent(scriptFile);
        String filename = this.getFilename(scriptFile);
        return new TernResource(script, filename);
    }

    protected String getScriptContent(File scriptFile) throws IOException, FileNotFoundException {
        return IOUtils.toString(new FileInputStream(scriptFile), "UTF-8");
    }

    protected String getFilename(File scriptFile) {
        try {
            return scriptFile.getCanonicalPath().toString();
        }
        catch (Throwable throwable) {
            return scriptFile.getPath().toString();
        }
    }

    protected class TernResource {
        private final String content;
        private final String filename;

        public TernResource(String content, String filename) {
            this.content = content;
            this.filename = filename;
        }

        public String getContent() {
            return this.content;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    protected class TernResources {
        private final List<TernResource> scripts;
        private final List<TernResource> defs;

        public TernResources(List<TernResource> scripts, List<TernResource> defs) {
            this.scripts = scripts;
            this.defs = defs;
        }

        public List<TernResource> getScripts() {
            return this.scripts;
        }

        public List<TernResource> getDefs() {
            return this.defs;
        }

        public String getDefsAsString() {
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i < this.defs.size()) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.defs.get(i).getContent());
                ++i;
            }
            return s.toString();
        }
    }
}

