/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import tern.server.ITernModuleInfo;

public class TernModuleInfo
implements ITernModuleInfo {
    private final String name;
    private final String type;
    private final String version;

    public TernModuleInfo(String name) {
        int index = TernModuleInfo.getVersionIndex(name);
        this.name = name;
        if (index != -1) {
            this.type = name.substring(0, index);
            this.version = name.substring(index, name.length());
        } else {
            this.type = name;
            this.version = null;
        }
    }

    public TernModuleInfo(TernModuleInfo info) {
        this.name = info.getName();
        this.type = info.getType();
        this.version = info.getVersion();
    }

    private static int getVersionIndex(String name) {
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isDigit(chars[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o instanceof ITernModuleInfo) {
            ITernModuleInfo module = (ITernModuleInfo)o;
            return this.equals(this.name, module.getName()) && this.equals(this.type, module.getType()) && this.equals(this.version, module.getVersion());
        }
        return false;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

