/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol;

import java.text.MessageFormat;
import tern.TernException;
import tern.server.DefaultResponseHandler;
import tern.server.ITernServer;
import tern.server.protocol.ITernCustomResultsCollector;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernDoc;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.completions.TernCompletionsResultProcessor;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.server.protocol.definition.TernDefinitionResultProcessor;
import tern.server.protocol.guesstypes.ITernGuessTypesCollector;
import tern.server.protocol.guesstypes.TernGuessTypesResultProcessor;
import tern.server.protocol.highlight.ITernHighlightCollector;
import tern.server.protocol.highlight.TernHighlightResultProcessor;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.lint.TernLintResultProcessor;
import tern.server.protocol.outline.ITernOutlineCollector;
import tern.server.protocol.outline.TernOutlineResultProcessor;
import tern.server.protocol.refs.ITernRefCollector;
import tern.server.protocol.refs.TernRefsResultProcessor;
import tern.server.protocol.type.ITernTypeCollector;
import tern.server.protocol.type.TernTypeResultProcessor;

public class TernResultsProcessorsFactory {
    private TernResultsProcessorsFactory() {
    }

    public static <T extends ITernResultsCollector> void makeRequestAndProcess(TernDoc doc, ITernServer server, T collector) throws TernException {
        ITernResultProcessor<T> resultProcesor = TernResultsProcessorsFactory.getProcessor(collector);
        DefaultResponseHandler handler = new DefaultResponseHandler(true);
        server.request(doc, handler);
        Object jsonObject = handler.getData();
        if (jsonObject != null) {
            resultProcesor.process(doc, server.getJSONObjectHelper(), jsonObject, collector);
        }
    }

    private static <T extends ITernResultsCollector> ITernResultProcessor<T> getProcessor(T collector) throws TernException {
        if (collector instanceof ITernCustomResultsCollector) {
            return ((ITernCustomResultsCollector)collector).getResultsProcessor();
        }
        if (collector instanceof ITernCompletionCollector) {
            return TernCompletionsResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernRefCollector) {
            return TernRefsResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernDefinitionCollector) {
            return TernDefinitionResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernTypeCollector) {
            return TernTypeResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernLintCollector) {
            return TernLintResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernGuessTypesCollector) {
            return TernGuessTypesResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernOutlineCollector) {
            return TernOutlineResultProcessor.INSTANCE;
        }
        if (collector instanceof ITernHighlightCollector) {
            return TernHighlightResultProcessor.INSTANCE;
        }
        throw new TernException(MessageFormat.format("Tern results collector {0} does not implement any of the supported interfaces nor does it provide the processor through ITernCustomResultsCollector interface.", collector.getClass().getName()));
    }
}

