/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.completions;

import java.util.ArrayList;
import tern.server.protocol.completions.FunctionInfo;
import tern.server.protocol.completions.Parameter;
import tern.utils.StringUtils;

public class TernTypeHelper {
    public static final String STRING_TYPE = "string";
    public static final String NUMBER_TYPE = "number";
    public static final String BOOL_TYPE = "bool";
    private static final String FUNCTION_REF = "fn";
    private static final String FUNCTION_START = "fn(";
    private static final String FUNCTION_ARRAY_START = "[fn(";

    private TernTypeHelper() {
    }

    public static boolean isFunction(String type) {
        return !StringUtils.isEmpty(type) && (type.startsWith(FUNCTION_START) || type.startsWith(FUNCTION_ARRAY_START));
    }

    public static FunctionInfo parseFunction(String name, String type) {
        type = type.startsWith("[") ? type.substring(1, type.length()) : type;
        StringBuilder signature = name != null ? new StringBuilder(name) : null;
        ArrayList<Parameter> parameters = null;
        StringBuilder currentParamName = null;
        boolean currentParamRequired = true;
        StringBuilder currentParamType = null;
        if (signature != null) {
            signature.append("(");
        }
        int bracket = 0;
        String afterStartFn = type.substring(2, type.length());
        int i = 0;
        i = 0;
        while (i < afterStartFn.length()) {
            char c = afterStartFn.charAt(i);
            switch (c) {
                case '(': {
                    ++bracket;
                    if (currentParamType == null) break;
                    currentParamType.append(c);
                    break;
                }
                case ')': {
                    if (--bracket < 1 || currentParamType == null) break;
                    currentParamType.append(c);
                    break;
                }
                default: {
                    if (bracket < 1) break;
                    if (currentParamType != null) {
                        if (c == ',') {
                            if (bracket < 2) {
                                parameters.add(new Parameter(currentParamName.toString(), currentParamRequired, currentParamType != null ? currentParamType.toString() : null));
                                currentParamName = null;
                                currentParamRequired = true;
                                currentParamType = null;
                                break;
                            }
                            currentParamType.append(c);
                            break;
                        }
                        if (c == ' ') break;
                        currentParamType.append(c);
                        break;
                    }
                    if (currentParamName == null) {
                        if (c == ' ' || c == '?') break;
                        currentParamName = new StringBuilder();
                        currentParamName.append(c);
                        break;
                    }
                    if (c == ':') {
                        if (parameters == null) {
                            parameters = new ArrayList();
                        } else if (signature != null) {
                            signature.append(", ");
                        }
                        if (signature != null) {
                            signature.append(currentParamName.toString());
                        }
                        currentParamType = new StringBuilder();
                        break;
                    }
                    if (c == '?') {
                        currentParamRequired = false;
                        break;
                    }
                    if (c == ' ') break;
                    currentParamName.append(c);
                }
            }
            if (bracket == 0) break;
            ++i;
        }
        if (currentParamName != null) {
            if (parameters == null) {
                parameters = new ArrayList<Parameter>();
            }
            parameters.add(new Parameter(currentParamName.toString(), currentParamRequired, currentParamType != null ? currentParamType.toString() : null));
            currentParamName = null;
            currentParamRequired = true;
            currentParamType = null;
        }
        if (signature != null) {
            signature.append(")");
        }
        StringBuilder s = null;
        int j = i + 1;
        while (j < afterStartFn.length()) {
            char c = afterStartFn.charAt(j);
            if (s != null) {
                s.append(c);
            } else if (c == '>') {
                s = new StringBuilder();
            }
            ++j;
        }
        String returnType = s != null ? s.toString().trim() : null;
        return new FunctionInfo(parameters, signature != null ? signature.toString() : null, returnType);
    }

    public static boolean isStringType(String type) {
        return STRING_TYPE.equals(type);
    }

    public static boolean isNumberType(String type) {
        return NUMBER_TYPE.equals(type);
    }

    public static boolean isBoolType(String type) {
        return BOOL_TYPE.equals(type);
    }

    public static boolean isFunctionRefType(String type) {
        return FUNCTION_REF.equals(type);
    }
}

