/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.html;

import java.util.ArrayList;
import java.util.List;
import tern.server.protocol.html.IState;
import tern.server.protocol.html.Region;
import tern.server.protocol.html.RegionType;
import tern.server.protocol.html.ScriptTagRegion;
import tern.server.protocol.html.State;

class MultiState
implements IState {
    private final List<IState> states;
    private IState currentState;

    public MultiState(ScriptTagRegion[] tagRegions) {
        this.states = new ArrayList<IState>(tagRegions.length);
        int i = 0;
        while (i < tagRegions.length) {
            this.states.add(new State(tagRegions[i]));
            ++i;
        }
        this.reset();
    }

    @Override
    public Region update(char c) {
        Region region = null;
        if (this.currentState != null) {
            region = this.currentState.update(c);
        } else {
            Region current = null;
            for (IState state : this.states) {
                current = state.update(c);
                if (current == null) continue;
                this.currentState = state;
                region = current;
                break;
            }
        }
        return region;
    }

    @Override
    public boolean isNextRegionToFindType(RegionType type) {
        return this.currentState != null ? this.currentState.isNextRegionToFindType(type) : false;
    }

    @Override
    public void reset() {
        this.currentState = null;
        for (IState state : this.states) {
            state.reset();
        }
    }
}

