/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.html;

import tern.server.protocol.html.MatchResult;
import tern.server.protocol.html.RegionType;

public class Region {
    private final char[] pattern;
    private final RegionType type;
    private final String spaces;

    Region(String pattern, RegionType type) {
        this.pattern = pattern.toCharArray();
        this.type = type;
        this.spaces = this.createSpaces();
    }

    private String createSpaces() {
        StringBuilder spaces = new StringBuilder();
        int length = this.getLength();
        int i = 0;
        while (i < length) {
            spaces.append(' ');
            ++i;
        }
        return spaces.toString();
    }

    public MatchResult match(char c, int index) {
        if (index < this.pattern.length && c == this.pattern[index]) {
            return index == this.pattern.length - 1 ? MatchResult.MATCHED : MatchResult.MATCHING;
        }
        return MatchResult.NO_MATCHING;
    }

    public RegionType getType() {
        return this.type;
    }

    public int getLength() {
        return this.pattern.length - 1;
    }

    public String getSpaces() {
        return this.spaces;
    }
}

