/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.html;

import tern.server.protocol.html.IState;
import tern.server.protocol.html.MatchResult;
import tern.server.protocol.html.Region;
import tern.server.protocol.html.RegionType;
import tern.server.protocol.html.ScriptTagRegion;

class State
implements IState {
    private final ScriptTagRegion tagRegion;
    private int index = 0;
    private Region nextRegionToFind;

    public State(ScriptTagRegion tagRegion) {
        this.tagRegion = tagRegion;
        this.nextRegionToFind = tagRegion.getOpenStartScript();
    }

    @Override
    public Region update(char c) {
        MatchResult result = this.nextRegionToFind.match(c, this.index);
        switch (result) {
            case MATCHING: {
                ++this.index;
                break;
            }
            case NO_MATCHING: {
                this.index = 0;
                break;
            }
            case MATCHED: {
                this.index = 0;
                switch (this.nextRegionToFind.getType()) {
                    case OPEN_START_SCRIPT: {
                        this.nextRegionToFind = this.tagRegion.getCloseStartScript();
                        return this.tagRegion.getOpenStartScript();
                    }
                    case CLOSE_START_SCRIPT: {
                        this.nextRegionToFind = this.tagRegion.getEndScript();
                        return this.tagRegion.getCloseStartScript();
                    }
                    case END_SCRIPT: {
                        this.nextRegionToFind = this.tagRegion.getOpenStartScript();
                        return this.tagRegion.getEndScript();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean isNextRegionToFindType(RegionType type) {
        return this.nextRegionToFind.getType() == type;
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

